/*  aisdispat.c -- Dispatcher for on-board AIS devices
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */

#include "viosconf.h"
#include "iopacket.h"
#include "viocmds.h"
#include "viostatus.h"
#include "handlers.h"


    PKT_STATE					/* Throw: Errors from drivers */
ais_dispatcher (cmd, dev, pkt)
    int cmd;
    PDD_PTR dev;
    PKT_PTR pkt;

/* ais_dispatcher (cmd, dev, pkt)
 *	in:	cmd		dispatcher function (PDCREATE / PDREMOVE / etc)
 *	in:	dev		bufptr to physical device descriptor
 *	in:	pkt		bufptr to active i/o packet
 *	return:	(PKT_STATE)	current state of i/o packet
 *	thrown:	(?)		(Drivers may throw errors...see note 1 below)
 *
 *	Main dispatcher for AIS local devices (devices whose physical names
 *	begin with the string "AIS:").  Typically, this dispatcher will not
 *	be called for device creation or removal (PDCREATE or PDREMOVE) with
 *	an active i/o packet, since all device initialization should occur at
 *	initial system startup.
 *
 *	The following should be noted concerning device dispatchers:
 *		1) 'pkt' is assumed to be the i/o packet that is currently
 *		   being dispatched through main_dispatcher() (in viomain.c).
 *		   If this is not the case, if an error condition is thrown,
 *		   it must be caught upstream before
 *		   it reaches main_dispatcher() if it could terminate the
 *		   wrong i/o packet.
 *
 *		2) Device dispatchers are typically called by q2device()
 *		   (in rdwrtsubs.c) which is mostly called by the class
 *		   dispatching modules (blkaddr.c, recseq.c, etc.).
 *		   Those routines should be referred to for more specifics
 *		   on the conditions under which the dispatcher is requested
 *		   when the 'cmd' is STARTIO.
 *
 *		3) A STARTIO request will not be dispatched if the device
 *		   has its current packet non-NULL (Devipkt / Devopkt | Devpkt).
 *		   Therefore, single-request devices must ensure that the
 *		   current packet pointer slot is maintained correctly;
 *		   multi-request devices (e.g. host disk devices) must keep
 *		   that slot (or slots, if full-duplex) clear.
 *
 */
{

/* NOTE: This must be replaced with real dispatching when there's > 1 device */

    switch (cmd)
	{
    case PDCREATE:
	return(tty_create(dev,pkt));

    case PDREMOVE:
	return(tty_remove(dev,pkt));

    case STARTIO:
	switch (Devclass(*dev))
	    {
	case REC_SEQ:
	    switch (Ftype(*pkt))
		{
	    case DEVICE_FUNCTION:
		return(tty_control(dev,pkt));

	    case WRITE_FUNCTION:
		return(tty_write(dev,pkt));

	    case READ_FUNCTION:
		return(tty_read(dev,pkt));

#ifdef DEBUG4   /*************************************************************/
	    default:
	error ("Bad i/o function in ais_dispatcher: %d", Function(*pkt));
#endif /* DEBUG4 *************************************************************/

		} /*switch - Ftype*/

#ifdef DEBUG4   /*************************************************************/
	default:
	error ("Bad device class in ais_dispatcher: %d", Devclass(*dev));
#endif /* DEBUG4 *************************************************************/

	    } /*switch - Devclass*/

#ifdef DEBUG_MAP   /***********************************************************/
    case PDMAPPOOL:
	return(tty_mappool(dev,pkt));
#endif /* DEBUG_MAP ***********************************************************/

#ifdef DEBUG4   /*************************************************************/
    default:
	error ("Bad cmd to ais_dispatcher: %d", cmd);
#endif /* DEBUG4 *************************************************************/

	} /*switch - cmd*/
}
