/*  viosdefs.h -- Define VIOS parameters and special flags
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef VIOSDEFS
#define VIOSDEFS

/* Define some global flags, etc. */

/* Define the configuration module names */
#define AISSTR  "AIS:"		/* Prefix for on-board devices */
#define AISSTRL 4		/* String length of prefix */
#define HOSTSTR "HOST:"		/* Prefix for host devices */
#define HOSTSTRL 5		/* String length of prefix */

/* Define the known Operating System IDs */
#define SIM_ID   0		/* request was generated by Simulator */
#define VIOS_ID  -1		/* request was generated internally by VIOS */
#define HYPER_ID  -2		/* request was generated by Hyper-Executive */
	    								/*??*/
/* Define terminal handler flags */
#define BREAK		-1	/* Break character received */
#define OVERRUN		-2	/* Data overrun */
#define NOCARRIER	-3	/* Carrier detect lost */


/* Define Virtual I/O Request qualifiers */
#define MAX_NAMELENGTH 256	/* longest VDD or PDD name allowed */


#endif
