/*  dplock.S -- Constantly lock host data-page
 *  copyright (c)
 *	Daniel Steinberg
 *	October, 1984
 *
 *	AIS/UNIX-System V.2  code format
 *
 */
	.file	"dplock.S"

#include "3200config.h"

	.text

	.globl	dplock
dplock:
	movqb	HOST_MEMENABLE,@(UART_MAPENABLE + U_SETOUT)	/* enable */

linkwait:
	movw	@HOST_CSR,r0	/* look for iop */
	cmpw	r0,$31		/* connect address? */
	bls	linkwait	/* not yet */

	ord	$HOST_WINDOW,r0	/* set correct map address */
	movqb	0,@HOST_MAP	/* low order 64K bytes */

	movw	0(r0),r1	/* get interrupt vector */

	bpt	/* link made */

	movqw	2,0(r0)		/* set acknowledge */
	movw	r1,@HOST_INT	/* poke host */

	bpt	/* let host clear the acknowledge */

readtx:
	movw	0(r0),r2	/* read transmitted command */
	cmpqw	0,r2		/* none? */
	beq	readcmd
	cmpqw	1,r2		/* last command acknowledge not cleared? */
	beq	readcmd
	cmpqw	6,r2		/* report data-page address? */
	beq	txok		/* yup */

	bpt	/* invalid command */

txok:
	movxwd	4(r0),r2	/* get high order */
	lshd	$16,r2		/* shift to high order */
	orw	2(r0),r2	/* read data-page address */
	cmpd	$0x3a000,r2	/* correct address? */
	beq	txright		/* yup */

	bpt	/* illegal data page address */

txright:
	movqw	1,0(r0)		/* acknowledge command */
	movw	r1,@HOST_INT	/* poke host */

readcmd:
	movw	26(r0),r3	/* get outgoing command */
	cmpqw	0,r3		/* nothing? */
	beq	sndcmd		/* send one out */
	cmpqw	1,r3		/* acknowledge? */
	beq	sndcmd
	cmpqw	6,r3		/* last command not seen yet? */
	beq	readtx		/* skip for now */

	bpt	/* invalid outgoing command */

sndcmd:
	movqw	6,26(r0)	/* send lock data-page command */
	movw	r1,@HOST_INT	/* poke host */
	br	readtx

