;--------------------------------------------------------------------
;
; CB-80 RECORD LOCKING FIXES.                     DATE: 20 OCT 82
;                                             MODIFIED: 12 APR 83
;
; THE FOLLOWING FIXES APPLY TO CB-80 VERSION 1.4 ONLY.  USE WITH
; OTHER VERSIONS WILL PROBABLY MALFUNCTION.
;
; TurboDOS VERSION 1.20 OR LATER IS REQUIRED.  HOWEVER, THIS PATCH
; IS NOT REQUIRED IN TurboDOS VERSION 1.30 OR LATER.
;
; WHEN USING THIS PATCH, ENSURE THAT IN THE .PAR FILES FOR
; THE MASTER PROCESSOR AND ALL OF THE SLAVES:
;
;  CPMVER = 30  ;DEFAULT, ALLOWS CB-80 LOCKING TO FUNCTION.
;  COMPAT = 0F8 ;SET LOGICAL FLAG, OTHERS.  YOU MAY ALSO USE 0B8.
;               ;0F8 CAUSES THE REQUESTOR TO SUSPEND WHEN ANOTHER
;               ;USER HAS LOCKED THE RECORD, 0B8 CAUSES THE NORMAL CB-80
;               ;ERROR RETURNS.
;
; ALSO, PLEASE NOTE THE FOLLOWING ERRORS IN THE CB-80 LANGUAGE MANUAL
; DATED September, 1981 (First Printing):
;
; 1.  PAGE 81 - THE DESCRIPTION OF "OPEN" AND "CREATE" OMITS THE
; KEYWORDS "LOCKED", "UNLOCKED", AND "READONLY", WHICH SHOULD
; APPEAR AFTER THE "AS FILENO%" CLAUSE.  THE DEFAULT MODE IS
; "LOCKED", WHICH CAUSES TurboDOS TO OPEN IN EITHER EXCLUSIVE OR
; PERMISSIVE MODE, ACCORDING TO THE PERMISSIVE BIT IN "COMPAT".
; "UNLOCKED" MUST BE USED FOR SHARED ACCESS, OTHERWISE THE "LOCK"
; AND "UNLOCK" FUNCTIONS RETURN NO ERRORS, AND DO NOT LOCK.
; "READONLY" MAY BE SPECIFIED TO CAUSE THE READ-ONLY FILE INTERFACE
; ATTRIBUTE TO BE SET.
;
; 2.  PAGES 91-93 - THE RETURN CODES FOR "LOCK" AND "UNLOCK" ARE WRONG.
; A ZERO VALUE IS A GOOD RETURN, NON-ZERO IS A BAD RETURN.
;
; NOW, HERE IS THE PATCH FOR THE CB-80 LIBRARY TO FIX THE "ERROR IF" BUG:
;
SET CB80.IRL ;N-RGF
LIB FRONT.REL=CB80.IRL(INIT,ARITH,PRINT,INP)
LIB MIDDLE.REL=CB80.IRL(FILE)
LIB REAR.REL=CB80.IRL(CHAIN,STR,MISC,DIM,MATCH,TRAN)
;
; PLEASE VERIFY THE FOLLOWING CHANGES WHEN PERFORMED BY MONITOR:
;
; AT 047E CHANGE 69 TO 61
; AT 047F CHANGE 58 TO D2
; AT 0480 CHANGE C0 TO E0
;
MONITOR
L MIDDLE.REL
E 47E
61
D2
E0

S MIDDLE.REL
Q
RENAME CB80.IRL CB80-14.ORG
LIB CB80[I]=FRONT,MIDDLE,REAR
SET CB80.IRL ;RG
DDLE.REL
E 47E
61
D2
E0
 
S MIDDLE.REL
Q
RENAME CB80.IRL CB80-14.ORG
LIB CB80[I]=FRONT,MIDDLE,REAR
SET 