#ident "@(#) space.c 1.7 89/03/08 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986, 1987, 1988.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

#include "sioconf.h"

/*
 * board configuration table
 * common boards should be arranged in decreasing order by number of ports
 * arnet board first because it only decodes first 10 io address bits
 * also different boards with overlapping addresses should be arranged
 * in increasing order of addresses
 */
board_t sio_brds[] = {
{0,ARNET_BOARD,8,4,0,  (sd)0x100,0x100+ARNET_POLL,  8,MCRBIT3}, /*arnet 8*/
{0,ARNET_BOARD,4,4,0,  (sd)0x100,0x100+ARNET_POLL,  8,MCRBIT3}, /*arnet 4*/
{0,ARNET_BOARD,2,4,0,  (sd)0x100,0x100+ARNET_POLL,  8,MCRBIT3}, /*arnet 2*/
{0,ARNET_BOARD,8,4,0,  (sd)0x280,0x280+ARNET_POLL,  8,MCRBIT3}, /*arnet 8*/
{0,ARNET_BOARD,4,4,0,  (sd)0x280,0x280+ARNET_POLL,  8,MCRBIT3}, /*arnet 4*/
{0,QUADRAM,    5,4,0,  (sd)0x280,QUADRAM0_POLL,    16,MCRBIT3}, /*quadram 5*/
{0,ARNET_BOARD,2,4,0,  (sd)0x280,0x280+ARNET_POLL,  8,MCRBIT3}, /*arnet 2*/
{0,QUADRAM,    1,4,0,  (sd)0x280,QUADRAM0_POLL,    16,MCRBIT3}, /*quadram 1*/
{0,HOST_BOARD, 8,4,0,  (sd)0x140,0x140+HOSTESS_POLL,8,MCRBIT3}, /*hostess 8*/
{0,HOST_BOARD, 4,4,0,  (sd)0x140,0x140+HOSTESS_POLL,8,MCRBIT3}, /*hostess 4*/
{0,STARGATE,   8,4,0,  (sd)0x290,0x290+STAR_POLL,   8,MCRBIT3}, /*stargate 8*/
{0,STARGATE,   4,4,0,  (sd)0x290,0x290+STAR_POLL,   8,MCRBIT3}, /*stargate 4*/
{0,DIGIBOARD,  8,4,0,  (sd)0x110,0x151,             8,MCRBIT3}, /*digiboard 8*/
{0,DIGIBOARD,  4,4,0,  (sd)0x110,0x151,             8,MCRBIT3}, /*digiboard 4*/
{0,KIMTRON,    4,4,0,  (sd)0x120,0x120|KIMTRON_POLL,8,MCRBIT3}, /*kimtron 4 */
{0,AST_BOARD,  4,4,0,  (sd)0x2a0,0x2a0+AST_POLL,    8,0},       /*ast four*/
{0,TANDON,     4,4,0,  (sd)0x2a0,TANDON0_POLL,      8,MCRBIT3}, /*tandon 4*/
{0,HOST_BOARD, 8,4,0,  (sd)0x500,0x500+HOSTESS_POLL,8,MCRBIT3}, /*hostess 8*/
{0,HOST_BOARD, 4,4,0,  (sd)0x500,0x500+HOSTESS_POLL,8,MCRBIT3}, /*hostess 4*/
{0,HOST_BOARD, 8,4,0,  (sd)0x680,0x680+HOSTESS_POLL,8,MCRBIT3}, /*hostess 8*/
{0,HOST_BOARD, 4,4,0,  (sd)0x680,0x680+HOSTESS_POLL,8,MCRBIT3}, /*hostess 4*/
{0,CTC,	       8,4,0,  (sd)0x160,0x160+CTC_POLL,    8,MCRBIT3}, /*ctc 8AT */
{0,CTC,	       4,4,0,  (sd)0x160,0x160+CTC_POLL,    8,MCRBIT3}, /*ctc 4AT */
{0,AMI_BOARD,  8,4,0,  (sd)0x540,AMI0_POLL,         8,MCRBIT3}, /*AMI 8*/
{0,AMI_BOARD,  4,4,0,  (sd)0x540,AMI0_POLL,         8,MCRBIT3}, /*AMI 4*/
{0,IBM_BOARD,  1,4,0,  (sd)0x3f8,0,                 0,MCRBIT3}, /*ibm COM1*/
{1,ARNET_BOARD,8,3,8,  (sd)0x180,0x180+ARNET_POLL,  8,MCRBIT3}, /*arnet 8*/
{1,ARNET_BOARD,4,3,8,  (sd)0x180,0x180+ARNET_POLL,  8,MCRBIT3}, /*arnet 4*/
{1,ARNET_BOARD,2,3,8,  (sd)0x180,0x180+ARNET_POLL,  8,MCRBIT3}, /*arnet 2*/
{1,ARNET_BOARD,8,3,8,  (sd)0x300,0x300+ARNET_POLL,  8,MCRBIT3}, /*arnet 8*/
{1,ARNET_BOARD,4,3,8,  (sd)0x300,0x300+ARNET_POLL,  8,MCRBIT3}, /*arnet 4*/
{1,ARNET_BOARD,2,3,8,  (sd)0x300,0x300+ARNET_POLL,  8,MCRBIT3}, /*arnet 2*/
{1,HOST_BOARD, 8,3,8,  (sd)0x200,0x200+HOSTESS_POLL,8,MCRBIT3}, /*hostess 8*/
{1,HOST_BOARD, 4,3,8,  (sd)0x200,0x200+HOSTESS_POLL,8,MCRBIT3}, /*hostess 4*/
{1,STARGATE,   8,3,8,  (sd)0x190,0x190+STAR_POLL,   8,MCRBIT3}, /*stargate 8*/
{1,STARGATE,   4,3,8,  (sd)0x190,0x190+STAR_POLL,   8,MCRBIT3}, /*stargate 4*/
{1,DIGIBOARD,  8,3,8,  (sd)0x210,0x250,             8,MCRBIT3}, /*digiboard 8*/
{1,DIGIBOARD,  4,3,8,  (sd)0x210,0x250,             8,MCRBIT3}, /*digiboard 4*/
{1,AST_BOARD,  4,3,8,  (sd)0x1a0,0x1a0+AST_POLL,    8,0},       /*ast four*/
{1,TANDON,     4,3,8,  (sd)0x280,TANDON1_POLL,      8,MCRBIT3}, /*tandon 4*/
{1,AMI_BOARD,  8,3,8,  (sd)0x2c0,AMI1_POLL,         8,MCRBIT3}, /*AMI 8*/
{1,AMI_BOARD,  4,3,8,  (sd)0x2c0,AMI1_POLL,         8,MCRBIT3}, /*AMI 4*/
{1,QUADRAM,    5,3,8,  (sd)0x288,QUADRAM1_POLL,    16,MCRBIT3}, /*quadram 5*/
{1,QUADRAM,    1,3,8,  (sd)0x288,QUADRAM1_POLL,    16,MCRBIT3}, /*quadram 1*/
{1,KIMTRON,    4,3,8,  (sd)0x2e0,0x2e0|KIMTRON_POLL,8,MCRBIT3}, /*kimtron 4  */
{1,HOST_BOARD, 8,3,8,  (sd)0x580,0x580+HOSTESS_POLL,8,MCRBIT3}, /*hostess 8*/
{1,HOST_BOARD, 4,3,8,  (sd)0x580,0x580+HOSTESS_POLL,8,MCRBIT3}, /*hostess 4*/
{1,HOST_BOARD, 8,3,8,  (sd)0x700,0x700+HOSTESS_POLL,8,MCRBIT3}, /*hostess 8*/
{1,HOST_BOARD, 4,3,8,  (sd)0x700,0x700+HOSTESS_POLL,8,MCRBIT3}, /*hostess 4*/
{1,CTC,	       8,3,8,  (sd)0x218,0x218+CTC_POLL,    8,MCRBIT3}, /*ctc 8AT */
{1,CTC,	       4,3,8,  (sd)0x218,0x218+CTC_POLL,    8,MCRBIT3}, /*ctc 4AT */
{1,IBM_BOARD,  1,3,8,  (sd)0x2f8,0,                 0,MCRBIT3}, /*ibm COM2*/
{2,IBM_BOARD,  1,12,4, (sd)0x2f0,0,                 0,MCRBIT3}, /*ibm COM3*/
{2,MITS_BOARD, 4,11, 4,(sd)0x400,0x400+MITS_POLL,  16,MCRBIT3}, /*mitsu 4*/
{3,MITS_BOARD, 4,12,12,(sd)0x408,0x408+MITS_POLL,  16,MCRBIT3}, /*mitsu 4*/
{-1}
};
