:
#
# MKUSERS: Create user accounts in a batch fashion under
# Altos UNIX System V/386.  This script works only if the
# system is configured with relaxed security.  You must be
# logged in as "root" to run this script.  The default password
# for the new accounts is "orange".  The new users created
# will have default general system priviledges.
#
# Author: Ti Kan
#
# Usage: mkusers n name_base dir_base uid_base gid
#
# Example: mkusers 100 foo /usr 5000 20
# will create 100 accounts foo000 through foo099, with uid range of
# 5000..5099, gid of 20, and home directories in the /usr directory.
#

#ident "@(#)mkusers.sh	1.1 91/02/08"

# Functions

do_pwdf() {
	echo "${name_base}${1}:*:${2}:${3}:${name_base}${1}:${dir_base}/${name_base}${1}:/bin/sh" >> /etc/passwd
}

do_tcb() {
	letter=`echo ${name_base} | awk '{ printf("%s", substr($1,0,1)) }'`
	echo "${name_base}${1}:u_name=${name_base}${1}:u_id#${2}:u_pwd=${password}:u_type=general:u_succhg#000000000:u_pswduser=${name_base}${1}:u_lock@:chkent:" > /tcb/files/auth/${letter}/${name_base}${1}
}

do_dirs() {
	cd ${dir_base}
	mkdir ${name_base}${1}
	chown ${name_base}${1} ${name_base}${1}
}

do_auth() {
	echo ${name_base}${1} >> /etc/auth/subsystems/dflt_users
}

# Main code starts here

PATH=/bin:/usr/bin:/etc; export PATH
trap ":" 1 2 3 5 15

if [ $# -ne 5 ]
then
	echo "usage: $0 num_users name_base dir_base uid_base gid"
	exit 1
fi

if [ "`logname`" != "root" ]
then
	echo "You must be logged-in as root to use this utility."
	exit 2
fi

nusers=$1
name_base=$2
dir_base=$3
uid_base=$4
gid=$5
password="BCwi7/RX75K7A"	# encrypted password for "orange"

if [ ! -d ${dir_base} ]
then
	mkdir -p ${dir_base}
fi

num=0
uid=$uid_base

while [ $num -lt $nusers ]
do
	index=`echo $num | awk '{ printf("%0.3d", $1) }'`
	if grep "^${name_base}${index}" /etc/passwd > /dev/null 2>&1
	then
		echo "Account \"${name_base}${index}\" already exists."
	else
		do_pwdf $index $uid $gid
		do_tcb $index $uid
		do_dirs $index
		do_auth $index
	fi
	num=`expr $num + 1`
	uid=`expr $uid + 1`
done
exit 0
