/*
 * 'squares' - Altos Computer Systems
 *
 * Other than just keeping the terminal (and drivers) busy and
 * simply looking cool, 'squares' is a good test for dropped
 * characters. Since the cursor bounces around using escape
 * sequences, dropped characters show up as junk on the screen.
 *
 * @(#)squares.c	1.4 90/08/21
 */

#include "stdio.h"
#include "signal.h"


/* inline rand() and srand() */
unsigned long randx;
#define srand(x) randx = x
#define rand() (unsigned)((randx = randx * 1103515245L + 12345L) >> 16)

/*
 * 'fast' stdio replacement for special cases (assumes local register
 *  variable *stdio) no error checking or error returns.
 */
#define MAXFLUSHCNT 512
int ccnt;	/* cnt of chars to write on fflush */
#define fflush(junk) {write(1, tbuf, ccnt); ccnt = 0;}
#undef putchar
#define putchar(c) tbuf[ccnt++] = c
#define fputs(string, junk) {stdio = string;  \
                             while(*stdio)  tbuf[ccnt++] = *stdio++;}
#define goto(x, y) fputs(cpos[y][x], stdout);


extern       sig();
extern int   optind;
extern char *optarg;
extern char  getopt();
char        *getenv(), *tgetstr();
char         tbuf[3*MAXFLUSHCNT], *cl, *curon, *curoff;

/* array that contains the cursor positioning strings */
char         cpos[24][80][16];

int          zone, zone_2;
int          dir,endline;
int          _Y_, _X_;
short        benice      = 1;
short        flushcnt    = 512;
char         char_list[] = "%#$*&+ ! ";
char        *options     = "f:n?";
char         spot;

/*
 * Brought to you by the Pick people,
 * modified by Dave Olson,
 *             Andy Hatcher,
 *             Alan Char,
 *             Larry Snyder,
 *             etc.
 */
main(ac, av)
int    ac;
char **av;
{
	register int start,end,inc;
	char c;

	while ( (c=getopt(ac, av, options) ) != -1 ) {
		switch (c) {
		case 'f':
			flushcnt = atoi( optarg );
			if (!flushcnt || (flushcnt > MAXFLUSHCNT) )
				flushcnt = MAXFLUSHCNT;
			break;
		case 'n':
			benice = 0;
			break;
		case '?':
		default:
			usage( av[0] );
			exit(0);
		}
	}

	do_init();

	while (1) {
		spot  = char_list[rand() % 9];		/* char in char_list */
		_Y_   = (6 + ((rand() % 2) * 12));	/* 1 of 6 squares */
		_X_   = (13 + ((rand() % 3) * 27));
		start = (rand() % 6);				/* start zone in sqr */
		if(start)
			end = rand() % 6;				/* end zone in sqr */
		else
			end = 5;						/* outside if middle */
		inc   = 1 - (2 * (start > end));	/* in or out */
		for ( zone = start ; zone <= end ; zone += inc ) {
			zone_2  = zone << 1;
			endline = start ? zone_2 : 0;	/* special case cntr */
			doit();
			if(ccnt >= flushcnt)
				fflush(stdout);
		}
		if (ccnt >= flushcnt)
			fflush(stdout);
	}
}

do_init()
{
	register char *stdio;	/* for fputs() macro */
	long time();

	init_curs();

	if ( signal(SIGINT, SIG_IGN) != SIG_IGN )
		signal(SIGINT, sig);
	if ( signal(SIGQUIT, SIG_IGN) != SIG_IGN )
		signal(SIGQUIT, sig);
	if ( signal(SIGTERM, SIG_IGN) != SIG_IGN )
		signal(SIGTERM, sig);

	if ( curoff && *curoff )
		fputs(curoff, stdout);

	if ( cl && *cl )
		fputs(cl, stdout);

	if ( benice )
		nice(5);	/* nice so we don't bug others */
 
	srand( time(0L) );
}


doit()
{
	register char *stdio;	/* for fputs() macro */
	register k;
	register kk;
	register int a,b,c,d;

	a   = _X_ - zone_2;		/* four corners */
	b   = _X_ + zone_2;
	c   = _Y_ - zone;
	d   = _Y_ + zone;
	dir = (rand() % 2);

	for( k=0; k <= endline; k++ ) {
		kk = k << 1;		/* 1 row = 2 cols */
		if ( dir ){
			goto( a + kk,c );
			putchar( spot );
			goto( b,c + k );
			putchar( spot );
			goto( b - kk,d );
			putchar( spot );
			goto( a,d - k );
			putchar( spot );
		}
		else {
			goto( a,c + k );
			putchar( spot );
			goto( b - kk,c );
			putchar( spot );
			goto( b,d - k );
			putchar( spot );
			goto( a + kk,d );
			putchar( spot );
		}
	}
}

sig()
{
	register char *stdio;
	if ( curon && *curon )
		fputs( curon, stdout );

	if ( cl && *cl )
		fputs( cl, stdout );
	fflush( stdout );
	exit( 0 );
}

/* this routine is used only by init_curs() */
void outc(c)
char c;
{
	putchar( c );
}

/* no matter how large or small terminal is, uses 24*80.  Build a
	table of the cursor positioning strings for later speed. */
init_curs()
{
	char *tgoto();
	char capbuf[400], termbuf[2048], *str, *cm;
	register col, line;

	str = getenv("TERM");
	if ( str == NULL) {
		printf("Oops, no TERM variable in environment\n");
		exit(1);
	}

	if ( tgetent(termbuf, str) == -1 ) {
		printf("Oops, no can't find terminal %s in termcap\n", str);
		exit(1);
	}

	str = capbuf;
	cm = tgetstr("cm", &str);
	if ( !cm || *cm == '\0' ) {
		printf("Sorry, no cursor motion capablity\n");
		exit(1);
	}

	if ( tgetnum("li") < 24 || tgetnum("co") < 80 ) {
		printf("Sorry, must be at least 24 lines by 80 columns\n");
		exit(1);
	}

	cl     = tgetstr("cl", &str);
	curon  = tgetstr("vs", &str);
	curoff = tgetstr("vi", &str);

	for( col=0; col<80; col++ )
		for( line=0; line<24; line++ ) {
			ccnt = 0;
			tputs(tgoto(cm, col, line), 1, outc);
			if ( ccnt >= 16 ) {
				printf("Sorry, cursor positioning string too long\n");
				exit(1);
			}
			memcpy(cpos[line][col], tbuf, ccnt);
			ccnt = 0;
		}
}

usage( av0 )
char *av0;
{
	printf("usage: %s  [-n][-fFLUSHSZ]\n", av0 );
}
