#ident	"@(#)82596.h	1.2	90/08/08"
/* @(#)82596.h	1.4 90/04/13 */ 

#define A596VtoP(x)	((x) == NULL ? NULL596 : kvtophys(x))
#define A596PtoV(x)	((x) == NULL596 ? NULL : phystokv(x))

#define	EADDRSIZE	6	/* size of the MAC address */
#define	ETYPESIZE	2	/* size of the type/length field */
#define ETHER_MTU	1500	/* maximum size of an ethernet packet */
#define ETHER_MIN	46	/* minimum size of an ethernet packet */
#define MC_CNT		16	/* maximum allowable multicast addresses */
#define MC_BIT		1	/* bit to identify multicast addresses in */
				/* the ethernet address */

/*
*	Board Specific defines
*/

#define RBUFSIZE	0x80	/* Receive Buffer size */ 
#define	N_RFDS		0x80	/* Number of Receive Frame Descriptors */
#define	N_RBUFS		0x180	/* Number of Receive Frame Descriptors */

#define TBUFSIZE	ETHER_MTU	/* Transmit Buffer size */ 
#define	N_TBUFS		0x4	/* Number of Transmit Buffers */

#define DUMP_AREA	0x200	/* Return area for a dump cmd - Largest */
				/* buffer required by a 82596 command */

#define CSW		0x40	/* sysbus defines */
#define INT_LOW		0x20
#define NO_BUS_LK	0x10
#define EXT_TRG		0x8
#define LINEAR		0x4
#define SEGMENT		0x2
#define COMPAT		0x0

#define T_ON		0xe0	/* maximum bus hold time = 14 us */
#define T_OFF		0x8	/* maximum bus release hold time = .5 us */

#define PORT_MASK	~0xf	/* mask off the PORT command nibble */
#define PORT_RESET	0	/* PORT reset */
#define PORT_TEST	1	/* PORT self test */
#define PORT_SCP	2	/* PORT alternate SCP */
#define PORT_DUMP	3	/* PORT alternate dump */

#define ENET_PORT	0xcd0	/* io base address of enet on the base io */
#define SPIGOT_THERE	0x1	/* Is the daughter board (spigot) there? */
#define THICKNET	0x2	/* AUI interface */
#define THINNET		0x4	/* cheapernet interface */
#define TWISTED		0x8	/* twisted pair interface */
#define ENET_V1		0x80	/* Ethernet version 1 (no heartbeat) */

#define ENET_DMA	DMA_CH7	/* DMA channel */

#define SPIN_TIME	0xf0000	/* time to wait for the 82596 to update the */
				/* control structures.  Chosen to be several */
				/* orders of magnitude larger than the real */
				/* time so faster processors can use this */


/*
* Constants and structs specific to the Intel 82596 Ethernet controller
*/

/*
* Commands
*/

#define NOP			0x00
#define IA_SETUP		0x01
#define CONFIG			0x02
#define MC_SETUP		0x03
#define TRANSMIT		0x04
#define TDR			0x05
#define DUMP			0x06
#define DIAGNOSE		0x07
#define FLEX_MODE		0x08
#define CRC_INSERT		0x10
#define CB_CMD_MASK		0x07

#define SCB_STAT_MASK		0xf000
#define SCB_CX			0x8000
#define SCB_FR			0x4000
#define SCB_CNA			0x2000
#define SCB_RNR			0x1000

#define CUS_MASK		0x700
#define CUS_IDLE		0x0
#define CUS_SUSP		0x100
#define CUS_ACT			0x200

#define RUS_MASK		0xf0
#define RUS_IDLE		0x0
#define RUS_SUSP		0x10
#define RUS_NRSC		0x20
#define RUS_RDY			0x40
#define RUS_NRBD		0x80
#define RUS_NRSCRBD		0xa0

#define BUS_LOADED		0x8

#define CU_NOP			0x0
#define CU_START		0x100
#define CU_RESUME		0x200
#define CU_SUSPEND		0x300
#define CU_ABORT		0x400
#define CU_BUS_CHANGE		0x500
#define CU_BUS_START		0x600

#define RU_NOP			0x0
#define RU_START		0x10
#define RU_RESUME		0x20
#define RU_SUSPEND		0x30
#define RU_ABORT		0x40

#define CB_C			0x8000
#define CB_B			0x4000
#define CB_OK			0x2000
#define CB_A			0x1000

#define CB_EL			0x8000
#define CB_S			0x4000
#define CB_I			0x2000 

#define TFD_LATE_COLL		0x800
#define TFD_NOCRS		0x400
#define TFD_NOCTS		0x200
#define TFD_DMA			0x100
#define TFD_DEFER		0x80
#define TFD_SQE			0x40
#define TFD_RETRY		0x20
#define TFD_COLL_MASK		0xf

#define RFD_LENGTH		0x1000
#define RFD_CRC			0x800
#define RFD_ALIGN		0x400
#define RFD_NORSC		0x200
#define RFD_DMA			0x100
#define RFD_MIN			0x80
#define RFD_NOEOF		0x40
#define RFD_TRUNC		0x20
#define RFD_IA			0x2
#define RFD_COLL		0x1

#define BD_EOF			0x8000
#define BD_F			0x4000
#define BD_CNT_MASK		0x3fff
#define BD_EL			0x8000
#define BD_P			0x4000
#define BD_SIZE_MASK		0x3fff

#define NULL596			0xffffffff

#pragma pack (1)

struct eaddr {
	ushort	saddr;
	uint	laddr;
};

struct scp {
	short	zero;
	unchar	sysbus;
	char	fill[5];
	uint	iscp_address;
};

struct iscp {
	uint	busy;
	uint	scb_addr;
};

struct scb {
	ushort	status;
	ushort	command;
	uint	cbl_addr;
	uint	rfa_addr;
	uint	crc_errs;
	uint	aln_errs;
	uint	rsc_errs;
	uint	ovrn_errs;
	uint	rcvcdt_errs;
	uint	shrtfrm_errs;
	ushort	t_off;
	ushort	t_on;
};

struct cmd_cb {
	ushort	status;
	ushort	command;
	uint	link_addr;
};

struct nop_cb {
	ushort	status;
	ushort	command;
	uint	link_addr;
};

struct ia_setup_cb {
	ushort	status;
	ushort	command;
	uint	link_addr;
	struct eaddr host_addr;
	short	fill;
};

struct config_cb {
	ushort	status;
	ushort	command;
	uint	link_addr;
	unchar	params[16];
};

struct mc_setup_cb {
	ushort	status;
	ushort	command;
	uint	link_addr;
	ushort	mc_cnt;
	struct eaddr mc_id[MC_CNT];
};

struct tdr_cb {
	ushort	status;
	ushort	command;
	uint	link_addr;
	uint	tdr_result;
};

struct dump_cb {
	ushort	status;
	ushort	command;
	uint	link_addr;
	uint	dump_area_addr;
};

struct diagnose_cb {
	ushort	status;
	ushort	command;
	uint	link_addr;
};

struct tfd {
	ushort	status;
	ushort	command;
	uint	link_addr;
	uint	tbd_addr;
	int	tcb_count;
	struct eaddr dest_addr;
	ushort	length;
	unchar	align;
};

struct tbd {
	int	status;
	uint	tbd_addr;
	uint	tbuf_addr;
};

struct tbuf {
	struct eaddr dest_addr;
	ushort	length;
	unchar	buf[TBUFSIZE];
};

union cb {
	struct cmd_cb cmd_cb;
	struct nop_cb nop;
	struct ia_setup_cb ia_setup; 
	struct config_cb config;
	struct mc_setup_cb mc_setup;
	struct tdr_cb tdr;
	struct dump_cb dump;
	struct diagnose_cb diagnose;
	struct tfd tfd;
};

struct rfd {
	ushort	status;
	ushort	command;
	uint	link_addr;
	uint	rbd_addr;
	ushort	count;
	ushort	size;
	struct eaddr dest_addr;
	struct eaddr src_addr;
	ushort	length;
	ushort	fill;
};

struct rbd {
	int	status;
	uint	rbd_addr;
	uint	rbuf_addr;
	int	size;
};

struct rbuf {
	unchar	buf[RBUFSIZE];
};

#pragma pack ()
