#ident "@(#)Stp.h	2.2 91/01/25"
#ifndef _SYS_STP_H
#define _SYS_STP_H
#ident "@(#)Stp.h	1.8 90/03/28"
#ident	"@(#) Stp.h 22.1 89/10/11 "

/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

/*
 * SCSI tape driver
 *
 *	A000	panas	11/20/89
 *	- increase number of drives supported by driver to 8
 *	A001	panas	11/29/89
 *	- add VAR flag in minor device number for variable length devices
 *	A002	altos\!steve	03/28/90
 *	- added stuff for low, medium and high density devices
 *
 */

/* #define SCSI_DEBUG */
#ifdef SCSI_DEBUG
# define private
# define DPRINT(a)  printf a
#else
# define private static
# define DPRINT(a)
#endif

#define SPL spl6
#define SCT_MEMGRAN	1		/* memory granularity */
#define SCT_MAXMEM	(128*1024)	/* 128K */
#define SCT_MINMEM	(32*1024)	/* 16K */
#define SCT_MEMCHUNK	(2*1024)	/* 2K  */
/* define the largest block size we can use to be 64K.
 * this is an arbitrary limit for adapters that do 1st-party
 * dma, but should be the practical limit for 'dumb' adapters
 * that use the standard dma controller.
 */
#define STP_BMAX	(64*1024)	/* 64K */

struct Stp_flags_t {
	unsigned int open:1;
	unsigned int reset:1;
	unsigned int wprot:1;
	unsigned int read:1;
	unsigned int write:1;
	unsigned int filemark:1;
	unsigned int eom:1;
	unsigned int eof:1;		/* end of file flag */
	unsigned int blank:1;		/* blank check error */
	unsigned int error:1;
	unsigned int active:1;
	unsigned int fixed:1;		/* fixed-length blocks */
};
extern struct Stp_flags_t Stp_flags[];
extern struct ndevbuf Stp_ndb[];
extern int Stp_dataf[],Stp_compf[];

#pragma pack(1)

/* mode select and mode sense always include the header,
 * then 0 or more block descriptors, then 0 or more pages.
 */

struct Stp_block_descr {
	char density;
	char num_blks[3];
	char reserved;
	char blk_len[3];
};

struct Stp_vendor_unique {
	char page_code;
	char write_threshold;
	char read_threshold;
	char reserved1;
	char streaming_cnt[2];
	char bus_threshold;
	char copy_threshold;
	char reserved2;
	char copy_sense;
	char load_func;
	char auto_ld_rtn_delay;
	unsigned char fast:1;
	unsigned char dcr:1;
	unsigned char dads:1;
	unsigned char ard:1;
	unsigned char reserved3:4;
};

struct Stp_mode_sense {
	unsigned char data_len;
	unsigned char medium;
	unsigned char speed	:4;
	unsigned char buffered	:3;
	unsigned char wprot	:1;
	unsigned char bdescr_len;
	struct Stp_block_descr bdescr;
};

struct wa_Stp_mode_sense {
	unsigned char data_len;
	unsigned char medium;
	unsigned char speed:4;
	unsigned char buffered:3;
	unsigned char wprot:1;
	unsigned char bdescr_len;
};

struct scsi_inq_data {
	unsigned char dev	 :5;
	unsigned char qual	 :3;
	unsigned char dev_qual	 :7;
	unsigned char rmb	 :1;
	unsigned char ansi	 :3;	
	unsigned char ecma	 :3;
	unsigned char iso	 :2;
	unsigned char response	 :4;
	unsigned char reserved	 :3;
	unsigned char aenc	 :1;
	unsigned char addl_len;
	unsigned char reserved2[2];
	unsigned char stuff;
	unsigned char vendor_id[8];
	unsigned char product_id[16];
	unsigned char product_level[4];
};

struct Stp_block_limit {
	unsigned char reserved;
	unsigned char max[3];
	unsigned char min[2];
};

#pragma pack()

struct page_11 {				/* mode select page 11 */
	struct Stp_mode_sense s;
	unsigned char data[10];
};

#define SCT_64K 0xffff
#define SCT_BSIZE 512
#define SCT_512 0x1ff
#define SCT_BMASK 0x1ff

#define MAX(a,b) (((a)>(b))?(a):(b))
#define MIN(a,b) (((a)>(b))?(b):(a))
#define B_ROUND_U(dev,a) (((a)&(~Stp_bmask[DEVNO(dev)]))+(((a)&(Stp_bmask[DEVNO(dev)]))?Stp_bsize[DEVNO(dev)]:0))
#define B_ROUND_D(dev,a) ((a) & (~Stp_bmask[DEVNO(dev)]))
/* sequential access devices */

#define SCSI_S_SPACE 	0x11
#define SCSI_S_REWIND 	0x01
#define SCSI_S_READ	0x08
#define SCSI_S_WRITE	0x0a
#define SCSI_S_LOAD	0x1b
#define SCSI_S_ERASE	0x19
#define SCSI_S_WFM	0x10
#define SCSI_S_RD_BLIM	0x05
#define SCSI_S_SEEK	0x0c
#define SCSI_S_MODE_SEN	0x1a
#define SCSI_S_MODE_SEL 0x15
#define SCSI_S_TEST_RDY	0x00
#define SCSI_S_INQ	0x12

#define SCT_READ   1
#define SCT_WRITE  0

#define DEVDENSITY(dev)	((minor(dev) >> 5) & 3)
#define DEVNO(dev)	(minor(dev)&0x07)
#define NDRIVES 8

/* minor device number bit definitions */

#define	SELECT0		0x01		/* Select drive 0                    */
#define	SELECT1		0x02		/* Select drive 1		     */
#define	SELECT2		0x04		/* Select drive 2		     */
#define	NOREWIND	0x08		/* no rewind device		     */
#define	VAR		0x10		/* variable length device	     */
#define DENSBIT0	0x20		/* data density low bit		     */
#define	DENSBIT1	0x40		/* data density high bit	     */
#define	OVERRIDE	0x80		/* maintenance device		     */

#define	MAXBSIZE	65535		/* Max block size for 9-track	     */
#endif	/* _SYS_STP_H */
