#ident	"@(#)a586.h	1.2	90/08/08"
/* @(#)a586.h	1.2 90/04/13 */ 

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

/*
* Constants and structs specific to this driver
*/

#define	A586MID		586		/* A586 Module ID */
#define	NO_BOARD	0
#define	ACPA_AT		1
#define	ACPA_PC 	2	

/* multicast address list */

struct mc_list {
	int	mc_count;
	struct lli_sap *mc_sap_p[MC_CNT];
	struct eaddr mc_id[MC_CNT];
};

/* Statistics structure */

struct a586stats {
	uint allocfails;
	uint badintr;
	uint badrstat;
	uint colls;
	uint crcerrs;
	uint ethwput;
	uint etint;
	uint etqueue;
	uint fifoorun;
	uint fifourun;
	uint fralignerrs;
	uint heartbeat;
	uint missintr;
	uint misspkts;
	uint no_crs;
	uint no_cts;
	uint overwr;
	uint owcolls;
	uint restarts;
	uint rdmaint;
	uint rxct;
	uint sftpkts;
	uint txct;
	uint txdefer;
	uint txerrs;
};

/*
*	a586device - device descriptor
*
* This structure describes the ACPA/AT device.  One exists for each board
* in the system.
*/

struct a586device {
	int	bd_type;	/* Unit board type */
	int	unit;		/* Unit number */
	int 	io_addr;	/* I/O space base address */
	int	phys_addr;	/* Physical memory address on the AT bus */
	int	phys_addr_size;	/* Physical memory size on the AT bus */
	int	ivect;		/* interrupt vector */
	char	*virt_addr;	/* virtual address of board from sptalloc */
	int	cmd_timer;	/* -1 no cmd, 0 reset, >0 running */
	int	bad_intr_cnt;	/* Count the bad interrupts, then reset */
	int	open_count;	/* ++ each open and -- each close */
	struct {
	 unsigned present : 1;
	 unsigned thicknet : 1;
	} config;		/* configuration options */
	struct {
	 unsigned up : 1;
	 unsigned functional : 1;
	 unsigned cu_busy : 1;
	} status;			/* operational status */
	struct lli_sap	*lli_sap_p;	/* list of Ethernet bound streams */

	struct lli_sap	*xmt_head;
	struct lli_sap	*xmt_tail;
	struct scp	*scp_p;
	struct iscp	*iscp_p;
	struct scb	*scb_p;
	char		*rtn_p;
	union cb	*cb_p;
	struct tbd	*tbd_p;
	struct tbuf	*tbuf_p;
	struct rfd	*rfd_p;
	struct rbd	*rbd_p;
	struct rbuf	*rbuf_p;
	int	n_rbufs;

	struct rfd	*begin_rfd;	/* keeps tabs of fd */
	struct rfd	*end_rfd;
	struct rbd	*begin_rbd;	/* ditto, see rcv_ & xmt_packet */
	struct rbd	*end_rbd;
	struct eaddr	eaddr;	/* enet host id */
	struct mc_list	mc_list;	/* multicast addresses */
	uint	cmd_port;		/* ACPA command port value */ 

	struct ifstats		ifs;	/* Berkeley style interface stats */
	struct a586stats	a586stats;	/* local interface stats */
};

/*
* 
*/

struct lli_sap {
	struct lli_sap	*next_p;
	struct lli_sap	*xmt_queue;
	queue_t	*read_q;
	struct a586device	*dev_p;
	long	current_state;
	long	subnet_type;
	long	dlsap;
	short	unit;
	ushort	min_dev;
}; 
