#ident	"@(#)conf.h	1.2	90/08/08"
#ifndef _SYS_CONF_H
#define _SYS_CONF_H
#ident "@(#) conf.h 22.3 90/05/30 "
#ident "@(#)conf.h	1.3 90/03/19"
#ident "@(#) conf.h 1.9 89/07/27 "
/*
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 *
 *      Portions Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989, 1990.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/*
 * Declaration of block device switch. Each entry (row) is
 * the only link between the main unix code and the driver.
 * The initialization of the device switches is in the file conf.c.
 */
struct bdevsw {
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_strategy)();
	int	(*d_print)();
	char	 *d_name;
	struct iobuf	*d_tab;
};
extern struct bdevsw bdevsw[];

/*
 * defines for MPX.
 */
#define DIST_BDEV_OPEN		0x01
#define DIST_BDEV_CLOSE		0x02
#define DIST_BDEV_STRATEGY	0x04
#define DIST_BDEV_PRINT		0x08

#define DIST_BDEV_DRIVE32	0x20000000
/*
 * currently only the ATtack architecture uses the following
 */
#define DIST_BDEV_SCATTERGATHER	0x40000000
#define DIST_BDEV_NOMAPS	0x80000000

/*
 * Character device switch.
 */
struct cdevsw {
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_ioctl)();
	struct tty *d_ttys;
	struct streamtab *d_str;
	char	 *d_name;
};
extern struct cdevsw cdevsw[];

/*
 * defines for MPX
 */
#define DIST_CDEV_OPEN		0x01
#define DIST_CDEV_CLOSE		0x02
#define DIST_CDEV_READ		0x04
#define DIST_CDEV_WRITE		0x08
#define DIST_CDEV_IOCTL		0x10

/*
 * And the console co routine.  This is declared as
 * a configuration parameter so that it can be changed
 * to match /dev/console.
 */
struct	conssw {
	int	(*co)();
	int	co_dev;
	int	(*ci)();
};

extern struct conssw conssw[];

#define	FMNAMESZ	8

struct fmodsw {
	char	f_name[FMNAMESZ+1];
	struct  streamtab *f_str;
};
extern struct fmodsw fmodsw[];

extern int	bdevcnt;
extern int	cdevcnt;
extern int	fmodcnt;

/*
 * Line discipline switch.
 */
struct linesw {
	int	(*l_open)();
	int	(*l_close)();
	int	(*l_read)();
	int	(*l_write)();
	int	(*l_ioctl)();
	int	(*l_input)();
	int	(*l_output)();
	int	(*l_mdmint)();
};
extern struct linesw linesw[];

extern int	linecnt;
/*
 * Terminal switch
 */
struct termsw {
	int	(*t_input)();
	int	(*t_output)();
	int	(*t_ioctl)();
};
extern struct termsw termsw[];

extern int	termcnt;

/*file system switch structure */
struct fstypsw {
/* 0*/	int		(*fs_init)();
/* 1*/	int		(*fs_iput)();
/* 2*/	struct inode	*(*fs_iread)();
/* 3*/	int		(*fs_filler)();
/* 4*/	int		(*fs_iupdat)();
/* 5*/	int		(*fs_readi)();
/* 6*/	int		(*fs_writei)();
/* 7*/	int		(*fs_itrunc)();
/* 8*/	int		(*fs_statf)();
/* 9*/	int		(*fs_namei)();
/*10*/	int		(*fs_mount)();
/*11*/	int		(*fs_umount)();
/*12*/	struct inode	*(*fs_getinode)();
/*13*/	int		(*fs_openi)();		/* open inode */
/*14*/	int		(*fs_closei)();		/* close inode */
/*15*/	int		(*fs_update)();		/* update */
/*16*/	int		(*fs_statfs)();		/* statfs and ustat */
/*17*/	int		(*fs_access)();
/*18*/	int		(*fs_getdents)();
/*19*/	int		(*fs_allocmap)();	/* Let the fs decide if */
						/* if can build a map so */
						/* this fs can be used for */
						/* paging */
/*20*/	int		*(*fs_freemap)();	/* free block list */
/*21*/	int		(*fs_readmap)();	/* read a page from the fs */
						/* using the block list */
/*22*/	int		(*fs_setattr)();	/* set attributes */
/*23*/	int		(*fs_notify)();		/* notify fs of action */
/*24*/	int		(*fs_fcntl)();		/* fcntl */
/*25*/	int		(*fs_fsinfo)();		/* additional info */
/*26*/	int		(*fs_ioctl)();		/* ioctl */
/*27*/	int		(*fs_security)();	/* security functions */
/*28*/	int		(*fs_fill[4])();
};
extern struct fstypsw fstypsw[];
extern short nfstyp;


/* FS specific data */
struct fsinfo {
	long		fs_flags;	/* flags - see below */
	struct mount	*fs_pipe;	/* The mount point to be used */
					/* as the pipe device for */
					/* this fstyp */
	char		*fs_name; 	/* Pointer to fstyp name */
					/* See above */
	long		fs_notify;	/* Flags for fs_notify */
					/* e.g., NO_CHDIR, NO_CHROOT */
					/* see nami.h */
};
extern struct fsinfo fsinfo[];

/*
 * Declarations supporting the event-devices switch
 */
struct evdevsw {			/* event devices */
	char *devnam;			/* device name */
	int (*eventizer)();		/* eventizing routine */
};

/*
 * Driver configuration structure (used in space.c files)
 */
struct dev_cfg {
	unsigned char valid;	/* board is present */
	unsigned char chan;	/* DMA channel */
	unsigned char vect;	/* interrupt vector */
	unsigned char pad;	/* unused */
	unsigned long sioa;	/* first I/O port address */
	unsigned long scma;	/* first controller memory address */
};
#endif	/* _SYS_CONF_H */
