#ident	"@(#)dda.h	1.2	90/08/08"
#ifndef _SYS_DDA_H
#define _SYS_DDA_H
#ident "@(#) dda.h 22.1 90/01/15 "
#ident "@(#)dda.h	1.2 89/09/29"
#ident "@(#) dda.h 1.3 89/07/27 "
/* 
 *      Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *      This Module contains Proprietary Information of the Santa
 *      Cruz Operation, and should be treated as confidential. 
 */

/*
 *	 Definitions for VP/ix DDA driver
 */

#define DDA_NINTR	16     		/* sixteen interrupt lines	   */
#define DDA_MAX_IOLEN 	50     		/* maximum consecutive registers   */


/*
 *	This list element is used to keep track of the areas of memory and
 *	i/o that are mapped by a process.
 */

struct dda_elem {
	struct	dda_elem	*next_elem;	/* link pointer */
		long		base;		/* base of area */
		int		length;		/* length of area  */
};


/*
 *	This structure contains all the information that is gathered at open
 *	time from the opening process.
 */

struct dda_device {
	char		dda_open;	/* TRUE/FALSE indicates status */
	struct proc	*procptr;	/* proc table entry for this process */
	v86_t		*v86_proc;	/* v86 process ptr for this process */
	short		pid;		/* process id for this process */
	struct dda_elem	*mem_chain;	/* chain of mapped memory elements */
	struct dda_elem	*io_chain;	/* chain of mapped i/o elements */
};


/*
 *	This structure contains all the information that is necessary to
 *	process interrupts to be notified to VP/ix processes.
 */

struct dda_int {
	int		open_dev;	/* dda open table entry */
	int		pseudomask;	/* pseudo interrupt type */
	unsigned short	flag;		/* edge/level triggering flag */
};


/*
 *	This structure defines the interface between the user process and
 *	the direct device access driver ioctl function calls. The user process
 *	can request chunks of io or memory with successive ioctl calls.
 */

struct vdev {
	ushort	dda_iobase;	/* base io address */
	int	dda_iolen;	/* length of io area */
	long	dda_pmembase;	/* base physical memory address */
	long	dda_vmembase;	/* base virtual memory address */
	int	dda_memlen;	/* length of memory required */
	int	dda_intnum;	/* interrupt vector required */
	int	dda_pseudomask;	/* pseudorupt to send */
	int	dda_dma_chan;	/* DMA channel requested */
	ushort	dda_flag;	/* indicates edge or level triggered device */
};


/*
 *	IOCTLs supported by the direct device access driver.
 */

#define DDAIOC		('v'<<8)
#define DDA_SET		(DDAIOC|1)	/* setup device parameters */
#define DDA_UNSET	(DDAIOC|2)	/* undo device parameters */
#define	DDA_EXCL	(DDAIOC|3)	/* disable/enable exclusive access */

#endif	/* _SYS_DDA_H */
