/*
 *	Driver Interface for Communication with the Kernel
 *
 *	Copyright (c) 1991 Altos Computer Systems
 *	All Rights Reserved.
 *
 *	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ALTOS
 *	The copyright notice above does not evidence any
 *	actual or intended publication of such source code.
 *
 *	@(#)dick.h	1.4 91/07/03
 */

/*
 *
 *	A000 - Thu May 23 15:04:40 PDT 1991	altos!steve
 *	- Created.
 *
 */

struct io_info {
	u_char	io_type;	/* type of device */
	u_char	io_sgsz;	/* max # of entries in a scatter-gather list */
	u_long	io_sgesz;	/* max bytes in a single scatter-gather entry */
	u_long	io_sgtsz;	/* max # of bytes in a scatter-gather request */
	u_long	io_tsz;		/* max bytes transferable in one request */
	u_long	io_winsz;	/* memory window size of this device */
	paddr_t	io_maxadr;	/* highest address device can access */
	void   *io_ext;		/* pointer to device-specific info struct */
};

/* defines for the io_type field */
#define	IO_STORE	0	/* mass-storage device */
#define IO_STREAM	1	/* streams device */


/* block and character io_info hashing retrieval function arrays */
extern struct io_info *((*bio_hash[])());
extern struct io_info *((*cio_hash[])());


/*
 *	get_io_info()
 *
 *	This macro calls the proper io_info hashing algorithm given device
 *	"dev". "Block" should be true if "dev" is a block device.
 */

#define get_io_info(dev, bdev) ((bdev) ? \
	(bio_hash[major(dev)] == NULL ? NULL : (*bio_hash[major(dev)])(dev)) : \
	(cio_hash[major(dev)] == NULL ? NULL : (*cio_hash[major(dev)])(dev)))
