#ident	"@(#)disk.h	1.2	90/08/08"
#ifndef _SYS_DISK_H
#define _SYS_DISK_H
#ident "@(#) disk.h 22.2 90/01/17 "
#ident "@(#)disk.h	1.2 89/09/29"
#ident "@(#) disk.h 1.8 89/08/25 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986, 1987, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 *
 */

/*
 * Common include file for disk driver front and back ends.
 * The 'front end' provides a common scheme for disk partitioning
 * and bad track aliasing.
 * The front end assumes an ibm style partition table on sector 0
 * of each disk.  If this is not true certain routines in the front
 * end would have to be rewritten.
 */

/* 
 * Drive parameter structures.
 */

struct dkparms {
	unsigned short	prcmp;			/* Write precomp	*/
	unsigned short	lzone;			/* Landing zone		*/
	unsigned short	wrt_reduce;		/* Write reduce cylinder*/
	unsigned char	ecc;			/* Ecc level		*/
	unsigned char	ctrl;			/* Control		*/
};

#if defined(STANDALONE) || defined(M_I386) || defined(i386)
typedef	struct	badtrks		*btrkp_t;
#else
typedef	struct	badtrks	far 	*btrkp_t;
#endif


/*
 * The sprawling diskinfo structure.
 */

struct diskinfo {

/*
 * This field for disk.c internal use only;
 * drivers should not test or set.
 */
int 	dkflags;
#define DK_USED		0x01		/* this structure in use	*/
#define DK_INIT		0x02		/* this structure initialized	*/
#define DK_PART		0x04		/* partition table read		*/
#define DK_VALID	0x08		/* we like it			*/
#define DK_PRINT	0x10		/* params printed		*/
#define DK_NOROOT	0x20		/* don't read from 0th disk	*/

/*
 * Fields drivers need to set or examine.
 */
int	(*dkstrat)();			/* driver strategy routine	*/
struct	dparam	dkparam;		/* drive params			*/
struct	dkparms	dkparms;		/* more drive params		*/
int	spcyl;				/* sectors per cylinder		*/
int	dkcinit;			/* controller must be init'd	*/

/*
 * Drivers should not set or examine
 * anything in this structure past this point.
 */

/*
 * Virtual drive structures and constants.  See partition.h and dio.h
 * A virtual drive is our concept of an fdisk partition.  The fdisk
 * partition structure is not terribly useful so we have to convert.
 * Virtual drive 0 is the whole physical disk - it is initialized to
 * the size of the default disk.
 */

#define NLVS		8		/* 2^3 - max "logical" virtuals */
#define NVDS		4		/* actual number of virtual drives */

struct dkvdtab {
	unsigned short v_magic;
	unsigned short v_nvds;			/* number vds allowed */
	struct   vdisk v_vdisk[NVDS+1];
} dkvdt;

/*
 * -1 indicates virtual drive does not exist, else entry points to itself 
 */
int	dkvds[NLVS];

int	dkvdflags[NVDS+1];		/* flags virtual drive open	*/
#define DK_VDVALID	1		/* good virtual drive		*/
#define DK_VDPART	2		/* partition table read		*/
#define DK_VDBAD	4		/* bad track table read		*/

/*
 * We now need another array similar to dkvds.  this one is needed
 * to map fdisk partitions (0-4) into XENIX partitions.  This is cause
 * only XENIX partitions have divvy and badtrk data structures set up
 * for them according to the limit NXPD.  You can have MORE than NXPD
 * XENIX partitions, but they cannot all be OPEN at the same time. 
 * actually, once you open NXPD of them, you will not be able to open
 * another w/o rebooting the machine.  nxd is the counter of the
 * number of opened XENIX partitions.
 */

int	nxd;
int	dkxds[NVDS+1];		/* Also need to map the ACTIVE XENIX */

/************************************************************************
 * Partition structures and constants.  See dio.h
 * A XENIX virtual drive can be partitioned into up to DKNPARTS partitions.
 * We only allow NXPD XENIX virtual drives per drive in order to not waste
 * kernel data.  npartabs counts the number of struct dkpartabs allocated.
 * dkpp[v] contains a virtual drive's pointer to its struct dkpartab.
 *
 * Each virtual drive has reserved space for alias tracks and system
 * tables which are not available for the user.
 *
 * Each XENIX virtual drive requires a struct dkpartab and a struct dkbadtab.
 */

#define DKNPARTS	8		/* max number of partitions of a vd */
#define NXPD		3		/* number xenix partitions per drive */
#define WHOLE_VIRT	7		/* partition which is whole virtual */

#if defined(M_I386) || defined(i386)
#pragma pack(2)
#endif

struct dkpartab  {
	unsigned short	p_magic;
	struct	 parts	p[DKNPARTS];
}dkpartab[NXPD];

#if defined(M_I386) || defined(i386)
#pragma pack()
#endif

struct dkpartab	*dkpp[NVDS+1];

int	npartabs;

/*************************************************************************
 * Bad track structures and constants.  See dio.h
 * Each virtual drive gets up to MAXBTRKS bad tracks.  Each virtual drive
 * gets a struct dkbadtab in core and a struct badtab on disk.  
 *
 * dkbtp[v] is a virtual drive's pointer to its struct dkbadtab.
 *
 * Each virtual drive opened gets as many badtracks as the user desires, up
 * to MAXBTRKS or the size of the virtual drive (in trks), whichever is less.
 *
 * DIOWBTRK takes effect immediately.  The table copied in is checked for bad
 * tracks whick are as yet unaliased - the kernel assigns the alias track.
 * Bad tracks and alias track in the tables are physical - this allows 
 * access to them through the physical device.
 *
 * with new kernel badtrack structures, pre 2.2 disk layouts have the
 * potential to have more badtracks by just tar'ing off the new kernel.  
 * Old layouts will generally get more badtracks if the size of the virtual
 * drive is greater than 20 Mb, assuming 17 sectors/track.
 * Previously, max badtracks was min(~2% of size of the virtual drive,DKMAXBAD).
 * Now it will be ~2% of the size of the virtual drive(for OLD layouts).  
 *
 * Of course, new (2.2) installations will get however much they want.
 */

#define MAXBTRKS	1023
#define BTRKSPERBLK	(BSIZE/(2*sizeof(unsigned short)) )
#define STATSIZ		15	/* Fast access badtrk tbl size */

/* Next macro jumps us to next badblk if at end of this one */
#define	BLKBNDY(nbad)	( (nbad)>0 && (nbad)%(BTRKSPERBLK)==0 ) 
#define DKBNDY(nbad)	( (nbad)==STATSIZ || BLKBNDY((nbad)-STATSIZ) )

struct badtrks	dkbadtrks[NXPD][STATSIZ];	/* Static badtrk tables     */

struct dkbadtab  {
	unsigned short b_magic;
	unsigned b_maxbad;			/* tell user how max allowed */
	unsigned b_nbad;			/* count of bad tracks       */
	unsigned b_falias;			/* first alias trackno       */
	unsigned b_nalias;			/* number of alias tracks    */
	struct badtrks *b_btrkp;		/* ptr into static vd struct */
}dkbadtab[NXPD];

struct dkbadtab *dkbtp[NVDS+1];

/*
 * The merged product defines b_blkno in 512 byte units, hence the #defines
 * below are different, although the actual disk location is the same.
 */
#ifdef i386

#define TWO13PARLOC	(2 * 2L)	/* Disk location of partition tbl */
#define TWO2PARLOC	(2 * 21L)

#define TWO13BADLOC	(2 * 1L)	/* Disk location of bad blk tbl	*/
#define TWO2BADLOC	(2 * 22L)

#else

#define TWO13PARLOC	2L		/* Disk location of partition tbl */
#define TWO2PARLOC	21L

#define TWO13BADLOC	1L		/* Disk location of bad blk tbl	*/
#define TWO2BADLOC	22L

#endif

#define	TWO13BADBLKS	1		/* Bad blocks used in 2.1.3	*/
#define	TWO2BADBLKS	4		/* Bad blocks used in 2.2	*/

#define TWO13GDTRKS	4		/* Required # good trks in 2.1.3 */

unsigned short dklastbtrk[NXPD];	/* Last bad trk in each vd */

struct dkbuf {
	struct buf 	*buffer;	/* Max # outboard buffers    */
	btrkp_t 	bufptr;		/* Pointers into 'em	     */
	int		bad;		/* How many bad in this blk? */
	char		inuse;		/* In use?		     */
} dkbuf [NVDS][TWO2BADBLKS];

/* Initialized in dktype() depending on which disk layout is found */

struct	dklayout {
	long	parblkno;		/* Blk # of divvy table 	*/
	long	badblkno;		/* Blk # of badtrk tbl start 	*/
	int	badblks;		/* # of blks of badtrk tbl	*/
	int	nsystrks;		/* Tracks reserved for driver	*/
	int	aliastrks;		/* trks space reserved for	*/
	int	newdisk;		/* True if 2.2			*/
} dklayout[NVDS];

};

typedef struct diskinfo *dip_t;

#ifndef STANDALONE
extern struct diskinfo diskinfo[];
extern dip_t dkalloc();
#endif


/*
 * Macros to extract appropriate bits from the minor device.
 * These macros depend on a bit ordering of high 2 bits for
 * physical drive, next 3 bits for virtual drive, and low 3
 * bits for partition of a virtual drive.  More general macros 
 * can be found in ../h/dio.h.
 */
#define DPHYS(d)	((d >> 6) & 0x3)	/* 2 highest bits */
#define DVIR(d)		((d >> 3) & 0x7)	/* 3 middle bits */
#define DPART(d)	(d & 0x7)
#define DMKDEV(p,v,pa)	((p << 6) | (v << 3) | pa)

#define WHOLE_DISK	0		/* virtual number of whole drive */

/*
 * dksec{start,size}() return the starting sector number and size
 * in sectors of a minor device.   They assume disks with sector 
 * size of 512 bytes and XENIX block size of 1024 bytes.  They,
 * along with the macros to convert sectors to blocks and back,
 * would need to be rewritten for a driver for which
 * those assumptions were untrue.
 */
long dksecstart(), dksecsize();
#define BTOS(b)		(b << 1)	/* BSIZE blocks to sectors */
#define STOB(s)		(s >> 1)

/*
 * Misc
 */
#define DK_ERROR	-1
#define DK_OK		0

#define DK_EXIST	1		/* exists */
#define DK_READY	2		/* needs init */
#define DK_PARAM	4		/* disk parameters read */

#define	DKSECTOR	512
#define DKSSHIFT	9
#define DKSMASK		0x01FF
#define MAXRETRY        4

#ifdef STANDALONE
int	dkctlr;				/* Identifies controller being used */
#endif

struct dkcntlrtab {			/* Information passed to dksetup */
	unsigned short	base;		/* I/O port base address */
	unsigned short	offset;		/* Offset of I/O port highest address*/
	short		vec;		/* Interrupt vector */
	short		dma;		/* DMA channel */
	char *		type;		/* Controller type, e.g. "W" */
};

#endif	/* _SYS_DISK_H */
