#ident	"@(#)eisa.h	1.7	91/05/15"
#ident "@(#)eisa.h	1.12 90/06/26"
#ident "@(#)eisa.h	1.12 90/06/26"
/*
/*
 * Copyright(C) 1989 by Altos Computer Systems
 * All Rights Reserved.
 */

#pragma pack(1)

struct slotinfo {
	unsigned char flags;
	unsigned char flags2;
	char major_rev_lev;
	char minor_rev_lev;
	unsigned short checksum;
	char nfuncs;
	char infobyte;
	char compressedID[4];
};
#define EISA_SLOTOK	0
#define EISA_BADSLOT	0x80
#define EISA_BADMEM	0x82
#define EISA_EMPTY	0x83

/*
 * The bit fields here describe the eisa structure only
 * for compilers in which the first bit fields start
 * in the least significant part of the word.
 */

struct memcfg {
	unsigned char isram:1;
	unsigned char cacheable:1;
	unsigned char reservedB:1;		/* Reserved(0) */
	unsigned char mem_type:2;		/* Memory Type */
	unsigned char shared:1;		/* Shared Memory */
	unsigned char reserved:1;		/* Reserved(0) */
	unsigned char notlast:1;		/* Do more entries follow */

	unsigned char datasize:2;		/* Memory Data Size */
	unsigned char reservedC:6;		/* Reserved */

	/* Memory Start Address (bytes divided by 0x100) */
	unsigned char low_start;	/* Least Significant Byte */
	unsigned char med_start;	/* Middle Byte */
	unsigned char high_start;	/* Most Significant Byte */

	/* Memory size (bytes divided by 0x400) */
	unsigned char low_size;		/* Least Significant Byte */
	unsigned char high_size;	/* Most Significant Byte */
};

struct intcfg {
	unsigned char intr:4;
	unsigned char reserved:1;	/* Must be 0 */
	unsigned char level_triggered:1;/* Level Triggered or Edge Triggered */
	unsigned char sharable:1;	
	unsigned char notlast:1;	/* More entries follow */
	char reservedB;			/* Reserved(0) */
};

struct dmacfg {
	unsigned char channel:3;	/* DMA Channel */
	unsigned char reserved:3;
	unsigned char sharable:1;
	unsigned char notlast:1;	/* More entries follow */

	unsigned char reservedC:1;
	unsigned char transfersize:2;
	unsigned char timing:3;		/* DMA Timing */
	unsigned char reservedB:2;
};

struct portcfg {
	unsigned char numports:5;	/* Number Ports (minus 1) */
	unsigned char reserved:1;
	unsigned char shareable:1;
	unsigned char notlast:1;	/* More entries follow */
	unsigned short portnum;		/* I/O Port Address */
};

struct initcfg {
	unsigned char addrtype:2;	/* 0=byte,1=word,2=dword,3=reserved*/
	unsigned char port:1;
	unsigned char reserved:4;
	unsigned char notlast:1;	/* More entries follow */
	unsigned short portnum;		/* I/O Port Address */
};

/*
 * This is the 320-byte structure returned by the BIOS int 0x15.
 * This is described in section 4.8.1.3 in the EISA spec Rev 3.10.
 */
struct funcinfo {
	/* Four-Byte Compressed ID */
	char compressedID[4];

	/* ID and Slot Information */
	unsigned char cfgname:4;
	unsigned char slot_type:2;
	unsigned char unreadable:1;
	unsigned char duplicate:1;

	unsigned char enable:1;
	unsigned char iochkerr:1;
	unsigned char reserved:5;
	unsigned char cfg_complete:1;

	/* Vendor Specific Code Revision Level */
	char minor_rev_lev;
	char major_rev_lev;

	/* Selections */
	char selections[26];

	/* Function Information */
	unsigned char type_entry:1;	/* Type/subtype ASCII string entrys */
	unsigned char mem_entry:1;	/* Memory entry(s) follows */
	unsigned char irq_entry:1;	/* Interrupt (IRQ) entry(s) follows */
	unsigned char dma_entry:1;	/* DMA entry(s) follows */
	unsigned char port_range:1;	/* Port range entry(s) follows */
	unsigned char port_entry:1;	/* Port Entry(s) follows */
	unsigned char reservedB:1;	/* Reserved */
	unsigned char disabled:1;	/* Function is disabled */

	char type[80];			/* TYPE and SUBTYPE ASCII String */
	struct memcfg memcfg[9];	/* Memory Configuration */
	struct intcfg intcfg[7];	/* Interrupt Configuration Bytes */
	struct dmacfg dmacfg[4];	/* DMA Channel Description */
	struct portcfg portcfg[20];	/* Port I/O Information */
	struct initcfg initcfg[20];	/* Initialization Data */
};

#pragma pack()

struct fail_info {
	char *eisa_id;
	int (*func)();
};

/*
 * Board Identification Strings
 * Format is:
 *	3 bytes: Manufacturer ID
 *	2 bytes: Board ID byte in hex
 *	2 bytes: Revision byte of board in hex
 *
 * The rev byte for the Motherboard:
 *	5 bits: board revision
 *	3 bits: eisa bus revision
 */

/*
 * Board-ID Strings for Altos Boards
 */
#define ID_5000_MB	"ACS0109"
#define ID_5300_MB	"ACS0B09"
#define ID_4000_MB	"ACS0709"
#define ID_BIO		"ACS0201"
#define ID_BIO2		"ACS0A01"
#define ID_BIO2_SCSI	"ACS0C01"
#define ID_BIO2_ENET	"ACS0D01"
#define ID_MDC		"ACS0301"
#define ID_SIO		"ACS0401"
#define ID_HPFP		"ACS0501"

#define MAX_EISA_SLOTS 16

extern struct fail_info fail_info[];

char *eisa_compress();
char *eisa_uncompress();

/*
 * Most common reserved EISA ports
 * z is the slot number
 */
#define EISA_ID0(z)	(z * 0x1000 + 0xc80)
#define EISA_ID1(z)	(z * 0x1000 + 0xc81)
#define EISA_ID2(z)	(z * 0x1000 + 0xc82)
#define EISA_ID3(z)	(z * 0x1000 + 0xc83)

#define EISA_CTRL(z)	(z * 0x1000 + 0xc84)

#define ENABLE		0x1
#define IOCHKERR	0x2
#define IOCHKRST	0x4

/*
 * EISA system call sub-functions
 */
#define EISA_SLOT 0
#define EISA_FUNC 1
#define EISA_SEARCH 2
#define EISA_COMPRESS 4
#define EISA_SCSIDSK 5
#define EISA_SCSIMAJOR 6

struct eisa_info {
	struct {
		short first_func;
		struct slotinfo slotinfo;
	} slots[MAX_EISA_SLOTS];
};

#define SYSAT		0
#define SYSOTHER	1
#define SYS5000		2
#define SYS5300		3
#define	SYS4000		4

extern int eisa;

struct eisa_ids {
	char eisa_id[81];
	char func_id[81];
};
