#ident	"@(#)errno.h	1.3	90/08/08"
#ifndef _SYS_ERRNO_H
#define _SYS_ERRNO_H
#ident "@(#) errno.h 22.1 90/01/15 "
#ident "@(#)errno.h	1.2 89/09/29"
#ident "@(#) errno.h 1.9 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head.sys:errno.h	1.3.1.1" */

/*
 * Error codes
 */

#define	EPERM	1	/* Not super-user			*/
#define	ENOENT	2	/* No such file or directory		*/
#define	ESRCH	3	/* No such process			*/
#define	EINTR	4	/* interrupted system call		*/
#define	EIO	5	/* I/O error				*/
#define	ENXIO	6	/* No such device or address		*/
#define	E2BIG	7	/* Arg list too long			*/
#define	ENOEXEC	8	/* Exec format error			*/
#define	EBADF	9	/* Bad file number			*/
#define	ECHILD	10	/* No children				*/
#define	EAGAIN	11	/* No more processes			*/
#define	ENOMEM	12	/* Not enough core			*/
#define	EACCES	13	/* Permission denied			*/
#define	EFAULT	14	/* Bad address				*/
#define	ENOTBLK	15	/* Block device required		*/
#define	EBUSY	16	/* Mount device busy			*/
#define	EEXIST	17	/* File exists				*/
#define	EXDEV	18	/* Cross-device link			*/
#define	ENODEV	19	/* No such device			*/
#define	ENOTDIR	20	/* Not a directory			*/
#define	EISDIR	21	/* Is a directory			*/
#define	EINVAL	22	/* Invalid argument			*/
#define	ENFILE	23	/* File table overflow			*/
#define	EMFILE	24	/* Too many open files			*/
#define	ENOTTY	25	/* Not a typewriter			*/
#define	ETXTBSY	26	/* Text file busy			*/
#define	EFBIG	27	/* File too large			*/
#define	ENOSPC	28	/* No space left on device		*/
#define	ESPIPE	29	/* Illegal seek				*/
#define	EROFS	30	/* Read only file system		*/
#define	EMLINK	31	/* Too many links			*/
#define	EPIPE	32	/* Broken pipe				*/
#define	EDOM	33	/* Math arg out of domain of func	*/
#define	ERANGE	34	/* Math result not representable	*/
#define	ENOMSG	35	/* No message of desired type		*/
#define	EIDRM	36	/* Identifier removed			*/
#define	ECHRNG	37	/* Channel number out of range		*/
#define	EL2NSYNC 38	/* Level 2 not synchronized		*/
#define	EL3HLT	39	/* Level 3 halted			*/
#define	EL3RST	40	/* Level 3 reset			*/
#define	ELNRNG	41	/* Link number out of range		*/
#define	EUNATCH 42	/* Protocol driver not attached		*/
#define	ENOCSI	43	/* No CSI structure available		*/
#define	EL2HLT	44	/* Level 2 halted			*/
#define	EDEADLK	45	/* Deadlock condition.			*/
#define	ENOLCK	46	/* No record locks available.		*/

/* Convergent Error Returns */
#define EBADE	50	/* invalid exchange			*/
#define EBADR	51	/* invalid request descriptor		*/
#define EXFULL	52	/* exchange full			*/
#define ENOANO	53	/* no anode				*/
#define EBADRQC	54	/* invalid request code			*/
#define EBADSLT	55	/* invalid slot				*/
#define EDEADLOCK 56	/* file locking deadlock error		*/

#define EBFONT	57	/* bad font file fmt			*/

/* stream problems */
#define ENOSTR	60	/* Device not a stream			*/
#define ENODATA	61	/* no data (for no delay io)		*/
#define ETIME	62	/* timer expired			*/
#define ENOSR	63	/* out of streams resources		*/

#define ENONET	64	/* Machine is not on the network	*/
#define ENOPKG	65	/* Package not installed                */
#define EREMOTE	66	/* The object is remote			*/
#define ENOLINK	67	/* the link has been severed */
#define EADV	68	/* advertise error */
#define ESRMNT	69	/* srmount error */

#define	ECOMM	70	/* Communication error on send		*/
#define EPROTO	71	/* Protocol error			*/
#define	EMULTIHOP 74	/* multihop attempted */
#define ELBIN	75	/* Inode is remote (not really error */
#define	EDOTDOT 76	/* Cross mount point (not really error)*/
#define EBADMSG 77	/* trying to read unreadable message	*/
#define ENAMETOOLONG	78

#define ENOTUNIQ 80	/* given log. name not unique */
#define EBADFD	 81	/* f.d. invalid for this operation */
#define EREMCHG	 82	/* Remote address changed */

/* shared library problems */
#define ELIBACC	83	/* Can't access a needed shared lib.	*/
#define ELIBBAD	84	/* Accessing a corrupted shared lib.	*/
#define ELIBSCN	85	/* .lib section in a.out corrupted.	*/
#define ELIBMAX	86	/* Attempting to link in too many libs.	*/
#define ELIBEXEC	87	/* Attempting to exec a shared library.	*/
#define ENOSYS		89

/*
 *	System V STREAMS TCP
 */
/* Errors from 4.2 BSD picked up to support sockets */
/* Note that the numbers are different from 4.2 numbering */

#define TCPERR		90
/* non-blocking and interrupt i/o */
#define EWOULDBLOCK     (TCPERR+0)       /* Operation would block */
#define EINPROGRESS     (TCPERR+1)       /* Operation now in progress */
#define EALREADY        (TCPERR+2)       /* Operation already in progress */
/* ipc/network software */

/* argument errors */
#define ENOTSOCK        (TCPERR+3)       /* Socket operation on non-socket */
#define EDESTADDRREQ    (TCPERR+4)       /* Destination address required */
#define EMSGSIZE        (TCPERR+5)       /* Message too long */
#define EPROTOTYPE      (TCPERR+6)       /* Protocol wrong type for socket */
#define EPROTONOSUPPORT (TCPERR+7)       /* Protocol not supported */
#define ESOCKTNOSUPPORT (TCPERR+8)       /* Socket type not supported */
#define EOPNOTSUPP      (TCPERR+9)       /* Operation not supported on socket */
#define EPFNOSUPPORT    (TCPERR+10)      /* Protocol family not supported */
#define EAFNOSUPPORT    (TCPERR+11)      /* Address family not supported by protocol family */
#define EADDRINUSE      (TCPERR+12)      /* Address already in use */
#define EADDRNOTAVAIL   (TCPERR+13)      /* Can't assign requested address */

/* operational errors */
#define ENETDOWN        (TCPERR+14)      /* Network is down */
#define ENETUNREACH     (TCPERR+15)      /* Network is unreachable */
#define ENETRESET       (TCPERR+16)      /* Network dropped connection on reset */
#define ECONNABORTED    (TCPERR+17)      /* Software caused connection abort */
#define ECONNRESET      (TCPERR+18)      /* Connection reset by peer */
#define ENOBUFS         ENOSR            /* No buffer space available */
#define EISCONN         (TCPERR+20)      /* Socket is already connected */
#define ENOTCONN        (TCPERR+21)      /* Socket is not connected */
#define ESHUTDOWN       (TCPERR+22)      /* Can't send after socket shutdown */
#define ETOOMANYREFS    (TCPERR+23)      /* Too many references: can't splice */
#define ETIMEDOUT       (TCPERR+24)      /* Connection timed out */
#define ECONNREFUSED    (TCPERR+25)      /* Connection refused */


/* should be rearranged */
#define EHOSTDOWN       (TCPERR+26)      /* Host is down */
#define EHOSTUNREACH    (TCPERR+27)      /* No route to host */
#define ENOPROTOOPT     (TCPERR+28)      /* Protocol not available */

/* XENIX error numbers */
#define EUCLEAN	135	/* Structure needs cleaning */
#define ENOTNAM	137	/* Not a name file */
#define ENAVAIL	138	/* Not available */
#define EISNAM	139	/* Is a name file */
#define EREMOTEIO	140	/* Remote I/O error */
#define EINIT	141	/* Reserved for future */
#define EREMDEV	142	/* Error 142 */
#define ENOTEMPTY	145

#if defined(M_I286) && defined(M_XOUT)
#	undef	EUCLEAN
#	define	EUCLEAN	35
#	undef	EDEADLOCK
#	define	EDEADLOCK	36
#	undef	EDEADLK
#	define	EDEADLK	EDEADLOCK
#	undef	ENOTNAM
#	define	ENOTNAM	37
#	undef	ENAVAIL
#	define	ENAVAIL	38
#	undef	EISNAM
#	define	EISNAM	39
#	undef	EREMOTEIO
#	define	EREMOTEIO	40
#	undef	EINIT
#	define	EINIT	41
#	undef	EREMDEV
#	define	EREMDEV	42
#	undef	ENOMSG
#	define	ENOMSG	43
#	undef	EIDRM
#	define	EIDRM	44
#	undef	ENOLCK
#	define	ENOLCK	45
#endif	/* 286 x.out */

#endif	/* _SYS_ERRNO_H */

