#ident	"@(#)s5inode.h	1.2	90/08/08"
#ifndef _SYS_FS_S5INODE_H
#define _SYS_FS_S5INODE_H
#ident "@(#) s5inode.h 22.6 90/03/19 "
#ident "@(#)s5inode.h	1.6 90/06/05"
#ident "@(#) s5inode.h 1.8 89/07/27 "
/*
 *	UNIX is a registered trademark of AT&T
 *	Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *	Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 *
 *      Portions Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head.sys:fs/s5inode.h	1.4" */

#include <sys/ci/cilock.h>

#ifndef DIRSIZ
#define DIRSIZ 14
#endif

#define	NADDR	13
#define	NSADDR	(NADDR*sizeof(daddr_t)/sizeof(short))

#ifndef FFS
#define FFS
#endif

struct s5inode {
	ushort	s5i_flags;	/* see below */	
	ushort	s5i_mode;	/* file mode and type */
	union s5i_u1 {
		struct	s5inode	*s5i_nxt; /* free list pntr */
		daddr_t s5i_a[NADDR];	/* if normal file/directory */
		short	s5i_f[NSADDR];	/* counts for fifo's */
	} s5i_u1;
	union s5i_u2 {
		int	*s5i_mp;	/* pointer to blk # map for paging */
		off_t	s5i_doff;	/* directory offset - */
					/* for directory caching */
	} s5i_u2;
	daddr_t	s5i_l;		/* last logical block read (for read-ahead) */
#ifdef FFS
	daddr_t	s5i_behind;	/* u.u_behind from last bmap */
	daddr_t s5i_ahead;	/* u.u_ahead from last bmap */
	daddr_t s5i_behindoff;	/* offset to translate logical to physical */
	daddr_t s5i_nxtstrt;	/* saved nxtstart value from bmap */
	daddr_t s5i_nxtend;	/* saved nxtend value from bmap */
	daddr_t	s5i_freebase;	/* Base of cached bitmap in freemap */
	long	s5i_freemap;	/* Bitmap of cached free blocks */
#endif
	char	s5i_gen;	/* generation number */
	struct lockb s5i_cilock;  /* MPX s5inode struct synchronization */
};

/* Flags */
#define	S5IFREE		0x0	/* Free cell */

#define	s5i_next	s5i_u1.s5i_nxt
#define	s5i_addr	s5i_u1.s5i_a
#define	s5i_lastr	s5i_l
#define	s5i_rdev	s5i_u1.s5i_a[0]

#define	s5i_map		s5i_u2.s5i_mp
#define	s5i_diroff	s5i_u2.s5i_doff

#define	s5i_faddr	s5i_u1.s5i_a
#define	NFADDR	8
#define	PIPSIZ	NFADDR*BSIZE
#define	s5i_frptr	s5i_u1.s5i_f[NSADDR-5]
#define	s5i_fwptr	s5i_u1.s5i_f[NSADDR-4]
#define	s5i_frcnt	s5i_u1.s5i_f[NSADDR-3]
#define	s5i_fwcnt	s5i_u1.s5i_f[NSADDR-2]
#define	s5i_waite	s5i_u1.s5i_f[NSADDR-3]
#define	s5i_waitf	s5i_u1.s5i_f[NSADDR-2]
#define	s5i_fflag	s5i_u1.s5i_f[NSADDR-1]
#define	s5i_selrd	s5i_u1.s5i_a[NFADDR]
#define	s5i_selwr	s5i_u1.s5i_a[NFADDR+1]
#define	IFIR	01
#define	IFIW	02
#define	IRCOLL	04
#define	IWCOLL	010

#ifdef DYNAMIC
extern struct s5inode *s5inode;
#else
extern struct s5inode s5inode[];
#endif
/* 
 * Definitions for the s5 name cache 
 */
struct s5cachent {
	struct s5cachent *forw;
	struct s5cachent *back;
	struct s5cachent *av_forw;
	struct s5cachent *av_back;
	unsigned short	dev; /* really dev_t, but types may not be inc'ed yet */
	unsigned short	inum;	
	unsigned short	hits;
	unsigned short 	newinum;
	char 	name[DIRSIZ];
};

struct s5hashq {
	struct s5cachent *forw;
	struct s5cachent *back;
};


#endif /* _SYS_FS_S5INODE_H */
