#ident	"@(#)ft.h	1.2	90/08/08"
#ifndef _SYS_FT_H
#define _SYS_FT_H
#ident "@(#) ft.h 22.1 90/01/15 "
#ident "@(#)ft.h	1.2 89/09/29"
#ident "@(#) ft.h 1.3 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	Copyright (C) Archive Corporation, 1988.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and Archive Corporation,
 *	and should be treated as Confidential.
 */
/*
 *	XENIX QIC-40 tape driver include file.
 */

/* Minor device bit definitions */

#define FT_OVERRIDE 0x80	/* control device */
#define FT_APPEND   0x08	/* norewind device */
#define FT_QIC117   0x04	/* 1 = New style drive */


union ft_status {
	struct {
		unsigned short ready   : 1;	/* drive ready */
		unsigned short error   : 1;	/* error detected */
		unsigned short cpres   : 1;	/* cart. present */
		unsigned short wprot   : 1;	/* write protected */
		unsigned short newcart : 1;	/* new cart. inserted */
		unsigned short cref    : 1;	/* cart. referenced */
		unsigned short bot     : 1;	/* phys beg. of tape */
		unsigned short eot     : 1;	/* phys end of tape */

		unsigned short errnum : 8;	/* error number */
		unsigned short errcmd : 8;	/* error assoc. with cmd */

		unsigned short sfterr;		/* soft errors */
		unsigned short hrderr;		/* hard errors */
		unsigned short undrun;		/* underruns */
	} status;
	unsigned char stat[9];
};

/* number of entries in the new bad segment table */
#define FT_NBB	64

struct ft_nbbent {			/* new bad block entry */
	unsigned short seg;		/* segment number */
	unsigned long map;		/* segment map */
};

struct ft_newbbt {			/* new bad segment table */
	int	cnt;		/* # entries */
	struct ft_nbbent bbt[FT_NBB];	/* array of entries */
};

#define FT_SCTRSIZ 1024

struct ft_header_fmt_record {
	unsigned char signature[4]; 	/* always 55 AA 55 AA */
	unsigned char fmt_code; 	/* always 02 */
	unsigned char unused;
	unsigned short segment; 		/* segment number of header segment */
	unsigned short dupsegment; 	/* seg num of duplicate header */
	unsigned short first;		/* first data segment number */
	unsigned short last;		/* last data segment number */
	unsigned char last_fmt_date[4];	/* date of last format */
	unsigned char last_write_date[4];	/* date of last write or format */
	unsigned char unused2[106];
	unsigned char fmt_error;	/* FF if remaining fields lost */
	unsigned char unused3;
	unsigned char lifetime[4];	/* +1 for every read,write,format */
	unsigned char unused4[4];
	unsigned char first_fmt_date[4];/* date of first format */
	unsigned short fmt_count;	/* times tape has been formatted */
	unsigned short failed_count;	/* number of entries in failed log */
	unsigned char mfr_code[44];	/* zero for non-pre-formatted */
	unsigned char mfr_lot[44];	/* zero for non-pre-formatted */
	unsigned char unused5[22];
	unsigned short fail_log[384];	/* log of sectors failed to verify */
};

union ft_header_segment {
	struct {
		struct ft_header_fmt_record format;
		unsigned char fail_log2[FT_SCTRSIZ];	/* cont. failed sector log */
		unsigned long bad_map[FT_SCTRSIZ * 14 / 4]; /* each long is a seg. */
		/* entire map not used; only up to 16K */
	} s;
	unsigned char raw[FT_SCTRSIZ * 16];
};

typedef union ft_header_segment ft_header;
#ifdef M_I286
typedef ft_header far *Pft_header;
#else
typedef ft_header *Pft_header;
#endif

struct ft_volume_table {
	unsigned char signature[4];
	unsigned short start;
	unsigned short end;
	unsigned char descr[44];
	unsigned long date;
	unsigned char flags;
	unsigned char sequence;
	unsigned char vendor[26];
	unsigned char passwd[8];
	unsigned long dirsize;
	unsigned long datasize;
	unsigned char OSvers[2];
	unsigned char label[16];
	unsigned char logdrv;
	unsigned char physdrv;
	unsigned char reserved[6];
	unsigned short bytes_in_last_segment;
};
typedef struct ft_volume_table ft_volume;
#ifdef M_I286
typedef ft_volume far *Pft_volume;
#else
typedef ft_volume *Pft_volume;
#endif

#endif	/* _SYS_FT_H */
