#ident	"@(#)getpages.h	1.2	90/08/08"
#ifndef _SYS_GETPAGES_H
#define _SYS_GETPAGES_H
#ident "@(#) getpages.h 22.1 90/01/15 "
#ident "@(#)getpages.h	1.2 89/09/29"
#ident "@(#) getpages.h 1.6 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head.sys:getpages.h	1.3" */

/*	The following list is used to keep track of regions locked
**	by getpages.
*/

typedef struct {
	reg_t	*gpr_rgptr;	/* Pointer to the region.	*/
	int	gpr_count;	/* Number of pages from this	*/
				/* region in spglist and 	*/
				/* fpglist.			*/
} gprgl_t;

extern gprgl_t	gprglst[];
extern int	gprgndx;


/*	The following structure is used to maintain a list of
 *	pages to be stolen by getpages.
 */

typedef struct {
	pde_t	*gp_ptptr;	/* Ptr to page table entry.	*/
	gprgl_t	*gp_rlptr;	/* Ptr to region list entry.	*/
} pglst_t;

/*	The following define sets the maximum size chunk which
 *	getpages can swap out at once.  The tuneable parameter
 *	tune.t_maxsc can never be made larger than this value.
 */

#define MAXSPGLST	100

/*	The following list is used to accumulate pages which we
**	wish to steal but which must be written to swap first.
*/

extern pglst_t	spglst[];
extern int	spglndx;

/*	The following list is used to accumulate pages which we
**	wish to steal and which have a current copy on swap or
**	a file and thus do not require any I/O to be done before
**	they can be stolen.  The reason for accummulating them
**	in a list instead of free each page as it is found is
**	to reduce the number of ATB purges required.
*/

#define	MAXFPGLST	100

extern pglst_t	fpglst[];
extern int	fpglndx;


/*	The following word is used to lock the getpages tables
**	described above so that vhand and sched can't both
**	use them at the same time.
*/

extern int	pglstlock;
extern int	pglstlk();
extern int	pglstunlk();


#endif	/* _SYS_GETPAGES_H */
