#ident	"@(#)hpfp.h	1.3	91/06/04"
#ident "@(#)hpfp.h	1.2 90/03/09"
/*
 *	this prototype file is contained in the include/sys
 *	subdirectory to enable linking with the space.c module
 *	in the kernel package building routines.
 */

struct vj_cfg {
    int             interrupt;
    int             baseaddr;
    int             baseio;
};

/***
 *** Configuration defines: set to 0 to turn off, 1 to turn on
 ***/
#define	HARD_GROUPING	0	/* Have hardware do scatter/gather */
#define	SOFT_GROUPING	1	/* Have software do scatter/gather */
#define	NO_SYNC_XFER	0	/* Supress synchronous transfer */
#define	VJ_DEBUG	0	/* Allow debugging printfs */


/*
 *   VJ_struct.h : V/SCSI 4210 Jaguar MACSI drive header.
 *
 *   Created: 06/08/87 by Interphase Corp.
 *
 *   Author: Keith Wiles
 *
 *   Contains all of the structs and types for Jaguar MACSI.
 *
 */

#define NUM_CQE			10
#define MAX_IOPB		64
#define NUM_IOPB		NUM_CQE
#define S_IOPB_RES		(MAX_IOPB - sizeof(VJ_short_IOPB))
#define S_SHORTIO		2048
#define S_IOPB			sizeof(VJ_IOPB)
#define S_CIB			sizeof(VJ_CIB)
#define S_MCSB			sizeof(VJ_MCSB)
#define S_MCE			sizeof(VJ_CQE)
#define S_CQE			(sizeof(VJ_CQE) * NUM_CQE)
#define S_HIOPB			(sizeof(VJ_IOPB) * NUM_IOPB)
#define S_HSB			sizeof(VJ_HSB)
#define S_CRB			sizeof(VJ_CRB)
#define S_CSS			sizeof(VJ_CSB)
#define S_NOT_HOST		(S_MCSB + S_MCE + S_CQE + S_HIOPB + S_IOPB + \
				 S_CIB + S_HSB + S_CRB + S_IOPB + S_CSS)
#define S_HUS_FREE  	(S_SHORTIO - S_NOT_HOST)

#define S_WQCF			sizeof(VJ_WQCF)

#define HOST_ID			0x4321
#define WORDP(x)		((x)->U.w)
#define WORD_(x)		((x).U.w)

/****************     Master Control Status Block (MCSB) *******************/

typedef struct msr {		/* Master Status Register              */
    union {
	struct {
	    Bit 	CNA  :  1; /* Controller Not Available  (LSB)     */
	    Bit		BOK  :  1; /* Board OK                            */
	    Bit		QFC  :  1; /* Queue Flush Complete                */
	    Bit		RSRV : 13; /* reserved bits             (MSB)     */
	} b;
	UWORD	w;
    } U;
} VJ_MSR;

#ifdef BYTESWAP
#define M_MSR_QFC		0x0400     /* swapped - 0x0004 */
#define M_MSR_BOK		0x0200     /* swapped - 0x0002 */
#define M_MSR_CNA		0x0100     /* swapped - 0x0001 */
#else
#define M_MSR_QFC		0x0004     /* swapped - 0x0004 */
#define M_MSR_BOK		0x0002     /* swapped - 0x0002 */
#define M_MSR_CNA		0x0001     /* swapped - 0x0001 */
#endif
#define W_MSR(x)		((x).U.w)

typedef struct mcr {	/* Master Control Register             */
    union {
	struct {
	    Bit		SQM   : 1;/* Start Queue Mode      (LSB)         */
	    Bit		      : 1;/* reserved bits                       */
	    Bit		FLQR  : 1;/* Flush Queue and Report              */
	    Bit		      : 8;/* reserved bits                       */
	    Bit		FLQ   : 1;/* Flush Queue                         */
	    Bit		RES   : 1;/* Reset controller                    */
	    Bit		SFEN  : 1;/* Sysfail Enable                      */
	    Bit		RSRV0 : 2;/* reserved bits         (MSB)         */
	} b;
	UWORD	w;
    } U;
} VJ_MCR;

#ifdef BYTESWAP
#define M_MCR_SFEN		0x0020       /* swapped - 0x2000 */
#define M_MCR_RES		0x0010       /* swapped - 0x1000 */
#define M_MCR_FLQ		0x0008       /* swapped - 0x0800 */
#define M_MCR_FLQR		0x0400       /* swapped - 0x0004 */
#define M_MCR_SQM		0x0100       /* swapped - 0x0001 */
#else
#define M_MCR_SFEN		0x2000       /* swapped - 0x2000 */
#define M_MCR_RES		0x1000       /* swapped - 0x1000 */
#define M_MCR_FLQ		0x0800       /* swapped - 0x0800 */
#define M_MCR_FLQR		0x0004       /* swapped - 0x0004 */
#define M_MCR_SQM		0x0001       /* swapped - 0x0001 */
#endif
#define W_MCR(x)		((x).U.w)

typedef struct iqar {		/* Interrupt on Queue Available Reg    */
    union {
	struct {
	    Bit		     : 8;/* Unused on E/SCSI 4810               */
	    Bit		INUM : 4;/* Interrupt Number on Queue Available */
	    Bit		     : 2;/* Reserved bits                       */
	    Bit		IQEH : 1;/* Interrupt on Queue Half Empty Enable*/
	    Bit		IQEA : 1;/* Interrupt on Queue entry Available  */
	} b;
	UWORD	w;
    } U;
} VJ_IQAR;

#ifdef BYTESWAP
#define M_IQAR_IQEA		0x0080       /* swapped 0x8000 */
#define M_IQAR_IQEH		0x0040       /* swapped 0x4000 */
#define M_IQAR_NUM 		0x000F       /* swapped 0x0F00 */
#else
#define M_IQAR_IQEA		0x8000       /* swapped 0x8000 */
#define M_IQAR_IQEH		0x4000       /* swapped 0x4000 */
#define M_IQAR_NUM 		0x0F00       /* swapped 0x0F00 */
#endif
#define W_IQAR(x)		((x).U.w)

typedef struct thaw {		/* Unfreeze the given work queue       */
    union {
	struct {
	    Bit		TWQE : 1;/* Thaw Work Queue Enable    (LSB)     */
	    Bit		     : 7;/* Reserved bits                       */
	    Bit		TWQN : 8;/* Thaw Work Queue Number    (MSB)     */
	} b;
	UWORD	w;
    } U;
} VJ_THAW;

#ifdef BYTESWAP
#define M_THAW_TWQN		0x00FF       /* swapped - 0xFF00 */
#define M_THAW_TWQE		0x0100       /* swapped - 0x0001 */
#else
#define M_THAW_TWQN		0xFF00       /* swapped - 0xFF00 */
#define M_THAW_TWQE		0x0001       /* swapped - 0x0001 */
#endif
#define W_THAW(x)		((x).U.w)

typedef struct mcsb {		/* Master control/Status Block         */
    VJ_MSR		mcsb_MSR;/* Master status register              */
    VJ_MCR		mcsb_MCR;/* Master Control register             */
    VJ_IQAR		mcsb_IQAR;/* Interrupt on Queue Available Reg    */
    UWORD		mcsb_QHDP;/* Queue head pointer                  */
    VJ_THAW		mcsb_THAW;/* Thaw work Queue                     */
    UWORD		mcsb_RES0;/* Reserved word 0                     */
    UWORD		mcsb_RES1;/* Reserved word 1                     */
    UWORD		mcsb_RES2;/* Reserved word 2                     */
} VJ_MCSB;

/**************** END Master Control Status Block (MCSB) *******************/

/****************     Host Semaphore Block (HSB)         *******************/

typedef struct hsb {		/* Host Semaphore Block                */
    UWORD	hsb_INITQ;	/* Init MCE Flag                       */
    UWORD	hsb_WORKQ;	/* Work Queue number                   */
    UWORD	hsb_MAGIC;	/* Magic word                          */
    UWORD	hsb_RES0;	/* Reserved word                       */
} VJ_HSB;

/**************** END Host Semaphore Block (HSB)         *******************/

/****************     Perform Diagnostics Command Format *******************/

typedef struct pdcf {		/* Perform Diagnostics Command Format  */
    UWORD	pdcf_CMD;	/* Command normally 0x40               */
    UWORD	pdcf_RES0;	/* Reserved word                       */
    UWORD	pdcf_STATUS;	/* Return Status                       */
    UWORD	pdcf_RES1;	/* Reserved Word                       */
    UWORD	pdcf_ROM;	/* ROM Test Results                    */
    UWORD	pdcf_BUFRAM;	/* Buffer RAM results                  */
    UWORD	pdcf_EVENT_RAM;	/* Event Ram test Results              */
    UWORD	pdcf_SCSI_PRI_PORT;/* SCSI Primary Port Register test     */
    UWORD	pdcf_SCSI_SEC_PORT;/* SCSI Secondary Port Register test   */
} VJ_PDCF;
#define PDCF_SUCCESS		0xFFFF

/**************** END Perform Diagnostics Command Format *******************/

/***************      Controller Initialization Block (CIB)*****************/

typedef struct vect {		/* Vector structure                    */
    union {
	struct {
	    Bit		     : 8;/* Unused on E/SCSI 4810               */
	    Bit		INUM : 4;/* Interrupt Number                    */
	    Bit		     : 4;/* Reserved bits        (MSB)          */
	} b;
	UWORD	w;
    } U;
} VJ_VECT;

#ifdef BYTESWAP
#define M_VECT_INUM		0x000F       /* swapped - 0x0F00 */
#else
#define M_VECT_INUM		0x0F00       /* swapped - 0x0F00 */
#endif
#define W_VECT(x)		((x).U.w)

typedef struct psid {		/* Primary/Secondary bus ID            */
    union {
	struct {
	    Bit		ID   : 3;/* Primary/Secondary SCSI ID  (LSB)    */
	    Bit		DFT  : 1;/* Default ID enable                   */
	    Bit		     : 12;/* Reserved bits              (MSB)    */
	} b;
	UWORD	w;
    } U;
} VJ_PSID;

#ifdef BYTESWAP
#define M_PSID_DFT		0x0800      /* swapped - 0x0008 */
#define M_PSID_ID		0x0700      /* swapped - 0x0007 */
#else
#define M_PSID_DFT		0x0008      /* swapped - 0x0008 */
#define M_PSID_ID		0x0007      /* swapped - 0x0007 */
#endif
#define W_PSID(x)		((x).U.w)

typedef struct addr {		/* Address type and Modifier           */
    union {
	struct {
	    Bit		      : 8;/* Unused on E/SCSI 4810               */
	    Bit		MEMT  : 2;/* Memory   Type                       */
	    Bit		TRANS : 2;/* Transfer Type                       */
	    Bit		      : 3;/* Reserved bits       (MSB)           */
	    Bit		SGLNK : 1;/* Link into SG list   (MSB)           */
	} b;
	UWORD	w;
    } U;
} VJ_ADR;

#ifdef BYTESWAP
#define M_ADR_SGLNK		0x0080       /* swapped - 0x8000 */
#define M_ADR_TRANS		0x000C       /* swapped - 0x0C00 */
#define M_ADR_MEMT		0x0003       /* swapped - 0x0300 */
#else
#define M_ADR_SGLNK		0x8000       /* swapped - 0x8000 */
#define M_ADR_TRANS		0x0C00       /* swapped - 0x0C00 */
#define M_ADR_MEMT		0x0300       /* swapped - 0x0300 */
#endif
#define W_ADR(x)		((x).U.w)

typedef struct cib {		/* Controller Initialization Block     */
    UWORD	cib_NCQE;	/* Number of Command Queue Entries     */
    UWORD	cib_BURST;	/* DMA Burst count                     */
    VJ_VECT	cib_NINUM;	/* Normal Completion Interrupt Number  */
    VJ_VECT	cib_EINUM;	/* Error Completion Interrupt Number   */
    VJ_PSID	cib_PID;	/* Primary SCSI Bus ID                 */
    VJ_PSID	cib_SID;	/* Secondary SCSI Bus ID               */
    UWORD	cib_CRBO;	/* Command Response Block Offset       */
    UWORD	cib_SELECT_msw;	/* Selection timeout in milli_second   */
    UWORD	cib_SELECT_lsw;	/* Selection timeout in milli_second   */
    UWORD	cib_WKQ0_TIMO_msw;/* Work Queue 0 timeout (256 ms)       */
    UWORD	cib_WKQ0_TIMO_lsw;/* Work Queue 0 timeout (256 ms)       */
    UWORD	cib_ESATIMO_msw;/* EISA Time out in   30  milli-second */
    UWORD	cib_ESATIMO_lsw;/* EISA Time out in   30  milli-second */
    UWORD	cib_RES0[2];	/* Reserved words                      */
    VJ_ADR	cib_OB_CRB_ADDR;/* Offboard CRB host memory addr       */
    UWORD	cib_OB_CRB_msw;	/* Offboard CRB host memory addr       */
    UWORD	cib_OB_CRB_lsw;	/* Offboard CRB host memory addr       */
    UWORD	cib_ERR_REC_FLAG;/* Error recovery flags                */
    UWORD	cib_RES1;        /* Error recovery flags                */
} VJ_CIB;

/**************** END Controller Initialization Block (CIB)*****************/

/****************     Command Queue Entry (CQE)          *******************/

typedef struct qecr {		/* Queue Entry Control Register        */
    union {
	struct {
	    Bit		GO   : 1;/* Go/Busy               (LSB)         */
	    Bit		AA   : 1;/* Abort Acknowledge                   */
	    Bit		HPC  : 1;/* High Priority Command               */
	    Bit		     : 1;/* Reserved bit                        */
	    Bit		OBIO : 1;/* Fetch off board IOPB                */
	    Bit		     : 3;/* Reserved bit                        */
	    Bit		IOPB : 4;/* IOPB type   ( must be zero )        */
	    Bit		     : 4;/* Reserved bits         (MSB)         */
	} b;
	UWORD	w;
    } U;
} VJ_QECR;

#ifdef BYTESWAP
#define M_QECR_IOPB		0x000F       /* swapped - 0x0F00 */
#define M_QECR_OBIO		0x1000       /* swapped - 0x0010 */
#define M_QECR_HPC		0x0400       /* swapped - 0x0004 */
#define M_QECR_AA		0x0200       /* swapped - 0x0002 */
#define M_QECR_GO		0x0100       /* swapped - 0x0001 */
#else
#define M_QECR_IOPB		0x0F00       /* swapped - 0x0F00 */
#define M_QECR_OBIO		0x0010       /* swapped - 0x0010 */
#define M_QECR_HPC		0x0004       /* swapped - 0x0004 */
#define M_QECR_AA		0x0002       /* swapped - 0x0002 */
#define M_QECR_GO		0x0001       /* swapped - 0x0001 */
#endif
#define W_QECR(x)		((x).U.w)

#define	CQE_GO(qecr)		(W(qecr) |= M_QECR_GO)
#define	CQE_AA_GO(qecr)		(W(qecr) |= (M_QECR_GO + M_QECR_AA))

typedef struct cqe {		/* Command Queue Entry                 */
    VJ_QECR	cqe_QECR;	/* Queue Entry Control Register        */
    UWORD	cqe_IOPB_ADDR;      /* IOPB Address                        */
    LONGV	cqe_CTAG;	/* Command Tag                         */
#ifdef BYTESWAP
    UBYTE	cqe_IOPB_LENGTH;/* IOPB Length                         */
    UBYTE	cqe_WORK_QUEUE;	/* Work Queue Number                   */
#else
    UBYTE	cqe_WORK_QUEUE;	/* Work Queue Number                   */
    UBYTE	cqe_IOPB_LENGTH;/* IOPB Length                         */
#endif
#ifdef LATER
    LONGV	cqe_LINKP;			/* CQE Link pointer, won't work on sun4*/
#endif
    UWORD	cqe_RES0;			/* Reserved word                       */
} VJ_CQE;

/**************** END Command Queue Entry (CQE)          *******************/

/****************     Command Response Block (CRB)       *******************/

typedef struct crsw {		/* Command Response Status Word        */
    union {
	struct {
	    Bit		CRBV  : 1;/* Command Response Block Valid/Clear  */
	    Bit		CC    : 1;/* Command Complete                    */
	    Bit		ER    : 1;/* Error                               */
	    Bit		EX    : 1;/* Exception                           */
	    Bit		AQ    : 1;/* Abort Queue                         */
	    Bit		QMS   : 1;/* Queue Mode Started                  */
	    Bit		CQA   : 1;/* Command Queue Entry Available       */
	    Bit		STAT  : 1;/* Status Changes                      */
	    Bit		      : 8;/* Reserved bits        (MSB)          */
	} b;
	UWORD	w;
    } U;
} VJ_CRSW;

#ifdef BYTESWAP
#define M_CRSW_STAT 	0x8000       /* swapped 0x0080 */
#define M_CRSW_CQA		0x4000       /* swapped 0x0040 */
#define M_CRSW_QMS		0x2000       /* swapped 0x0020 */
#define M_CRSW_AQ		0x1000       /* swapped 0x0010 */
#define M_CRSW_EX		0x0800       /* swapped 0x0008 */
#define M_CRSW_ER		0x0400       /* swapped 0x0004 */
#define M_CRSW_CC		0x0200       /* swapped 0x0002 */
#define M_CRSW_CRBV		0x0100       /* swapped 0x0001 */
#else
#define M_CRSW_STAT 		0x0080       /* swapped 0x0080 */
#define M_CRSW_CQA		0x0040       /* swapped 0x0040 */
#define M_CRSW_QMS		0x0020       /* swapped 0x0020 */
#define M_CRSW_AQ		0x0010       /* swapped 0x0010 */
#define M_CRSW_EX		0x0008       /* swapped 0x0008 */
#define M_CRSW_ER		0x0004       /* swapped 0x0004 */
#define M_CRSW_CC		0x0002       /* swapped 0x0002 */
#define M_CRSW_CRBV		0x0001       /* swapped 0x0001 */
#endif
#define W_CRSW(x)		((x).U.w)

#define	CRB_CLR_DONE(crsw)	(W(crsw) &= ~M_CRSW_CRBV)

typedef struct crb {		/* Command Response Block              */
    VJ_CRSW	crb_CRSW;	/* Command Response Status Word        */
    UWORD	crb_RES0;	/* Reserved word                       */
    LONGV	crb_CTAG;	/* Command Tag                         */
#ifdef BYTESWAP
    UBYTE	crb_IOPB_LENGTH;/* IOPB Length                         */
    UBYTE	crb_WORK_QUEUE;	/* Work Queue Number                   */
#else
    UBYTE	crb_WORK_QUEUE;	/* Work Queue Number                   */
    UBYTE	crb_IOPB_LENGTH;/* IOPB Length                         */
#endif
    UWORD	crb_RES1;/* Reserved word                       */
} VJ_CRB;

/**************** END Command Response Block (CRB)       *******************/

/****************     Configuration Status Block (CSB)   *******************/

typedef struct csb {				/* Configuration Status Block 120 bytes*/
    UWORD	csb_RES0;	/* Reserved word                       */
    UBYTE	csb_RES1;	/* Reserved byte                       */
    UBYTE	csb_PCODE[3];	/* Product Code                        */
    UWORD	csb_RES2;	/* Reserved word                       */
    UBYTE	csb_RES3;	/* Reserved byte                       */
    UBYTE	csb_PVAR;	/* Product Variation                   */
    UWORD	csb_RES4;	/* Reserved word                       */
    UBYTE	csb_RES5;	/* Reserved byte                       */
    UBYTE	csb_FREV[3];	/* Firmware Revision level             */
    UWORD	csb_RES6;	/* Reserved word                       */
    UBYTE	csb_FDATE[8];	/* Firmware Release date               */
    UWORD	csb_RES7;	/* Reserved word                       */
    UWORD	csb_BSIZE;	/* Buffer size in Kbytes               */
    UWORD	csb_RES8[2];	/* Reserved word                       */
#ifdef BYTESWAP
    UBYTE	csb_PID;	/* Primary Bus ID                      */
    UBYTE	csb_SID;	/* Secondary Bus ID                    */
#else
    UBYTE	csb_SID;	/* Secondary Bus ID                    */
    UBYTE	csb_PID;	/* Primary Bus ID                      */
#endif
    UBYTE	csb_RES9[84];	/* Reserved bytes                      */
} VJ_CSB;

/**************** END Configuration Status Block (CSB)   *******************/

/****************     IOPB Format (IOPB)                 *******************/

typedef struct option {				/* IOPB Option word                    */
    union {
	struct {
	    Bit		IE    : 1;/* Interrupt Enable       (LSB)        */
	    Bit		SG    : 1;/* Scatter/Gather bit                  */
	    Bit		SS    : 1;/* Supress Sync Transfer               */
	    Bit		      : 5;/* Reserved bits                       */
	    Bit		DIR   : 1;/* EISA Direction bit                  */
	    Bit		      : 7;/* Reserved bits          (MSB)        */
	} b;
	UWORD	w;
    } U;
} VJ_OPT;

#ifdef BYTESWAP
#define M_OPT_DIR		0x0001      /* swapped - 0x0100 */
#define M_OPT_BL		0x0800      /* swapped - 0x0008 */
#define M_OPT_SS		0x0400      /* swapped - 0x0004 */
#define M_OPT_SG		0x0200      /* swapped - 0x0002 */
#define M_OPT_IE		0x0100      /* swapped - 0x0001 */
#else
#define M_OPT_DIR		0x0100
#define M_OPT_BL		0x0008
#define M_OPT_SS		0x0004
#define M_OPT_SG		0x0002
#define M_OPT_IE		0x0001
#endif
#define W_OPT(x)		((x).U.w)

typedef struct unit {		/* SCSI Unit address                   */
    union {
	struct {
	    Bit		SCSI_ID : 3;/* SCSI Device ID         (LSB)        */
	    Bit		LUN     : 3;/* Logical Unit Number                 */
	    Bit		BUS     : 1;/* SCSI Bus Selection                  */
	    Bit		EXT     : 1;/* Extended Address Enable             */
	    Bit		EXT_ADR : 8;/* Extended Adress        (MSB)        */
	} b;
	UWORD	w;
    } U;
} VJ_UADR;

#ifdef BYTESWAP
#define M_UNIT_EXT_ADR		0x00FF    /* swapped 0xFF00 */
#define M_UNIT_EXT			0x8000    /* swapped 0x0080 */
#define M_UNIT_BUS			0x0040    /* swapped 0x0040 */
#define M_UNIT_LUN			0x3800    /* swapped 0x0038 */
#define M_UNIT_ID			0x0700    /* swapped 0x0007 */
#else
#define M_UNIT_EXT_ADR			0xFF00    /* swapped 0xFF00 */
#define M_UNIT_EXT			0x0080    /* swapped 0x0080 */
#define M_UNIT_BUS			0x0040    /* swapped 0x0040 */
#define M_UNIT_LUN			0x0038    /* swapped 0x0038 */
#define M_UNIT_ID			0x0007    /* swapped 0x0007 */
#endif

#define W_UNIT(x)			((x).U.w)

/* short_iopb not currently used */
typedef struct short_iopb {
    UWORD	iopb_CMD;	/* IOPB Command code                   */
    VJ_OPT	iopb_OPTION;	/* IOPB Option word                    */
    UWORD	iopb_STATUS;	/* IOPB Return Status word             */
    UWORD	iopb_RES0;	/* IOPB Reserved word                  */
    UBYTE	iopb_NVCT;	/* IOPB Normal completion Vector       */
    UBYTE	iopb_EVCT;	/* IOPB Error  completion Vector       */
    UWORD	iopb_LEVEL;	/* IOPB Interrupt Level                */
    UWORD	iopb_RES1;	/* IOPB Reserved word                  */
    VJ_ADR	iopb_ADDR;	/* IOPB Address type and modifer       */
    LONGV	iopb_BUFF;	/* IOPB Buffer Address                 */
    LONGV	iopb_LENGTH;	/* IOPB Max-Transfer Length            */
    UWORD	iopb_RES2;	/* IOPB Reserved word                  */
    UWORD	iopb_RES3;	/* IOPB Reserved word                  */
    UWORD	iopb_RES4;	/* IOPB Reserved word                  */
    VJ_UADR	iopb_UNIT;	/* IOPB Unit address on SCSI bus       */
} VJ_short_IOPB;

typedef struct iopb {
    UWORD	iopb_CMD;	/* IOPB Command code                   */
    VJ_OPT	iopb_OPTION;	/* IOPB Option word                    */
    UWORD	iopb_STATUS;	/* IOPB Return Status word             */
    UWORD	iopb_RES0[2];	/* IOPB Reserved word                  */
    UWORD	iopb_INUM;	/* IOPB completion interrupt num       */
    UWORD	iopb_RES1;	/* IOPB Reserved word                  */
    VJ_ADR	iopb_ADDR;	/* IOPB Address type and modifer       */
    LONGV	iopb_BUFF;	/* IOPB Buffer Address                 */
    LONGV	iopb_LENGTH;/* IOPB Max-Transfer Length            */
    UWORD	iopb_RES2;	/* IOPB Reserved word (or S/G total)   */
    UWORD	iopb_RES3;	/* IOPB Reserved word (or S/G total)   */
    UWORD	iopb_RES4;	/* IOPB Reserved word                  */
    VJ_UADR	iopb_UNIT;	/* IOPB Unit address on SCSI bus       */
    UWORD	iopb_SCSI[S_IOPB_RES/2];/* IOPB SCSI words for pass through    */
} VJ_IOPB;

/**************** END IOPB Format (IOPB)                 *******************/

/****************     Initialize Work Queue Command Format (WQCF)***********/

typedef struct wopt {				/* Work Queue Options                  */
    union {
	struct {
	    Bit		AE   : 1;/* Abort Enable             (LSB)      */
	    Bit		TM   : 1;/* Target Mode Enable                  */
	    Bit		FE   : 1;/* Freeze on error enable              */
	    Bit		PE   : 1;/* Parity check enable                 */
	    Bit		     : 11;/* Reserved bits                       */
	    Bit		IWQ  : 1;/* Initialize Work Queue    (MSB)      */
	} b;
	UWORD	w;
    } U;
} VJ_WOPT;

#ifdef BYTESWAP
#define M_WOPT_IWQ		0x0080      /* swapped - 0x8000 */
#define M_WOPT_FE		0x0400      /* swapped - 0x0004 */
#define M_WOPT_TM		0x0200      /* swapped - 0x0002 */
#define M_WOPT_AE		0x0100      /* swapped - 0x0001 */
#define M_WOPT_PE		0x0800	    /* swapped - 0x0008 */
#else
#define M_WOPT_IWQ		0x8000
#define M_WOPT_FE		0x0004
#define M_WOPT_TM		0x0002
#define M_WOPT_AE		0x0001
#define M_WOPT_PE		0x0008
#endif

#define W_WOPT(x)		((x).U.w)

typedef struct wqcf {		/* Initialize Work Queue Command Format*/
    UWORD	wqcf_CMD;	/* Command Normally (0x42)             */
    VJ_OPT	wqcf_OPTION;	/* Command Options                     */
    UWORD	wqcf_STATUS;	/* Return Status                       */
    UWORD	wqcf_RES0[2];	/* Reserved word                       */
    UWORD	wqcf_INUM;	/* Completion Interrupt Number         */
    UWORD	wqcf_RES1[8];	/* Reserved                            */
    UWORD	wqcf_WORKQ;	/* Work Queue Number                   */
    VJ_WOPT	wqcf_WOPT;	/* Work Queue Options                  */
    UWORD	wqcf_SLOTS;	/* Number of slots int the Work Queues */
    UWORD	wqcf_RES2;	/* Reserved                            */
    UWORD	wqcf_TIMEOUT;	/* Command Timeout                     */
    UWORD	wqcf_RES3;	/* Reserved                            */
} VJ_WQCF;

/**************** END Initialize Work Queue Command Format (WQCF)***********/

/****************     Short I/O Format                   *******************/

typedef struct shortio {
    VJ_MCSB	sh_MCSB;	/* Master Control / Status Block       */
    VJ_CQE	sh_MCE;		/* Master Command Entry                */
    VJ_CQE	sh_CQE[NUM_CQE];/* Command Queue Entry                 */
    VJ_IOPB	sh_IOPB[NUM_IOPB];/* Host IOPB   Space                   */
    VJ_IOPB	sh_MCE_IOPB;	/* Host MCE IOPB Space                 */
    VJ_CIB	sh_CIB;		/* Controller Initialization Block     */
    UBYTE	sh_HUS[S_HUS_FREE];/* Host Usable Space                   */
    VJ_HSB	sh_HSB;		/* Host Semaphore Block                */
    VJ_CRB	sh_CRB;		/* Command Response Block              */
    VJ_IOPB	sh_RET_IOPB;	/* Returned IOPB                       */
    VJ_CSB	sh_CSS;		/* Controller Specific Space/Block     */
} VJ_SHIO;

/**************** END Short I/O Format                   *******************/

#if SOFT_GROUPING
/*
 * Scatter gather structure
 */
typedef struct ipsg {
    USHORT	sg_count;/* byte/entry count   */
    USHORT	sg_addrhi; /* datablock/entry address high		   */
    USHORT	sg_addrlo;/* datablock/entry address low		   */
    VJ_ADR	sg_meminfo;/* memory information		   */
}IPSG;

#define NUM_M_SG 	16	/* number of free pool entries per ctlr*/
#define MACSI_SG	64	/* number of MACSI scat/gat entries    */
#define	S_MACSI_SG	(MACSI_SG*sizeof(IPSG))

/* When Running MACSI, Scatter/gather tables MUST be in external memory
 * We will declare a free pool of scatter/gather tables in each ctlr struct
 * NUM_M_SG defines the number of entries in the free pool per controller.
 *
 *	The driver will add & remove from the top of the free list.
 * ALSO:
 *	The free list had to be in each ctlr struct instead of 1 common
 *	pool because if the controller start routine gets called at interrupt
 *	level, and there are no more free entries available, sleep cannot
 *	be called and there might not be any more requests comming in for
 *	that controller.
 */

typedef struct ipsg_free {
    struct ipsg_free *nxt;		/* pointer to next IPSG_FREE	*/
#if !SUN
    IPSG	ipsg[MACSI_SG];
#else /* SUN */
    int		ipsg_entry;	/* this entries number */
    IPSG	*ipsg;
    int		ipsg_num;	/* number of the following mbinfo's used */
    ULONG	ipsg_mbinfo[MACSI_SG]; /* for mbrelse */
#endif
} IPSG_FREE;
#endif /* SOFT_GROUPING */

/***************************************************************************
 ***************************************************************************
                             from vj_reg.h
 ***************************************************************************
 ***************************************************************************/


#define VJCTLRS(req)		(((req)->ha_num >> 1) & 1)
#define	VJUNIT(req)		(((req)->ha_num & 1) ? (req)->id + 8 : (req)->id )

#define	SCSIBUS(req)	((req)->ha_num & 1)
#define	IS_RW_REQ(req)	((req)->scsi_cmd.raw[0] == READ_CMD || \
				 (req)->scsi_cmd.raw[0] == WRITE_CMD)

/* Unit/device type flags */
#define	DT_DISK			0x01
#define	DT_TAPE			0x02
#define	DT_PRINTER		0x04
#define	DT_PROCESSOR	0x08
#define	DT_WORM			0x10
#define	DT_OPTICAL		0x20
#define	DT_DIRECT		(DT_DISK | DT_WORM | DT_OPTICAL)

/*
 *	Unit queue elements
 */
typedef	struct	vj_qele	{
    struct vj_qele	*q_forw;	/* forward pointer	  */
    struct vj_qele	*q_back;	/* backward pointer (for grouping)  */
    ULONG		q_pblkno;	/* physical block number from cdb  */
    REQ_IO		*q_req;		/* pointer to the request	  */
} VJ_QELE;

/*
 *	Data per unit
 */
typedef	struct	vj_unit	{
    struct 	vj_unit *un_next; /* next unit on the controller's queue*/
    struct 	ctlr	*un_ctlr; /* pointer back to controller	 */
    UBYTE 	un_init;	  /* unit is initialized	  */
    UBYTE	un_active;	       /* unit is on controller's queue	  */
    UBYTE	un_workq;	/* unit's work queue			  */
    UBYTE	un_slave;	/* unit's SCSI ID and bus		  */
    VJ_QELE	*un_actf;	/* first request on unit queue		  */
    VJ_QELE	*un_actl;	/* last request on unit queue		  */
    VJ_QELE	*un_acts;	/* request on unit queue to sort after*/
    UINT	un_iocnt;	/* number of I/O requests		  */
    UINT	un_qcount;	/* number of workq entries used		  */
    UBYTE	un_type;	/* unit's device type			  */
    UBYTE	un_heads;	/* number of heads (disks)		  */
    UWORD	un_nspt;	/* number sectors per track (disks)	  */
    ULONG	un_cyls;	/* number of cylinders (disks)		  */
    struct scsi_sense un_sense;	/* request sense data			  */
} VJ_UNIT;

/*
 *	Data per controller
 */
typedef struct	ctlr	{
    USHORT	c_ctlrno;	/* number of controller               	*/
    BYTE	c_init;		/* is ctlr initialized?			*/
    BYTE	c_pid;		/* ctlr's primary bus SCSI id		  */
    BYTE	c_sid;		/* ctlr's secondary bus SCSI id		  */
    USHORT	c_nintnum;	/* normal interrupt number            */
    USHORT	c_eintnum;	/* error interrupt number             */
    struct vj_unit c_units[16];	/* ctlr's unit array			  */
    VJ_SHIO	*c_io;		/* ptr to I/O space (shared memory)	  */
    USHORT	c_iob_addr;	/* base I/O address (programmed I/O)  */
    BYTE	c_wait_cqe;	/* waiting on room in CQE's		   */
    BYTE	c_busy;		/* the board is busy			  */
    USHORT	c_ccount;	/* the number of commands on the board*/
    struct vj_unit *c_first;	/* head of the unit queue		  */
    struct vj_unit *c_last;	/* tail of the unit queue		  */
    VJ_IOPB	*c_mce_iopb;	/* Address of MCE IOPB			  */
    VJ_CQE	*c_cqe_top;	/* Top pointer to CQE list		  */
    VJ_CQE	*c_cqe_end;	/* End pointer to CQE list		  */
    VJ_QELE	*c_snscmd[16];	/* vj_sense() qp in vj_eint()		  */
#if SOFT_GROUPING
    IPSG_FREE	*c_sg_hd;	/* points to next free entry		  */
    IPSG_FREE	c_sg_fentry[NUM_M_SG]; /* s/g free list			  */
#endif
} VJ_CTLR;

/*
 *	Mode Sense structures
 */
typedef struct mode_sense_hdr {
	UBYTE	sense_data_len;		/* sense data length */
	UBYTE	medium_type;		/* medium_type */
	UBYTE	resv  : 7;
	UBYTE	WP: 1;              /* msb */
	UBYTE	blk_desc_len;	/* block descriptor length */
} VJ_MS_HDR;

typedef struct mode_sense_blk_desc {
	UBYTE	density_code;
	UBYTE	nob_high;	/* no. of blocks */
	UBYTE	nob_mid;
	UBYTE	nob_low;
	UBYTE	resv;
	UBYTE	blk_len_high;	/* block length */
	UBYTE	blk_len_mid;
	UBYTE	blk_len_low;
} VJ_MS_BLK_DESC;

typedef struct mode_sense_page_1 {
	UBYTE	page_code	: 6;
	UBYTE	res0		: 2;    /* ms bits */
	UBYTE	page_length;
	UBYTE	dcr			: 1;    /* lsb */
	UBYTE	dte 		: 1;
	UBYTE	per 		: 1;
	UBYTE	ecc			: 1;
	UBYTE	rc  		: 1;
	UBYTE	tb  		: 1;
	UBYTE	arre		: 1;
	UBYTE	awre		: 1;    /* msb */
	UBYTE	retry_count;
	UBYTE	correction_span;
	UBYTE	head_offset;
	UBYTE	strobe_offset;
	UBYTE	recovery_time;
} VJ_MS_PAGE1;

typedef struct mode_sense_page_2 {
	UBYTE	page_code	: 6;    /* ls bits */
	UBYTE	res0		: 2;
	UBYTE	page_length;
	UBYTE	buffer_full_ratio;
	UBYTE	buffer_empty_ratio;
	UBYTE	res1[8];
} VJ_MS_PAGE2;

typedef struct mode_sense_page_3 {
	UBYTE	page_code	: 6;    /* ls bits */
	UBYTE	res0		: 2;
	UBYTE	page_length;
	UBYTE	trk_per_zone_hi;			/* track per zone */
	UBYTE	trk_per_zone_lo;
	UBYTE	alt_sctr_per_zone_hi; 		/* alternate sectors per zone */
	UBYTE	alt_sctr_per_zone_lo;
	UBYTE	alt_trk_per_zone_hi;		/* alternate tracks per zone */
	UBYTE	alt_trk_per_zone_lo;
	UBYTE	alt_trk_per_vol_hi;			/* alternate tracks per volume */
	UBYTE	alt_trk_per_vol_lo;
	UBYTE	sctr_per_trk_hi;			/* sectors per track */
	UBYTE	sctr_per_trk_lo;
	UBYTE	byte_per_phy_sctr_hi;		/* bytes per physical sector */
	UBYTE	byte_per_phy_sctr_lo;
	UBYTE	interleave_value_hi;		/* interleave_value */
	UBYTE	interleave_value_lo;
	UBYTE	res1[8];
} VJ_MS_PAGE3;

typedef struct mode_sense_page_4 {
	UBYTE	page_code	: 6;        /* ls bits */
	UBYTE	res0		: 2;
	UBYTE	page_length;
	UBYTE	max_no_cyl_hi;			/* max no of cylinders */
	UBYTE	max_no_cyl_mid;
	UBYTE	max_no_cyl_lo;
	UBYTE	max_no_heads; 			/* max no of heads */
	UBYTE	res1[14];
} VJ_MS_PAGE4;

typedef struct mode_sense {
	VJ_MS_HDR		hdr;
	VJ_MS_BLK_DESC  blk_desc;
	VJ_MS_PAGE1		pg1;
	VJ_MS_PAGE2		pg2;
	VJ_MS_PAGE3		pg3;
	VJ_MS_PAGE4		pg4;
} VJ_MODE_SENSE;

#ifdef BYTESWAP
/* All of the IOPB command code definitions are byte swapped for the      */
/* E/SCSI 4810 driver                                                     */
/*  SCSI IOPB definitions  - Only SCSI_PASS_THRU currently used */
#define SCSI_PASS_THRU      0x2000    /* SCSI Pass Through commands         */
#define SCSI_PASS_THRU_EXT  0x2100    /* SCSI Pass Through Extended commands*/
#define SCSI_RESET          0x2200    /* SCSI Reset bus                     */

/*  SCSI Control IOPB's - Only CNTR_INIT and CNTR_INIT_WORKQ currently used */
#define CNTR_DIAG           0x4000    /* Perform Diagnostics                */
#define CNTR_INIT           0x4100    /* Initialize Controller              */
#define CNTR_INIT_WORKQ     0x4200    /* Initialize Work Queue              */
#define CNTR_DUMP_INIT      0x4300    /* Dump Initialization Parameters     */
#define CNTR_DUMP_WORDQ     0x4400    /* Dump work Queue Parameters         */
#define CNTR_FLUSH_WORKQ    0x4900    /* Flush Work Queue                   */

#else

#define SCSI_PASS_THRU      0x20    /* SCSI Pass Through commands         */
#define SCSI_PASS_THRU_EXT  0x21    /* SCSI Pass Through Extended commands*/
#define SCSI_RESET          0x22    /* SCSI Reset bus                     */

/*  SCSI Control IOPB's - Only CNTR_INIT and CNTR_INIT_WORKQ currently used */
#define CNTR_DIAG           0x40    /* Perform Diagnostics                */
#define CNTR_INIT           0x41    /* Initialize Controller              */
#define CNTR_INIT_WORKQ     0x42    /* Initialize Work Queue              */
#define CNTR_DUMP_INIT      0x43    /* Dump Initialization Parameters     */
#define CNTR_DUMP_WORDQ     0x44    /* Dump work Queue Parameters         */
#define CNTR_FLUSH_WORKQ    0x49    /* Flush Work Queue                   */

#endif /* BYTESWAP */

/* REQ_IO host_sts field values */
#define HOST_SGBADCNT	    0x01    /* bad transfer size for s-g request  */
