#ident	"@(#)iomem.h	1.2	90/08/08"
/*
 *
 *	@(#)iomem.h	1.17		3/19/90
 *
 */

#include "sys/types.h"


/*	board type codes for struct iomemslot	*/

#define BDTYP_OTHER	0xFFFF
#define BDTYP_SIO	0
#define BDTYP_MDC	1


/*	compressed eisa product ids for SIO and MDC (NOT including the
	4th byte, which is the rev level we don't care about)		*/

#define EID_SIO	0x047304
#define EID_MDC 0x047303


/*	codes for diagnostic result field in struct iomemslot	*/

#define DIAG_PASS	0
#define DIAG_FAIL	1
#define DIAG_UNK	-1


/*	hardware/software limits 	*/

#define MAXSLOTS 16
#define MAXSIOS	4
#define	MAXMDROPS	4


/*	codes for ioctl commands		*/

#define RESET			1
#define START_AND_NOTIFY	2
#define START_NO_NOTIFY		3
#define GETBRDINFO		4
#define SETPASS			5
#define SETFAIL		 	6


/*	values for the flag argument to "notify" functions	*/

#define NOTIFY_DL 1
#define NOTIFY_OFF 2

/*	structure for info specific to each individual board		*/

struct  brdinfo	   {

	unsigned   slot;	/* slot this board lives in */

	unsigned   type;	/* SIO, MDC, OTHER */

	paddr_t	   p_membase,	/* physical shared memory address */
		   v_membase;	/* kernel virtual shared memory address */

	ulong	   memsize;	/* length of shared memory */

	unsigned   portbias;	/* eisa port offset */

	unsigned   intlvl;	/* interrupt level */

	unsigned   intcode;	/* eisa write reg 0 code for intlvl */

	int	   firstminor,  /* first minor device on this board */
		   lastminor;   /* last minor on this board */

	int	   diag;	/* PASS/FAIL state of diagnostics */

	void	  (*notify)();	/* driver notification routine */
};




/*	macros to get parts of minor device number	*/

#define minorslot(d)	(minor(d) & 0x0F)




/*	sio and mdc hardware-related defs follow		*/

/*  note that, except for P_SIOLMCS, these are the same for mdc and sio  */


#define P_MDCINTGEN 0xC00	/* host generate interrupt on mdc */
#define P_MDCINTCLR 0xC01	/* clear interrupt from mdc */
#define P_MDCRDREG 0xC02	/* (read) status info */
#define P_MDCWREG0 0xC04	/* memory enable / interrupt level set */
#define P_MDCWREG1 0xC06	/* shared memory base (upper 14 bits) */
#define P_EISAPRODN 0xC82	/* EISA MDC Product Number */
#define P_EISAREVN 0xC83	/* EISA MDC Revision Number */
#define P_EISACTLBITS 0xC84	/* EISA Control Bits Register */


#define P_SIOLMCS   0xFFA2	/* (80186 port) lower memory chip select */


/*	bits to set/clear and masks to use with sio and mdc ports	

	bits start with B_, masks with M_		*/

#define	B_MDCINTENB 0x0010	/* enable ints */
#define B_MDCMEMENB 0x00C0	/* enable memory */
#define B_RESET   0x00	/* reset */
#define B_RUN     0x01	/* release reset */

#define B_LMCS	0x0FF8	        /* lower chip select: 64k, 0 wait */


#define M_MEMALIGN    0xFFFC	/* force 2 lsb to 0 in memory address */




/*	sio board 80186 reset vector		*/

struct  siorstvec  {

	unsigned char

		movdx,		/* mov dx,#lower_chip_select_port */
		portlow,
		porthi,
		movax,		/* mov ax,#lower_chip_select_value */
		vallow,
		valhi,
		outaxdx,	/* out ax,dx    | set lower chip select */
		longjmp,	/* jmp start_of_text */
		offlow,
		offhi,
		seglow,
		seghi;
};


/*	assembly language instructions for above		*/

#define  INST_MOVDX	0xBA		/* mov dx,#immediate */
#define  INST_MOVAX  0xB8		/* mov ax,#immediate */
#define  INST_OUTAXDX 0xEF		/* out ax,dx */
#define INST_LONGJMP 0xEA		/* jmp cs:off */






/*  number of serial channels per board  */

#define ESIOPORTS 8






#define M_MDCMEM  0xFFFC	/* to save only top 14 address bits */




/*	mdc reset vector			*/

struct  mdcrstvec  {

	unsigned  char

		longjmp,	/* jmp start_of_text */
		offlow,
		offhi,
		seglow,
		seghi;
};




/*	values for interrupt-number to interrupt-code table	*/

/*  mdc and sio can interrupt only on levels 3, 5, 7, 9, 10, 11, 12, 15  */

#define MDCINT00  '\0'
#define MDCINT01  '\0'
#define MDCINT02  '\0'
#define MDCINT03  '\0'
#define MDCINT04  '\0'
#define MDCINT05  '\001'
#define MDCINT06  '\0'
#define MDCINT07  '\002'
#define MDCINT08  '\0'
#define MDCINT09  '\003'
#define MDCINT10  '\004'
#define MDCINT11  '\005'
#define MDCINT12  '\006'
#define MDCINT13  '\0'
#define MDCINT14  '\0'
#define MDCINT15  '\007'

