/*
 *	@(#) machdep.h 2.11 88/12/15 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984, 1985, 1986, 1987, 1988.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987, 1988.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 *	Various machine dependent things
 */

#ifndef _INMACHDEP
#define _INMACHDEP

/* PC/AT Floppy disk control  */
#define FLIOC		('F'<<8)

#define FLIOCFTRK	(FLIOC|1)	/* ioctl command to format a track */
#define FLIOCSIZE	(FLIOC|2)	/* ioctl command to get floppy size */
#define FLIOCPRT	(FLIOC|3)	/* ioctl command to turn on/off prtfs */

#ifdef VPIX
#define F_RAW		(FLIOC|63)
#define F_DOR		(FLIOC|62)
#define F_FCR		(FLIOC|61)
#define F_DTYP		(FLIOC|60)

#define CMD_BYTES	10

/* structure used by F_RAW ioctl command */

struct fdraw {
	unsigned char fr_cmd[CMD_BYTES];    /* user-supplied command bytes */
	short	fr_cnum;		    /* number of command bytes */
	unsigned char fr_result[CMD_BYTES]; /* controller result bytes */
	short	fr_nbytes;		    /* number to transfer if r/w */
	char	*fr_addr;		    /* where to transfer */
};
#endif

/* PC/AT Floppy tape control  */
#define	MTIO			('T' << 8)
#define	MTTENSION		(MTIO | 1)	/* tension the tape */
#define	MTTAPE_STATUS		(MTIO | 2)	/* get tape status */
						/* (see return values below) */
#define	MTERASE_SERVO		(MTIO | 3)	/* erase the servo track */
#define	MTWRITE_SERVO		(MTIO | 4)	/* write the servo track */
#define	MTFORMAT_TRACK		(MTIO | 5)	/* format one tape track */
#define	MTBUILD_BTT		(MTIO | 6)	/* build the bad block table */
						/* and return the number of */
						/* good blocks */
#define	MTCART_TYPE		(MTIO | 7)	/* cartridge type	 */
#define	MTENABLE_BTT		(MTIO | 8)	/* enable bad track table */
#define	MTDISABLE_BTT		(MTIO | 9)	/* disable bad track table */
#define	MTENABLE_ECC		(MTIO | 0xA)	/* enable ecc		 */
#define	MTDISABLE_ECC		(MTIO | 0xB)	/* disable ecc		 */
#define	MTNUM_BB		(MTIO | 0xC)	/* change the number of bufs */
#define MTDC1000		(MTIO | 0xD)
#define MTDC2000		(MTIO | 0xE)

/* Drive types: */

#define	IRWIN_110		5		/* Irwin 10 M tape drive */
#define	IRWIN_145		6		/* Irwin 40 M tape drive */
#define IRWIN_125		7		/* Irwin 20 M tape drive */

/* cartridge tape ioctl commands */

#define	MTIOC		('m'<<8)	/* ioctl code for tape commands */
#define	MT_STATUS	(MTIOC | 0)	/* read tape status */
#define	MT_RESET	(MTIOC | 1)	/* reset tape hardware */
#define	MT_RETEN	(MTIOC | 2)	/* retention tape */
#define	MT_REWIND	(MTIOC | 3)	/* rewind tape */
#define	MT_ERASE	(MTIOC | 4)	/* erase tape */
#define	MT_AMOUNT	(MTIOC | 5)	/* report on amount of data xfered */
#define	MT_RFM		(MTIOC | 6)	/* find next filemark */
#define	MT_WFM		(MTIOC | 7)	/* write filemark */
#define	MT_LOAD		(MTIOC | 8)	/* load tape */
#define	MT_UNLOAD	(MTIOC | 9)	/* unload tape */
#define MT_REPORT	(MTIOC | 64)	/* report device type */

/* device types returned by MT_REPORT */

#define MT_UNKNOWN_TYPE 	0
#define MT_CT_TYPE		1
#define MT_FT_TYPE		2

/*
 * structure returned from ioctl MT_STATUS
 */

union tape_status {
  struct {
    unsigned  short fm		: 1 ;		/* file mark detected */
    unsigned  short nobie	: 1 ;		/* big time booboo */
    unsigned  short derr	: 1 ;		/* unrecoverable data error */
    unsigned  short eot		: 1 ;		/* end of tape */
    unsigned  short wprot	: 1 ;		/* write protected cartridge */
    unsigned  short offln	: 1 ;		/* drive off line */
    unsigned  short nocart	: 1 ;		/* no cartridge in drive */
    unsigned  short eb0		: 1 ;		/* exception byte 0 valid */

    unsigned  short reset	: 1 ;		/* reset/power up occured */
    unsigned  short reserved	: 2 ;
    unsigned  short bot		: 1 ;		/* beginning of tape */
    unsigned  short retry	: 1 ;		/* 8 or more read retrys */
    unsigned  short nodata	: 1 ;		/* no data detected */
    unsigned  short illcmd	: 1 ;		/* illegal command */
    unsigned  short eb1		: 1 ;		/* exception byte 1 valid */

    unsigned  short sfterr;		/* blocks re-written / soft errors */
    unsigned  short undrun;		/* number of underruns */
  } status ;				/* read status' data goes here */
  unsigned char stat[6] ;
} ;

/* Magnetic tape, return values from MTTAPE_STATUS ioctl call: */
#define	MTXENIX_TAPE		(MTIO | 32)	/* XENIX formatted tape */
#define	MTNOT_XENIX_TAPE	(MTIO | 33)	/* formatted tape, not */
						/* XENIX format */
#define	MTNO_SERVO		(MTIO | 34)	/* no servo track on tape */
#define	MTNOT_FORMATTED		(MTIO | 35)	/* servo track on tape, */

/* VPIX serial ioctls */

#ifdef VPIX

#define AIOC    ('A'<<8)
#define AIOCINTTYPE     (AIOC|60)        /* set pseudorupt personality */
#define AIOCDOSMODE     (AIOC|61)        /* set DOSMODE */
#define AIOCNONDOSMODE  (AIOC|62)        /* reset DOSMODE */
#define AIOCSERIALOUT   (AIOC|63)        /* serial device data write */
#define AIOCSERIALIN    (AIOC|64)        /* serial device data read */
#define AIOCSETSS       (AIOC|65)        /* set start/stop chars */
#define AIOCINFO        (AIOC|66)        /* tell user what device we are */

/* Ioctl alternate names for use by vpc */

#define VPC_SERIAL_DOS    AIOCDOSMODE
#define VPC_SERIAL_NONDOS AIOCNONDOSMODE
#define VPC_SERIAL_INFO   AIOCINFO
#define VPC_SERIAL_OUT    AIOCSERIALOUT
#define VPC_SERIAL_IN     AIOCSERIALIN

#endif /* VPIX */

/* PC/AT Cga adapter control */
#define	CGAIOC	('C' << 8)	
#define	CGAMODE (CGAIOC | 1)		/* change cga mode */
#define CGAIO	(CGAIOC | 2)		/* do inb/outb on cga port */
#define CGA_GET (CGAIOC | 3)		/* get cga mode setting */

#define CPQVDUMODE0	(CGAIOC|72)	/* compaq Dual mode low res */
#define CPQVDUMODE1	(CGAIOC|73)	/* compaq Dual mode high res */

/* PC/AT Pga adapter control */
#define PGAIOC	('P' << 8)
#define PGAMODE (PGAIOC | 1)		/* change pga mode */
#define PGAIO	(PGAIOC | 2)		/* do inb/outb on pga port */
#define PGA_GET (PGAIOC | 3)		/* get pga mode setting */

/* PC/AT Ega adapter control */
#define EGAIOC	('E' << 8)
#define EGAMODE (EGAIOC | 1)		/* change ega mode */
#define EGAIO	(EGAIOC | 2)		/* do inb/outb on ega port */
#define EGA_GET (EGAIOC | 3)		/* get ega mode setting */
#define EGA_IOPRIVL (EGAIOC | 4)	/* get in/out privilege for ega ports */

/* PC/AT Vga adapter control */
#define VGAIOC	('E' << 8)
#define VGAMODE (VGAIOC | 65)		/* change vga mode */
#define VGAIO	(VGAIOC | 66)		/* do inb/outb on vga port */
#define VGA_GET (VGAIOC | 67)		/* get vga mode setting */
#define VGA_IOPRIVL (VGAIOC | 68)	/* get in/out privilege for vga ports */

/* PC/AT Mca adapter control */
#define MCAIOC	('M' << 8)
#define MCAMODE	(MCAIOC | 1)		/* change mca mode */
#define MCAIO	(MCAIOC | 2)		/* do inb/outb on mca port */
#define MCA_GET (MCAIOC | 3)		/* get mca mode setting */

/* Hercules support */
#define SW_HGC_P0  (MODESWITCH | M_HGC_P0)
#define SW_HGC_P1  (MODESWITCH | M_HGC_P1)

/* Common PC/AT adapter control */

#include "comcrt.h"

/* Defines for console-switching ioctl -- MONO, CGA, PGA, and EGA */
/* definitions are in comcrt.h  				  */	
#define SWAPCONS ('s' << 8)
#define SWAPMONO (SWAPCONS | MONO)
#define SWAPCGA  (SWAPCONS | CGA)
#define SWAPPGA  (SWAPCONS | PGA)
#define SWAPEGA  (SWAPCONS | EGA)
#define SWAPVGA  (SWAPCONS | VGA)

/* defines for mode-switching ioctl -- modes are defined in comcrt.h */
#define MODESWITCH ('S' << 8)
#define SW_B40x25  (MODESWITCH | M_B40x25)
#define SW_C40x25  (MODESWITCH | M_C40x25)
#define SW_B80x25  (MODESWITCH | M_B80x25)
#define SW_C80x25  (MODESWITCH | M_C80x25)
#define SW_BG320   (MODESWITCH | M_BG320)
#define SW_CG320   (MODESWITCH | M_CG320)
#define SW_BG640   (MODESWITCH | M_BG640)
#define SW_EGAMONO80x25 (MODESWITCH | M_EGAMONO80x25)
#define SW_CG320_D    (MODESWITCH | M_CG320_D)
#define SW_CG640_E    (MODESWITCH | M_CG640_E)
#define SW_EGAMONOAPA (MODESWITCH | M_EGAMONOAPA)
#define SW_CG640x350  (MODESWITCH | M_CG640x350)
#define SW_ENH_MONOAPA2 (MODESWITCH | M_ENHMONOAPA2)
#define SW_ENH_CG640  (MODESWITCH | M_ENH_CG640)
#define SW_ENHB40x25  (MODESWITCH | M_ENH_B40x25)
#define SW_ENHC40x25  (MODESWITCH | M_ENH_C40x25)
#define SW_ENHB80x25  (MODESWITCH | M_ENH_B80x25)
#define SW_ENHC80x25  (MODESWITCH | M_ENH_C80x25)
#define SW_ENHB80x43  (MODESWITCH | M_ENH_B80x43)
#define SW_ENHC80x43  (MODESWITCH | M_ENH_C80x43)
#define SW_MCAMODE    (MODESWITCH | M_MCA_MODE)
#define SW_VGA40x25	(MODESWITCH | M_VGA_40x25)
#define SW_VGA80x25	(MODESWITCH | M_VGA_80x25)
#define SW_VGAM80x25	(MODESWITCH | M_VGA_M80x25)
#define SW_VGA11	(MODESWITCH | M_VGA11)
#define SW_VGA12	(MODESWITCH | M_VGA12)
#define SW_VGA13	(MODESWITCH | M_VGA13)

/* defines for display memory mapping ioctl (see consioctl in console.c) */
#define MAPADAPTER ('m' << 8)
#define MAPCONS (MAPADAPTER)  
#define MAPMONO (MAPADAPTER | MONO)
#define MAPCGA  (MAPADAPTER | CGA) 
#define MAPPGA  (MAPADAPTER | PGA)
#define MAPEGA  (MAPADAPTER | EGA)
#define MAPVGA  (MAPADAPTER | VGA)
#define MAPPGA1K  (MAPADAPTER | 0xff)

/* defines for ibm keyboard ioctls (see consioctl in console.c) */
#define FKEYIOC   ('k' << 8)
#define GETFKEY   (FKEYIOC)
#define SETFKEY   (FKEYIOC | 1)
#define TIOCKBON  (TIOC|8)
#define TIOCKBOF  (TIOC|9)
#define KBENABLED (TIOC|10)

#define SW_MCAMODE    (MODESWITCH | M_MCA_MODE)

#ifdef M_I386
#pragma pack(2)
#endif

/* structure used for SETFKEY and GETFKEY ioctls */
struct fkeyarg {	
	unsigned short	keynum;
	char	 	keydef[MAXFK];
	char		flen;			
};

#ifdef M_I386
#pragma pack()
#endif

/* defines for ibm console ioctls */
#define CONSIOC		('c' << 8)
#define CONS_CURRENT 	(CONSIOC|1)
#define CONS_GET	(CONSIOC|2)
#define CONSIO		(CONSIOC|3)

#define PIO_FONT8x8	(CONSIOC|64)
#define GIO_FONT8x8	(CONSIOC|65)
#define PIO_FONT8x14	(CONSIOC|66)
#define GIO_FONT8x14	(CONSIOC|67)
#define PIO_FONT8x16	(CONSIOC|68)
#define GIO_FONT8x16	(CONSIOC|69)

#define CONSADP		(CONSIOC|72)	/* get specific adapter screen */

/* defines for inb/outb ioctls for graphics adapter ports */
#define IN_ON_PORT	1
#define OUT_ON_PORT	0

#ifdef M_I386
#pragma pack(2)
#endif

/* structure used for inb/outb ioctls for graphics adapter ports */
struct port_io_struct {
	char	dir;	/* direction flag (in vs. out) */
	unsigned short port;
	char	data;
};
struct port_io_arg {
	struct port_io_struct args[4];
};	

#ifdef M_I386
#pragma pack()
#endif

/* defines for Adaptec AHA-1540 ioctls */
#define	ADIOC		('a'<<8)
#define	ADFORMAT	(ADIOC|1)	/* format disk			*/
#define	ADBADSEC	(ADIOC|4)	/* set bad sector		*/
#define	ADEXECUTE	(ADIOC|9)	/* execute user cdb		*/

/*
 * Initialize clock constant for 50msec clock interrupts.
 * Magic value to cause proper interrupt interval.
 * Assumes a 1.193181MHz clock input. (1193181 / HZ)
 */

#define CLKNUM 23864

/* 
 * Various defines for 8259 special fully nested support
 */

/* Yes 3 is correct for certain systems running this kernel */
#define NUM_8259	3	/* number of 8259s on this system */

#define MAX8259		9 	/* max number of 8259s possible */
#define MAXLEV		8	/* max interrupt levels on an 8259 */
#define MAXVEC		72	/* max vectors on fully cascaded system */

#define	HAS_REBOOT	/* This system has a software reboot capability */

#define CTLR_16BIT	/* This system has a device controller that cannot */
		   	/* handle transfers across a 64k boundary. */

#define AUTOBOOT		/* This system has autoboot support */
#define	POWERDOWN	2	/* 2nd argument to shutd() */
#define	AUTOFLAG	0xbe11	/* 3rd argument to shutdown() */

/*
 * event driver ioctls
 */
#define	EQIOC		('Q' << 8)
#define	EQIO_GETQP	(EQIOC | 1)
#define	EQIO_SETEMASK	(EQIOC | 2)
#define	EQIO_GETEMASK	(EQIOC | 3)
#define	EQIO_SUSPEND	(EQIOC | 4)
#define	EQIO_RESUME	(EQIOC | 5)
#define	EQIO_BLOCK	(EQIOC | 6)

/* 
 * line discipline specific ioctls to the mouse line discipline 
 */
#define	EVLD_IOC	(LDIOC)
#define	LDEV_SETTYPE	(EVLD_IOC | 13)		/* set mouse type	*/
#define	LDEV_GETEV	(EVLD_IOC | 14)		/* get an event		*/
#define	LDEV_ATTACHQ	(EVLD_IOC | 15)		/* activate mouse	*/
#define	LDEV_SETRATIO	(EVLD_IOC | 16)		/* set a device ratio	*/

struct mouseinfo {       
	unsigned char status;
	char xmotion, ymotion;
};
	
/*
 * ioctls to the busmouse driver
 */
#define MOUSEIOC        ('M'<<8)
#define MOUSEIOCREAD    (MOUSEIOC|60)
#define VPC_MOUSE_READ  MOUSEIOCREAD
#define	MOUSEACQUIRE	(MOUSEIOC|61)

/* Mouse status register definitions */
#define BUT3STAT        1
#define BUT2STAT        2
#define BUT1STAT        4
#define BUT3CHNG        8
#define BUT2CHNG        0x10
#define BUT1CHNG        0x20
#define MOVEMENT        0x40

#endif
