/* @(#)macioctl.h	1.2 90/04/17 */ 

/*
* Ioctl defines for the mac provider.  These comply with the definition from
* Retix and Lachman
*/

#define MACIOC(x)		(('M' << 8) | (x))
#define MACIOC_DIAG		MACIOC(1)	/* set diagnostic mode */
#define MACIOC_UNIT		MACIOC(2)	/* unit select */
#define MACIOC_SETMCA		MACIOC(3)	/* multicast setup */
#define MACIOC_DELMCA		MACIOC(4)	/* multicast delete */
#define MACIOC_DELAMCA		MACIOC(5)	/* flush multicast table */
#define MACIOC_GETMCA		MACIOC(6)	/* get multicast table */
#define MACIOC_GETSTAT		MACIOC(7)	/* dump statistics */
#define MACIOC_GETADDR		MACIOC(8)	/* get mac address */
#define MACIOC_SETADDR		MACIOC(9)	/* set mac address */
