#ident	"@(#)mdc.h	1.8 91/02/13"
/* @(#)mdc.h	1.14 90/06/28 */

/*
 *	5000 MDC/2 driver include file
 *
 *	Copyright 1989 by Altos Computer Systems
 *	All rights reserved.
 *
 * The following section defines the Host Interface structure.  It is
 * identical to the download code file: hostif.h
 */

#define HIFMAGIC	0x0473		/* Magic number for init block */

/*
 * Structure Size Defines
 */
#define MAXCHANS	240	/* No. of supported channels */
#define	NERRS		16	/* Size of channel error array */
#define TSTBUFSIZE	124	/* Size of hifstruct TEST buffer */


/*
 * WARNING: if any of the following definitions are changed, the appropriate
 * routines in the UNIX driver, and in the download code must be updated
 * accordingly.
 */
#define RRINGSIZE	256	/* Receive ring size */
#define TRINGSIZE	256	/* Transmit ring size */
#define CMDQSIZE	256	/* Command queue size */
#define INTQSIZE	256	/* Interrupt queue size */

#pragma pack(1)

/*
 * MDC Channel Parameter Interface
 *
 * Channel Parameter Block
 */
typedef struct parmblk {
	uchar_t parm0;
	uchar_t parm1;
	uchar_t flow;
	uchar_t xoffchar;
	uchar_t xonchar;
	uchar_t rcvsize;
	uchar_t	options;
} parmblk;

/*
 * Parameter Byte 0 for SERIAL ports (parmblk.parm0)
 */
#define NOPARITY	0x00
#define EVENPAR		0x01
#define ODDPAR		0x02
#define MARKPAR		0x03	/* mark parity ( bit 7 high )		*/
#define SPACEPAR	0x04	/* space parity ( bit 7 low )		*/
#define ONESTOP 	0x08	/* 1 stop bits				*/
#define ONEHALF 	0x10	/* 1.5 stop bits			*/
#define TWOSTOP 	0x18	/* 2 stop bits				*/
#define BITS5 		0x00	/* 5 bits/char				*/
#define BITS6 		0x40	/* 6 bits/char				*/
#define BITS7 		0x20	/* 7 bits/char				*/
#define BITS8 		0x60	/* 8 bits/char				*/
#define BREAKON		0x80	/* break on/off				*/

/*
 * Parameter Byte 0 for Parallel ports (parmblk.parm0)
 */
#define AUTOFEED	0x01
#define ERROR		0x02	/* normally set to 0			*/
#define INIT		0x04
#define SELECT		0x08
#define SELECTED	0x10	/* normally set to 0			*/
#define PAPEROUT	0x20	/* normally set to 0			*/
#define PBUSY		0x40	/* normally set to 0			*/
#define ACK		0x80	/* normally set to 0			*/

/*
 * Parameter Byte 1 for SERIAL ports (parmblk.parm1)
 */
#define BAUDBITS	0x1F	/* baud rate goes in bits 0-4 (see below) */
#define WANGFLOW	0x20	/* enable special Wang flow control	*/
#define CTSON		0x40	/* assert CTS				*/
#define DSRON		0x80	/* assert DSR 				*/

/*
 * Baud Rate defines for SERIAL ports (bits 0-4 in parmblk.parm1)
 */
#define	BX0	0x00
#define	BX75	0x01
#define	BX110	0x02
#define	BX134	0x03
#define	BX150	0x04
#define	BX300	0x05
#define	BX600	0x06
#define	BX1200	0x07
#define	BX1800	0x08
#define	BX2000	0x09
#define	BX2400	0x0A
#define	BX3600	0x0B
#define	BX4800	0x0C
#define	BX7200	0x0D
#define	BX9600	0x0E
#define	BX19200	0x0F
#define BX38400 0x10

/*
 * Parameter Byte 1 for Parallel ports (parmblk.parm1)
 */
#define PLL_MODE	0x1F	/* turn on bits 0-4 for parallel port	*/
#define PLL_IN		0x5F	/* enable Centronics parallel input	*/
#define PLL_OUT		0x9F	/* enable Centronics parallel output	*/
#define PLL_BOTH	0xDF	/* enable both parallel input & output	*/

/*
 * Flow Byte for SERIAL ports (parmblk.flow)
 */
#define FLODTR		0x01	/* xmit dtr flow control		*/
#define FLORTS		0x02	/* xmit rts flow control		*/
#define	FLOXSFT		0x04	/* xmit software flw control (xon/xoff)	*/
#define FLODSR		0x08	/* rcv dsr flow control	 		*/
#define FLOCTS		0x10	/* rcv cts flow control 		*/
#define	FLORSFT		0x20	/* rcv software flow control (xon/xoff) */
#define KEEPALIVE	0x40	/* if set secondary will NOT go offline */
				/*	even if not polled for >2 mins 	*/
#define INPUTPREFERRED	0x80	/* Use 'small' buffer for output and    */
				/* 'large' buffer for input (i.e. for   */
				/* hi speed input) */

/*
 * Flow Bytes (parmblk.flow, parmblk.xoffchar, and parmblk.xonchar)
 * have no meaning and are ignored for PARALLEL ports
 */

/*
 * Options byte (options)
 */
#define	OPIXANY		0x80	/* any character restarts */

/*
 * MDC/2 Channel Interface
 *
 * Channel Descriptor Block
 */
typedef struct chanentry {
	uchar_t hc_rhead;	   /* Receive head pointer */
	uchar_t hc_rtail;	   /* Receive tail pointer */
	uchar_t hc_thead;	   /* Transmit head pointer */
	uchar_t hc_ttail;	   /* Transmit tail pointer */
	uchar_t hc_hostbienb;	   /* HOST head/tail buffer interrupt enables */
	uchar_t hc_hostsienb;	   /* HOST status interrupt enables */
	uchar_t hc_iopbienb;	   /* IOP head/tail buffer interrupt enables */
	uchar_t hc_resv1;

	parmblk hc_parmblk;
	uchar_t hc_resv2;

	uchar_t hc_errlog[NERRS];
} chanentry;

/*
 * IOP Buffer Interrupt Enables (chanentry.hc_iopbienb)
 */
#define E_INTTXIOP	0x80	/* interrupt IOP on change of Tx head */
#define M_INTRXIOP	0x7F	/* Rx watermark mask (E_INTRXIOP = ch_bsize) */

/*
 * HOST Buffer Interrupt Enables (chanentry.hc_hostbienb)
 */
#define E_INTRXHOST	0x80	/* interrupt HOST on change of Rx head */
#define M_INTTXHOST	0x7F	/* Tx tail watermark mask */
#define E_INTTXHOST	CLSIZE	/* ASSUMES:  CLSIZE < M_INTTXHOST */

/*
 * HOST Status Interrupt Enables (chanentry.hc_hostsienb)
 *
 * For SERIAL ports (compatible with intentry.intstat1 below):
 */
#define E_INTDTR	CHDTR	 /* interrupt on dtr change */
#define E_INTRTS	CHRTS	 /* interrupt on rts change */
#define E_INTBRK	CHBREAK	 /* interrupt on break */
#define E_INTPAR	CHPARITY /* receive parity error */
#define E_INTORUN	CHOVRRUN /* receiver overrun (data lost) */
#define E_INTFRAME	CHFRAME	 /* framing error */
#define E_INTOFLOW	CHLOST	 /* lost receive chars from buf overflow */
#define E_INTR_ERRS	(E_INTPAR|E_INTORUN|E_INTFRAME|E_INTOFLOW)
#define E_INTSERIAL	(E_INTDTR|E_INTRTS|E_INTR_ERRS)

/*
 * For PARALLEL ports (compatible with parmblk.parm0 above):
 */
#define E_INTAUTOFEED   AUTOFEED /* change in autofeed status */
#define E_INTPLLERROR	ERROR	 /* change in parallel port error status */
#define E_INTINIT       INIT     /* change in INIT status */
#define E_INTSELECT	SELECT	 /* change in select line */
#define E_INTSELECTED	SELECTED /* change in selected status */
#define E_INTPAPEROUT	PAPEROUT /* change in paper out status */
#define E_INTPLLIN	(E_INTAUTOFEED|E_INTINIT|E_INTSELECT)
#define E_INTPLLOUT	(E_INTPAPEROUT|E_INTSELECTED|E_INTPLLERROR)
#define E_INTPLLBOTH	E_INTAUTOFEED

/*
 * Channel Error Log Array Elements (chanentry.hc_errlog)
 *
 * Errors detected by secondary (notifies primary via STAT frame)
 */
#define ERR_PAR		0	/* parity */
#define ERR_OVRUN	1	/* fifo overrun */
#define ERR_FRAME	2	/* framing */
#define ERR_OVFLOW	3	/* buffer overflow */

/*
 * Errors detected by primary
 */
#define	ERR_CARR	4	/* timeout on carrier */
#define ERR_PKTYPE	5	/* unexpected packet type */
#define ERR_CRC		6	/* CRC */
#define ERR_SDLCOVR	7	/* fifo overrun */
#define ERR_TMOUT	8	/* timeout on response */
#define ERR_PKSNT	9	/* FRMR frame */
#define ERR_LENGTH	10	/* packet frame length */
#define ERR_CNT		11	/* (Nr)(Ns) count */
#define ERR_CHAN	12	/* unexpected channel */


/*
 * MDC/2 Command Interface (host to iop)
 *
 * Command Request Queue structure
 */
typedef struct cmdentry {
	uchar_t cmdtype;
	uchar_t	cmdchan;
} cmdentry;

/*
 * Command types (cmdentry.cmdtype)
 */
#define	PWRSHUTSAVE	0x01	/* powerfail shutsave command */

#define RSTRTMAGIC	0xDEAF		/* magic for hifiblk.rstrtflag */

#define	SETMININTMDC	0x03	/* set interrupt interval (in milliseconds) */

#define	MDC_INT_INTVL	20		/* initial interrupt interval value */
#define MAXINTINTERVAL	100		/* max/min values for SETMININTMDC */
#define MININTINTERVAL	10		/* May also be 0 for no interrupts */

#define	SETMINERRMDC	0x04	/* set error report interval (in seconds) */

#define	ERR_INT_INTVL	30		/* initial error interval value */
#define MAXERRINTERVAL	100		/* max/min values for SETMINERRMDC */
#define MINERRINTERVAL	10		/* May also be 0 for no error reports */


#define MINCHANCMD	0x10

#define	OPENMDC		0x10
#define	CLOSEMDC	0x11
#define	PARMMDC		0x12
#define	TXMDC		0x13
#define	ABORTMDC	0x14
#define	XIDMDC		0x17
#define	TESTMDC		0x18	/* Not supported in UNIX driver */
#define	WDRAINMDC	0x19
#define	ABORTWDMDC	0x1A
#define	RXMDC		0x1B

#define MAXCHANCMD	0x1B


/*
 * MDC/2 Interrupt Response Interface (iop to host)
 *
 * Interrupt Response Queue Structure
 */
typedef struct intentry {
	uchar_t	inttype;
	uchar_t	intchan;
	uchar_t intstat0;
	uchar_t intstat1;
} intentry;

/*
 * Interrupt Types (intentry.inttype)
 */
#define RX_INT 		0x01	/* Change in Rx head pointer */
#define TX_INT		0x02	/* Change in Tx tail pointer */
#define	XACK_INT	0x03	/* XIDMDC or TESTMDC complete */
#define OPEN_ACK_INT	0x04	/* OPENMDC complete */

#define INT_ERROR 	0x08	/* Channel Error Report */
#define INT_BDERR 	0x09	/* Board Hardware Error	*/

#define SSTAT_INT	0x0B	/* Serial Status Report */
#define PSTAT_INT	0x0C	/* Parallel Status Report */
#define BAD_LINK_INT	0x0D	/* Bad Link (confused state) */
#define CMD_ACK_INT	0x0E	/* CLOSEMDC or WDRAINMDC complete */
#define PARM_ACK_INT	0x0F	/* PARMMDC complete */

#define INTQ_FULL_INT	0xFF	/* Should never happen */

/*
 * Interrupt Status Byte 0 (intentry.intstat0)
 */
#define	SUCCEEDED	0x08
#define	FAILED		0x00

#define	RESPONDING	0x01
#define	NORESPONSE	0x00

/*
 * Interrupt Status Byte 1 (intentry.intstat1)
 *
 * For SERIAL ports:
 */
#define CHDTR		0x01	/* DTR present (always 1 for 422 lines)	*/
#define CHRTS		0x02	/* RTS present (always 1 for 422 lines)	*/
#define CHBREAK		0x04	/* detect start of break		*/
#define CHPARITY	0x08	/* receive parity error			*/
#define CHOVRRUN	0x10	/* receiver overrun (data lost)		*/
#define CHFRAME		0x20	/* framing error			*/
#define CHLOST		0x40	/* lost receive chars from buf ovflow	*/
#define R_ERRS 		(CHPARITY|CHOVRRUN|CHFRAME|CHLOST)

/*
 * For PARALLEL ports:  identical to parmblk.parm0 above.
 *
 * HIF interrupt queue acknowledgement defines and macros:
 * For sendstat()
 */
#define BAD_STAT	0x01	/* Zero rcvsize STAT/PSTAT frame */
#define IS_PSTAT	0x02	/* Frame is PSTAT */

#define PASS_STAT	0x00	/* Non-zero rcvsize STAT frame */
#define FAIL_STAT	0x01	/* Zero rcvsize STAT frame */
#define PASS_PSTAT	0x02	/* Non-zero rcvsize PSTAT frame */
#define FAIL_PSTAT	0x03	/* Zero rcvsize PSTAT frame */

/*
 * MDC/2 Packet Monitor Interface Structures.
 */
struct	monitor {
	ushort	m_flag;				/* Monitoring level */
	ushort	m_fptr;				/* Pointer to first frame */
	ushort	m_bpage;			/* Monitor buffer address */
	ushort	m_bsize;			/* Monitor buffer size */
	ushort	m_addr;				/* Channel to monitor */
	ushort	m_cntl;				/* Frame type to stop on */
};

/*
 * MDC/2 Resident HOST/IOP Interface Structures
 */
typedef struct hifstruct {
	uchar_t	cmdhead;
	uchar_t cmdtail;
	uchar_t inthead;
	uchar_t inttail;
	uchar_t resvd[4];
	cmdentry cmdq[CMDQSIZE];
	intentry intq[INTQSIZE];
	uchar_t tstbuf[TSTBUFSIZE];
	chanentry hifchan[MAXCHANS];
	struct monitor monitor;
} hifstruct;

/*
 * This structure is shared between the download code, and the host
 * device driver.  As well as some special-purpose applications at the
 * user-level.  Addresses are specified as pages.  To get the "real"
 * address, multiply it by 16, and add it to the virtual base of the
 * shared memory.
 */
typedef struct hifiblk {
	ushort	codeseg;			/* Code segment address */
	ushort	dataseg;			/* Data segment address */
	ushort	version;			/* Download code version */
	ushort	memsize;			/* Memory size (/16) */
	ushort	maxchan;			/* No. of supported channels */
	ushort	hblkpage;			/* Addr of host I/F */
	ushort	rxrbpage;			/* Addr of receive buffers */
	ushort	txrbpage;			/* Addr of transmit buffers */
	ushort	sympage;			/* Addr of debugger symbols */
	ushort	dbgpage;			/* Addr of debugger rings */
	uchar_t	resvd[8];			/* Reserved for future use */
	ushort	rstrtflag;			/* Shut/restart handshake flag*/
	ushort	magic;				/* Download code MAGIC */
} hifiblk;

#pragma pack()

/*
 * There is one mdc_minorinfo structure for each MDC channel.
 */
struct mdc_chaninfo {
	uchar_t		ch_flags;	/* synchronization flags */
	uchar_t		ch_index;	/* mdc minor number - 8 */
	uchar_t		ch_modem;	/* modem control flags */
	uchar_t		ch_sflow;	/* flow control flags  */

	struct tty	*ch_tp;		/* device tty struct */
	chanentry	*ch_hifch;	/* channel struct on IOP */
	uchar_t		*ch_rring;	/* Rx ring buffer on IOP */
	uchar_t		*ch_tring;	/* Tx ring buffer on IOP */
	uchar_t		*ch_cardinfo;	/* mdc board info */

	uchar_t		ch_xid;		/* Id and version # of firmware */
	uchar_t		ch_stat;	/* Channel's last device status */
	uchar_t		ch_errlog[NERRS]; /* Host copy of error log */
	parmblk		ch_parms;	/* parm0/1 flow XOFF XON options */

	uchar_t		opened;		/* tty open flags */

#ifdef	VPIX
	v86_t		*ch_v_stash;	/* ptr to vpix virtual 86 state */
	int		ch_v_intmask;	/* vpix pseudo-interrupt mask */
#endif	/* VPIX */
};

typedef struct mdc_chaninfo mdc_minorinfo;

/*
 * Command synchronization flags (ch_flags)
 */
#define	OPENINPROC	0x01	/* open/close, multiple open interlock */
#define	OPENWAIT	0x02	/* sleeping on interlock */
#define CARRWAIT	0x04	/* sleeping on carrier-detect */
#define	WCMDACK		0x08	/* open/close/drain in progress */
#define PARMINPROC	0x10	/* parm/modem/drain interlock */
#define PARMWAIT	0x20	/* waiting to change parms */
#define	WXIDACK		0x40	/* xid in progress */

/*
 * Modem control flags (ch_modem)
 */
#define	MDC_MDM_MASK	0x30	/* to isolate modem control in ch_modem */
#define	MDC_MDM_SHIFT	4	/* ch_modem >> 4  gives MDM_ON/OFF/USER */

/*
 * Input Preferred bits (ch_sflow)
 */
#define	INPUTPREF	0x40	/* Set(reset) input preferred option */
#define	INPUSER		0x80	/* Inputpreferred follows ch_sflow not CLOCAL */

/*
 * tty open flags (opened)
 */
#define	MDC_NRML	0x01	/* Normal tty open (for terminal/modem) */
#define	MDC_XPR		0x02	/* Transparent printer open (OTYP_LYR) */

/*
 * There is one mdc_majorinfo structure for each MDC card.
 */
struct mdc_cardinfo {
	struct tty *firsttty;   /* pointer to first tty struct */
	struct tty *lasttty;    /* pointer to first tty struct */
	mdc_minorinfo *basechan; /* pointer to chaninfo array */
	paddr_t   shmem;     	/* shared memory base address (kv) */
	ulong	  memsize;	/* length of shared memory */
	hifstruct *mdchif;	/* base of host interface */
	ushort    portbias;	/* base of I/O ports */
	uchar_t   maxchan;	/* number of channels supported by dl code */
	uchar_t   slot;		/* eisa slot this board lives in */
	uchar_t   intcode;	/* int level code */
	uchar_t   intlvl;	/* int level */
	uchar_t   testbusy;	/* exhange test frame in progress */
};  

typedef struct mdc_cardinfo mdc_majorinfo;

/*
 * MDC EISA I/O port macros
 */
#define genmdcint(x)	outb((x)->portbias + P_MDCINTGEN, 0xFF)
#define clrmdcint(x)	outb((x)->portbias + P_MDCINTCLR, 0xFF)
#define disablemdc(x)	outb((x)->portbias + P_MDCWREG0, 0x00)
#define enablemdc(x)	outb((x)->portbias + P_MDCWREG0, \
				(x)->intcode | B_MDCINTENB | B_MDCMEMENB)
#define prodnummdc(x)	inb((x)->portbias + P_EISAPRODN)
#define revnummdc(x)	inb((x)->portbias + P_EISAREVN)
#define iochkerrmdc(x)	(inb((x)->portbias + P_EISACTLBITS) & 0x02)
#define releasemdc(x)	outb((x)->portbias + P_EISACTLBITS, 0x01)
#define resetmdc(x)	outb((x)->portbias + P_MDCWREG0, 0x40); \
			outb((x)->portbias + P_EISACTLBITS, 0x04); \
			inb((x)->portbias + P_MDCINTCLR); \
			outb((x)->portbias + P_MDCINTCLR, 0xFF); \
			inb((x)->portbias + P_MDCRDREG); \
			outb((x)->portbias + P_EISACTLBITS, 0x00); \
			outb((x)->portbias + P_MDCWREG0, 0x00)

#ifndef	TRUE
#define	TRUE	1
#endif
#ifndef	FALSE
#define	FALSE	0
#endif


/*
 * Debugging defines
 */
extern int mdcdebug;
#define XPRMDCDEBUG	0x00000001
#define INTMDCDEBUG	0x00000002
#define CMDMDCDEBUG	0x00000004
#define HUPMDCDEBUG	0x00000008
#define FLSHMDCDEBUG	0x00000010
#define XPR2MDCDEBUG	0x00000020
#define SSMDCDEBUG	0x00000040
