#ident	"@(#)mount.h	1.2	90/08/08"
#ifndef _SYS_MOUNT_H
#define _SYS_MOUNT_H
#ident "@(#) mount.h 22.4 90/01/15 "
#ident "@(#)mount.h	1.2 89/09/29"
#ident "@(#) mount.h 1.6 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 *      Portions Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

/* #ident	"@)#(head.sys:mount.h	1.4" */

#ifndef	_SYS_CI_CILOCK_H
#include <sys/ci/cilock.h>
#endif	/* _SYS_CI_CILOCK_H */

/*
 *	Mount structure.
 *	One allocated on every mount.
 */

#ifndef DIRSIZ				/* REMOTE */
#define DIRSIZ	14
#endif
#define	NMSZ	DIRSIZ + 1		/* size of advertised name */

struct	mount	{
	ushort	m_flags;		/* status */
	short	m_fstyp;		/* file system type */
	long    m_bsize;		/* Block size of this fs */
	dev_t	m_dev;			/* device mounted */
	struct lockb m_cilockfree;	/* MPX lock for the free block list */
	caddr_t	m_bufp;			/* buffer for super block */
	struct inode *m_inodp;		/* pointer to mounted on inode */
	struct inode *m_mount;		/* pointer to mount root inode */
	ushort	m_rflags;		/* set for mount remotely  */
	char	*m_name;		/* name advertised resource */
	long	m_bcount;
} ;

#define lock_fsfree(mp)		(lockb(&(mp)->m_cilockfree))
#define unlock_fsfree(mp, s)	(unlockb(&(mp)->m_cilockfree, s))

/* alloction flags (m_flags) */

#define	MFREE	0x0	/* Unused - free */
#define	MINUSE	0x1	/* In use - fs mounted on this entry */
#define	MINTER	0x2	/* Mount system call is using this entry */
#define	MRDONLY	0x4	/* File system is mounted read only */
#define MHADBAD	0x8	/* File system incurred a bad block */
			/* so set s_state to FsBADBLK on umount */

#define	rdonlyfs(mp)	(((mp)->m_flags & MRDONLY) || (server() \
				&& (srmount[u.u_mntindx].sr_flags & MRDONLY)))

/* remoteness flags (m_rflags) */
/* (or'ed with m_flags in srmount, so must use different bits) */

#define MDOTDOT    0x20
#define MFUMOUNT   0x40
#define MLINKDOWN  0x80
#define MCACHE     0x100	/* mount files are cacheable */

/* Flag bits passed to the mount system call */
#define	MS_RDONLY	0x1	/* read only bit */
#define	MS_FSS		0x2	/* Old (4-argument) mount (compatibility) */
#define	MS_DATA		0x4	/* 6-argument mount */
#define	MS_CACHE	0x8	/* RFS client caching */

#ifdef INKERNEL
extern struct mount mount[];
#endif

/* Server mount structure. Holds:
 *	1. DOT-DOT
 * connections.
 *
 * Search the table looking for (sysid, rootinode) pair.
 */

 struct srmnt {
	sysid_t sr_sysid;
	ushort  sr_flags;
	struct inode *sr_rootinode;	/* inode on server's machine */
	int     sr_mntindx;		/* mount index of requestor  */
	int 	sr_refcnt;		/* number of open files      */
	int	sr_dotdot;		/* for lbin mount, so .. works */
	long	sr_bcount;
	int	sr_slpcnt;
} ;
extern struct srmnt srmount[];

/* Return values if crossing mount point */
 
#define DOT_DOT	0x1
#define MRDONLY	0x4

#endif	/* _SYS_MOUNT_H */
