#ident	"@(#)mvwtoolkit.h	1.2	90/08/08"
#ifndef _SYS_MVWTOOLKIT_H
#define _SYS_MVWTOOLKIT_H
#ident "@(#) mvwtoolkit.h 22.1 90/01/15 "
#ident "@(#)mvwtoolkit.h	1.2 89/09/29"
#ident "@(#) mvwtoolkit.h 1.2 89/07/21 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 */

/*
 *	Copyright (C) JSB Computer Systems Ltd, 1988.
 *
 *	This Module contains Proprietary Information of
 *	JSB Computer Systems Ltd, and should be treated
 *	as Confidential.
 */

#ifndef           MVW_TKINCLD
#define           MVW_TKINCLD                     1
/*
 *
 *                 JSB MultiView Toolkit header file.
 *
 */

#include "sys/werrno.h"

/*--------------------------------------------------------------------*/
/* Here are the ioctl calls                                           */
/*--------------------------------------------------------------------*/
#define      WIOC              ('W' << 8)
#define      WIOCSIGS          (WIOC | 7)
#define      WIOCNOSIGS        (WIOC | 8)
#define      WIOCGETD          (WIOC | 9)
#define      WIOCSETD          (WIOC | 10)
#define      WIOCGTTY          (WIOC | 11)
#define      WIOCMAKE          (WIOC | 12)
#define      WIOCCLOSE         (WIOC | 13)
#define      WIOCPROMOTE       (WIOC | 14)
#define      WIOCDEMOTE        (WIOC | 15)
#define      WIOCERAS          (WIOC | 16)
#define      WIOCSHOW          (WIOC | 17)
#define      WIOCDECLARE       (WIOC | 18)
#define      WIOCSKBD          (WIOC | 19)
#define      WIOCSELECT        (WIOC | 20)
#define      WIOCGETC_A        (WIOC | 21)
#define      WIOCSETC_A        (WIOC | 22)
#define      WIOCPUTC          (WIOC | 23)
#define      WIOCREDRAW        (WIOC | 24)
#define      WIOCKEYS          (WIOC | 25)
#define      WIOCREGCLD        (WIOC | 26)
#define      WIOCTIDY          (WIOC | 27)
#define      WIOCSUSPEND       (WIOC | 28)
#define      WIOCRESUME        (WIOC | 29)
#define      WIOCSCURS         (WIOC | 30)
#define      WIOCRCURS         (WIOC | 31)
#define      WIOCSETMENU       (WIOC | 32)
#define      WIOCDOMENU        (WIOC | 33)
#define      WIOCSTART         (WIOC | 34)
#define      WIOCEND           (WIOC | 35)
#define      WIOCXFRFROM       (WIOC | 36)
#define      WIOCXFRTO         (WIOC | 37)
#define      WIOCTCSIZ         (WIOC | 38)
#define      WIOCTCGET         (WIOC | 39)
#define      WIOCSETCNF        (WIOC | 40)
#define      WIOCGETCNF        (WIOC | 41)
#define      WIOCSIGHOLD       (WIOC | 42)
#define      WIOCSIGRELSE      (WIOC | 43)
#define      WIOCVERSION       (WIOC | 44)

#define      NUMTKREQS  44    /* no. of toolkit requests currently supported  */

/*--------------------------------------------------------------------*/
/* Here are the read flag settings:                                   */
/* These may be examined by the "toolkit" application but not changed */
/*--------------------------------------------------------------------*/
#define      TYPE              1   /* lightweight or heavyweight ?        */
#define      KBDWIN            2   /* keyboard currently assigned ?       */
#define      TOPMOST           4   /* topmost window ?                    */
#define      EXPOSED           8   /* wholly/partially exposed ?          */
#define      XFER_TO          16   /* transfer to in progress ?           */
#define      XFER_FROM        32   /* transfer from in progress ?         */
#define      WIN_CLOSED       64   /* window closed ?                     */
#define      DECLARED        128   /* window declared to user interface ? */


/*--------------------------------------------------------------------*/
/* Here are the read/write flag settings:                             */
/* These may be examined and/or changed by the "toolkit" application. */
/*--------------------------------------------------------------------*/
#define      FIXED             1   /* currently fixed as zoomed/windowed ? */
                                   /* (lightweight specific)               */
#define      ZOOMED            2   /* window currently zoomed ?            */
#define      TRACKED           4   /* cursor tracking currently on ?       */
#define      BLOCKED           8   /* o/p in background blocked ?          */
#define      BORDERS          16   /* window borders visible ?             */
#define      TRANSPARENT      32   /* window see-through ?                 */
#define      COLLAPSE         64   /* window to collapse if process dies   */
                                   /* while in background ?                */
#define      CURSATTACHD     128   /* applies to lightweight windows only  */
                                   /* want cursor attaching to this window?*/
#define      DEGRADE         256   /* allow graceful degradation ?         */


/*--------------------------------------------------------------------*/
/* Here are the attribute bit settings.  i.e. following a WIOCGETA    */
/* call the bits set for each byte in the attribute plane should be   */
/* interpreted using the following definitions.                       */
/*--------------------------------------------------------------------*/
#define         STANDOUT        1
#define         ULINE           2
#define         BOLD            4
#define         BLINK           8
#define         DIM             16
#define         OVERSTRIKE      32
#define         UNUSED_5        64
#define         GRAPHICS        128


/*--------------------------------------------------------------------*/
/* Here are the menu-specifics.                                       */
/*--------------------------------------------------------------------*/
#define         MAX_OPTIONS     22
#define         MAX_OLENGTH     55

/* menu types: */
#define         PULLDOWN        1
#define         POPUP           2
#define         BOTTOM_BAR      3
#define         TOP_BAR         4

/* option types: */
#define         TEXT            1
#define         PROTECTED       2
#define         DIVIDER         3
#define         PUSHUP          4

/* WIOCDOMENU return values on Del, Escape or Help requested when menu
                               is pushed up: */
#define  DEL_KEY                255
#define  ESC_KEY                254
#define  HELP_ON_PUSHUP         253

#ifdef                  FARPTR
typedef struct menu_option
{
    char  far *menu_item;  /* pointer to option text            */
    short item_type;       /* option type identifier            */
    int   item_id;         /* id. to be passed back if selected */
}MENU_OPTION;

typedef struct menu
{
    int         num_options;             /* number of options on menu         */
    char        far *ptext;              /* "Pull-Down" text                  */
    MENU_OPTION far *items[MAX_OPTIONS]; /* each option                       */
    int        werrno;                   /* error code                        */
}MENU;
#else
typedef struct menu_option
{
    char  *menu_item;      /* pointer to option text            */
    short item_type;       /* option type identifier            */
    int   item_id;         /* id. to be passed back if selected */
}MENU_OPTION;

typedef struct menu
{
    int         num_options;             /* number of options on menu         */
    char        *ptext;                  /* "Pull-Down" text                  */
    MENU_OPTION *items[MAX_OPTIONS];     /* each option                       */
    int        werrno;                   /* error code                        */
}MENU;
#endif

typedef struct menu_action
{
    int        start_option;          /* initially hilit option            */
    short      menu_style;            /* style of menu to be actioned      */
    short      menu_borders;          /* menu to have borders ?            */
    short      pop_row;               /* row coordinate of menu (if popup) */
    short      pop_col;               /* col coordinate of menu (if popup) */
    int        werrno;                /* error code                        */
}MENU_ACTION;

/*--------------------------------------------------------------------*/
/* Here are the signal event specifics.                               */
/*--------------------------------------------------------------------*/

/* The bit settings for window state changes on which signalling is required: */
#define     UNUSED             1
#define     DIMENSION          2
#define     LOCATION           4
#define     KBD_ASSIGNMENT     8
#define     XFERRING_TO       16
#define     XFERRING_FROM     32
#define     TRACKING          64
#define     BLOCKING         128
#define     DECLARATION      256  /* specific to a subsitute user interface */

typedef struct wsig
{
    int   sig_type;    /* specifies the signal to be used                     */
    int   sig_event;   /* declares events on which signals required           */
    short sig_pid;     /* specifies process ID to be signalled, if any        */
    short sig_grp;     /* specifies process group to be signalled, if any     */
    int   werrno;      /* error code                                          */
}WSIG;

typedef struct wcld_data
{
    short sig_pid;     /* specifies process ID to be signalled on win closure */
    int   sig_type;    /* specifies the signal to be used                     */
    short update_utmp; /* specifies if utmp file to be updated for this win   */
    int   werrno;      /* error code                                          */
}WCLD_DATA;

#define  REAL_TTY_NAME_SIZE  46
#define  TC_FNAME_SIZE       20
#define  TITLE_SIZE          36
#define  DEVNAM_SIZE         16

/*--------------------------------------------------------------------*/
/* Here are the configuration event specifics.                        */
/*--------------------------------------------------------------------*/
typedef struct wconf
{
    int wait_time;          /* input keystroke timeout period (tenths/sec)    */
    int num_wins;           /* no. of windows on this tty                     */
    int num_pseudo_ttys;    /* no. of pseudo ttys supported across the system */
    int num_real_ttys;      /* no. of real ttys supported across the system   */
    char real_tty_name[REAL_TTY_NAME_SIZE];
                            /* name of real tty on which mview is running   */
    int werrno;             /* error code                                     */
}WCONF;

/*--------------------------------------------------------------------*/
/* Some termcap-specific stuff.                                       */
/*--------------------------------------------------------------------*/

#define   NUMKEYS    32
#define   MAXTCSTRS  (97 + NUMKEYS)
/*
#define   MAXTCSTRS  (100 + NUMKEYS)
*/

typedef struct tcap
{
    char          tc_fname[TC_FNAME_SIZE];
#ifdef                  FARPTR
    char          far *tcp;
#else
    char          *tcp;
#endif
    int           tc_offset[MAXTCSTRS];
    int           co;
    int           li;
    unsigned char XGS;
    int           werrno;           /* error code                            */
}WTCAP;

/*--------------------------------------------------------------------*/
/* Some miscellaneous definitions.                                    */
/*--------------------------------------------------------------------*/
#define      LIGHTWEIGHT    (0)
#define      HEAVYWEIGHT    (1)

#define      CHARPLANE       1
#define      ATTRPLANE       2

#define      MVIEW_ASCII     1
#define      MVIEW_DESKTOP   2

typedef struct wdata
{
    short    s_row;     /* physical row of top left window corner             */
    short    s_col;     /* physical col of top left window corner             */
    short    e_row;     /* physical row of bottom right window corner         */
    short    e_col;     /* physical col of bottom right window corner         */
    short    v_row;     /* physical row position of top left of virtual screen*/
    short    v_col;     /* physical col position of top left of virtual screen*/
    short    c_row;     /* current cursor row position on virtual screen      */
    short    c_col;     /* current cursor col position on virtual screen      */
    int      rw_flags;  /* read/write flag settings                           */
    char     r_flags;   /* read flag settings                                 */
    int      handle;    /* lightweight window handle                          */
    char     title[TITLE_SIZE];
                        /* the window title                                   */
    char     devnam[DEVNAM_SIZE];
                       /* the file system device name of this window         */
    int      werrno;    /* error code                            */
}WDATA;

typedef struct wpage
{
    int      handle;       /* lightweight window handle                      */
    short    start_row;    /* start row for transfer of data                 */
    short    start_col;    /* start column for transfer of data              */
    short    end_row;      /* end row for transfer of data                   */
    short    end_col;      /* end column for transfer of data                */
    char     plane;        /* set according to planes required               */
#ifdef         FARPTR
    char far *charbuf;     /* buffer to transfer character plane transfer to */
    char far *attrbuf;     /* buffer to transfer attribute plane transfer to */
#else
    char     *charbuf;     /* buffer to transfer character plane transfer to */
    char     *attrbuf;     /* buffer to transfer attribute plane transfer to */
#endif
    int      werrno;       /* error code                                     */
}WPAGE;

typedef struct wkeys
{
    int       kstrlen;     /* The total length of the strings 'kstrs'         */
#ifdef         FARPTR
    char far *kstrs;       /* A pointer to a buffer of up to 12 concatenated  */
#else                      /* null-terminated sequences.  The maximum size    */
    char     *kstrs;       /* for this buffer is 128 bytes.                   */
#endif
    short    getkbd;       /* Should be set if automatic keyboard assignment  */
                           /* on receipt of one of the prescribed key         */
                           /* sequences is required.                          */
    int      werrno;       /* error code                                      */
}WKEYS;

typedef struct key_type    /* For configuring e.g. select/terminate keys      */
{
    int    action;         /* Action code for key to be configured            */
    char   character;      /* Character to be configured                      */
}CONFKEY;

typedef struct wputc
{
    int       pstrlen; /* the length of the string pointed to by pstr         */
#ifdef         FARPTR
    char far *pstr;    /* the data to be placed on the input queue            */
#else
    char     *pstr;
#endif
    int      werrno;   /* error code                                          */
}WPUTC;

typedef struct mvwver
{
    int ver_number;    /* product version number                              */
    int ver_type;      /* product version type   (MVIEW_ASCII/MVIEW_DESKTOP)  */
}MVWVER;

#endif

#endif	/* _SYS_MVWTOOLKIT_H */
