#ident	"@(#)ndevbuf.h	1.2	90/08/08"
#ifndef _SYS_NDEVBUF_H
#define _SYS_NDEVBUF_H
#ident	"@(#) ndevbuf.h 22.1 90/01/15 "
#ident "@(#)ndevbuf.h	1.2 89/09/29"
#ident	"@(#) ndevbuf.h 1.3 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

/*
 *	ndevbuf - new device buffer managment routines
 *
 *	These routines provide large core memory buffers for tape drives
 *	and other devices that need huge amounts of memory for buffers.
 *
 */

struct	ndevbuf {
	paddr_t	nd_buf;		/* address of buffer */
	paddr_t	nd_ebuf;	/* address of buffer end + 1*/
	paddr_t	nd_head;	/* where to put data to the buffer */
	paddr_t	nd_tail;	/* where to get data from the buffer */
	long	nd_size;	/* size of buffer */
	long	nd_in;		/* bytes input to buffer */
	long	nd_out;		/* bytes output to buffer */
};

/* how big is the buffer ? */
#define	ndb_size(p)	((p)->nd_size)

/* how much data is in the buffer ? */
#define	ndb_data(p)	((p)->nd_in - (p)->nd_out)

/* how much of the buffer is free ? */
#define	ndb_free(p)	((p)->nd_size - (p)->nd_in + (p)->nd_out)

/* distance from head/tail to end of buffer */
#define	ndb_end(p,ht)	((p)->nd_ebuf - (p)->ht)

/* max length for a contiguous i/o read */
#define	ndb_rmax(p)	( ndb_free(p) <= ndb_end(p,nd_head) ? \
			  ndb_free(p)  : ndb_end(p,nd_head) )

/* max length for a contiguous i/o write */
#define	ndb_wmax(p)	( ndb_data(p) <= ndb_end(p,nd_tail) ? \
			  ndb_data(p)  : ndb_end(p,nd_tail) )

/* address for an i/o read */
#define	ndb_raddr(p)	((p)->nd_head)

/* address for an i/o write */
#define	ndb_waddr(p)	((p)->nd_tail)

/* mark i/o read of length l as done */
#define	ndb_rdone(p,l)					\
if (1) {						\
	(p)->nd_in += (l);				\
	if ( ((p)->nd_head += (l)) >= (p)->nd_ebuf )	\
		(p)->nd_head -= (p)->nd_size;		\
} else							\

/* mark i/o write of length l as done */
#define	ndb_wdone(p,l)					\
if (1) {						\
	(p)->nd_out += (l);				\
	if ( ((p)->nd_tail += (l)) >= (p)->nd_ebuf )	\
		(p)->nd_tail -= (p)->nd_size;		\
} else							\

/* reset state of buffer */
#define	ndb_reset(p)					\
if (1) {						\
	(p)->nd_head = (p)->nd_tail = (p)->nd_buf;	\
	(p)->nd_in = (p)->nd_out = 0;			\
} else


#endif	/* _SYS_NDEVBUF_H */
