/*
 *	@(#) ndp.h 2.3 88/05/18 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984, 1985, 1986, 1987.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 *  NDP Hardware DEFINES
 */

/* 
 * Status word defines
 */
#define	NDPSW_IE	0x0001		/* invalid operation */
#define	NDPSW_DE	0x0002		/* denormalized operand */
#define	NDPSW_ZE	0x0004		/* zero divide */
#define	NDPSW_OE	0x0008		/* overflow */
#define	NDPSW_UE	0x0010		/* underflow */
#define	NDPSW_PE	0x0020		/* precision */
#define	NDPSW_ES	0x0080		/* error summary status */
#define	NDPSW_CC	0x4700		/* NPX condition code mask */
#define	NDPSW_ST	0x1800		/* Stack top pointer mask */
#define	NDPSW_NB	0x8000		/* NEU busy */

#define 	NDPSW_ERR	(NDPSW_PE | NDPSW_UE | NDPSW_OE | NDPSW_ZE \
					| NDPSW_DE | NDPSW_IE)

/*
 * Control Word Defines
 */
#define	NDPCW_IM	0x0001		/* invalid operation */
#define	NDPCW_DM	0x0002		/* denormalized operaand */
#define	NDPCW_ZM	0x0004		/* zero divide */
#define	NDPCW_OM	0x0008		/* overflow */
#define	NDPCW_UM	0x0010		/* underflow */
#define	NDPCW_PM	0x0020		/* precision */
#define	NDPCW_PC	0x0300		/* precision control mask */
#define	NDPCW_RC	0x0C00		/* rounding control mask */
#define	NDPCW_IC	0x1000		/* infinity control 
						0 = projective, 1= affine */

/*
 * Precision control
 */
#define	NDPPC_24	0x0000		/* 24 bit significand */
#define	NDPPC_RES	0x0100		/* reserved */
#define	NDPPC_52	0x0200		/* 52 bit significand */
#define	NDPPC_64	0x0300		/* 64 bit significand */

/*
 * Rounding control
 */
#define	NDPRC_NE	0x0000		/* round to Nearest or Even */
#define	NDPRC_RD	0x0400		/* Round Doun  (toward -infinity) */
#define	NDPRC_RU	0x0800		/* Round Up (toward +infinity) */
#define	NDPRC_CH	0x0C00		/* CHop (truncate toward zero) */

/*
 * NDP software defines for fp_type
 */

#ifdef M_KERNEL

#define	FP_HW	0x01			/* have fp hardware */
#define	FP_287	0x02			/* have 80287 */
#define	FP_387	0x04			/* have 80387 */
#define	FP_NOEX	0x08			/* no emulator for except. handling */
#define	FP_EM	0			/* have fp emulation */
#define	FP_NO	-1			/* have no fp */

#else

#define FP_NO   0       /* no fp chip, no emulator (no fp support)      */
#define FP_SW   1       /* no fp chip, using software emulator          */
#define FP_HW   2       /* chip present bit                             */
#define FP_287  2       /* 80287 chip present                           */
#define FP_387  3       /* 80387 chip present                           */

#endif

/*
 * defines for emulator
 */

#define EMUL_START	0x15		/* address for emulation */
#define EMUL_EXCEPT	0x1A		/* address for exception handling */

#ifdef M_I386
/*
 * externals used for fpu support
 */

extern struct proc *fp_task;
extern int fp_type;
#endif
