/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* @(#)route.h	3.2 LAI System V.3 STREAMS TCP/IP  source        */
/* Convergent Technologies - System V - Oct 1985	 */
#ifndef route_h
#define route_h
#ident	"@(#)route.h	6.9 :/source/uts/common/net/s.route.h 1/27/87 14:48:27"

/* route.h	6.1	83/07/29	 */

/*
 * Kernel resident routing tables. 
 *
 * The routing tables are initialized when interface addresses are set by making
 * entries for all directly connected interfaces. 
 */

/*
 * A route consists of a destination address and a reference to a routing
 * entry.  These are often held by protocols in their control blocks, e.g.
 * inpcb. 
 */
struct route {
	mblk_t         *ro_rt;	/* Contains an rtentry */
	struct in_addr  ro_dst;
};

/*
 * We distinguish between routes to hosts and routes to networks, preferring
 * the former if available.  For each route we infer the interface to use
 * from the gateway address supplied when the route was entered.  Routes that
 * forward packets through gateways are marked so that the output routines
 * know to address the gateway rather than the ultimate destination. 
 */
struct rtentry {
	u_long          rt_hash;/* to speed lookups */
	struct in_addr  rt_dst;	/* key */
	struct in_addr  rt_gateway;	/* value */
	short           rt_flags;	/* up/down?, host/net */
	short           rt_refcnt;	/* # held references */
	u_long          rt_use;	/* raw # packets forwarded */
	struct ip_provider *rt_prov;	/* the answer: provider to use */
};

#define	RTF_UP		0x1	/* route useable */
#define	RTF_GATEWAY	0x2	/* destination is a gateway */
#define	RTF_HOST	0x4	/* host entry (net otherwise) */
#define RTF_SWITCHED	0x8	/* this route must be switched */
#define	RTF_DYNAMIC	0x10	/* created dynamically (by redirect) */
#define RTF_SLAVE	0x20	/* slave switched route */
#define RTF_REMOTE	0x40	/* route used for forwarded packets */
#define RTF_TOSWITCH	0x80	/* gateway is switched route */
#define RTF_MODIFIED	0x100	/* modified dynamically by redirect (0x20/UCB)*/

#define RTF_SSSTATE	0x700	/* switched SLIP state */
#define SSS_NOCONN	0x000	/* unconnected */
#define SSS_DIALING	0x100	/* switch in progress */
#define SSS_OPENWAIT	0x200	/* short delay */
#define SSS_INUSE	0x300	/* in use locally */
#define SSS_CLEARWAIT	0x400	/* delayed hangup */
#define SSS_CALLFAIL	0x500	/* call failed recently */

#define RTF_USERMASK	(RTF_GATEWAY|RTF_HOST|RTF_SWITCHED)
/* flags settable by user */
#define SSS_GETSTATE(rt) ((rt)->rt_flags & RTF_SSSTATE)
#define SSS_SETSTATE(rt, new) \
	(rt)->rt_flags = (((rt)->rt_flags & ~RTF_SSSTATE) | new)

/* flags passed to rtalloc */
#define SSF_SWITCH	0x001	/* do SLIP switching if needed */
#define SSF_REMOTE	0x002	/* rtalloc on behalf of remote system */
#define SSF_TOSWITCH	0x004	/* recursive call */

/* returns from rtalloc */
#define RT_OK	 0		/* normal route */
#define RT_DEFER 1		/* defer for SLIP dialing */
#define RT_SWITCHED 2		/* route is switched: to prevent caching */
#define RT_FAIL  3		/* for completeness; unused */


/*
 * Routing statistics. 
 */
struct rtstat {
	short           rts_badredirect;	/* bogus redirect calls */
	short           rts_dynamic;	/* routes created by redirects */
	short           rts_newgateway;	/* routes modified by redirects */
	short           rts_unreach;	/* lookups which failed */
	short           rts_wildcard;	/* lookups satisfied by a wildcard */
};

#ifdef INKERNEL
#define RT(x) ((struct rtentry *) (x)->b_rptr)

#define	RTFREE(rt) \
	if (RT(rt)->rt_refcnt == 1) \
		rtfree(rt); \
	else \
		RT(rt)->rt_refcnt--;

#define	RTHASHSIZ	64
#if	(RTHASHSIZ & (RTHASHSIZ - 1)) == 0
#define RTHASHMOD(h)	((h) & (RTHASHSIZ - 1))
#else
#define RTHASHMOD(h)	((h) % RTHASHSIZ)
#endif
extern mblk_t  *rthost[];
extern mblk_t  *rtnet[];
extern struct rtstat rtstat;
#endif
#endif				/* route_h */
