/*      @(#)socketvar.h	3.5 LAI System V.3 STREAMS TCP/IP  source        */
/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef socketvar_h
#define socketvar_h
#ident	"@(#)socketvar.h	6.8 :/source/uts/common/net/s.socketvar.h 1/7/87 19:33:40"

/* socketvar.h	6.1	83/07/29	 */

/*
 * Kernel structure per socket. 
 */
struct socket {
	short           so_type;/* generic type, see socket.h */
	short           so_options;	/* from socket call, see socket.h */
	short           so_linger;	/* time to linger while closing */
	short           so_state;	/* internal state flags SS_*, below */
	struct protosw so_proto;	/* protocol handle */
	/*
	 * Variables for connection queueing. Socket where accepts occur is
	 * so_head in all subsidiary sockets. If so_head is 0, socket is not
	 * related to an accept. If a connection is aborted and it has
	 * so_head set, then it has to be pulled out of either so_q. We allow
	 * connections to queue up based on current queue lengths and limit
	 * on number of queued connections for this socket. 
	 */
	struct socket  *so_head;/* back pointer to accept socket */
	struct socket  *so_q;	/* queue of incoming connections */
	short           so_qlen;/* number of connections on so_q */
	short           so_qlimit;	/* max number queued connections */
	short           so_timeo;	/* connection timeout */
	u_short         so_error;	/* error affecting connection */
	u_short         so_oobmark;	/* chars to oob mark */
	short           so_pgrp;/* pgrp for signals */
	struct sockaddr so_name;/* local address */
	struct sockaddr so_peer;/* peer address */
	struct stdata  *so_stp;	/* obsoletes so_strq rd q ptr. */
	mblk_t         *so_oobqhead;	/* pending out of band data */
	mblk_t         *so_oobqtail;	/* tail of the queue */
	mblk_t         *so_iocack;	/* upstream ioctl ack/nak */
	int		so_addrlen;	/* address length of tp */
	long		so_flags;	/* flags */
	struct proc    *so_rsel;	/* process waiting for read */
	struct proc    *so_wsel;	/* process waiting for write */
#if defined(M_XENIX)
	struct proc    *so_esel;	/* process waiting for exception */
#endif
};

/*
 * Socket state bits. 
 */
#define	SS_NOFDREF		0x001	/* no file table ref any more */
#define	SS_ISCONNECTED		0x002	/* socket connected to a peer */
#define	SS_ISCONNECTING		0x004	/* in process of connecting to peer */
#define	SS_ISDISCONNECTING	0x008	/* in process of disconnecting */
#define	SS_CANTSENDMORE		0x010	/* can't send more data to peer */
#define	SS_CANTRCVMORE		0x020	/* can't receive more data from peer */
#define	SS_RCVATMARK		0x040	/* at mark on input */

#define	SS_PRIV			0x080	/* privileged for broadcast, raw... */
#define	SS_NBIO			0x100	/* non-blocking ops */
#define	SS_ASYNC		0x200	/* async i/o notify */
#define SS_IOCWAIT		0x400	/* ioctl already downstream */
#define SS_READWAIT		0x800	/* send a wakeup on read */
#define SS_WRITEWAIT		0x1000	/* send a wakeup on write enab */
#define SS_BOUND		0x2000	/* socket has been bound */

#define SF_RLOCK		0x0001	/* receiver is locked */
#define SF_WLOCK                0x0002  /* sender is locked */
#define SF_LOCKWAIT             0x0004  /* someone is waiting to lock */
#define SF_RCOLL                0x0008  /* collision selecting (read) */
#define SF_WCOLL                0x0010  /* collision selecting (write) */
#if defined(SELECT)
#define	SF_ECOLL		0x0020	/* collision selecting (exceptions) */
#endif


/*
 * Macros for sockets and socket buffering. 
 */

/* do we have to send all at once on a socket? */
#define	sosendallatonce(so) \
    ((so)->so_proto->pr_flags & PR_ATOMIC)

/* can we read something from so? */
#define	soreadable(so) \
    (RD((so)->so_stp->sd_wrq)->q_first || ((so)->so_state & SS_CANTRCVMORE) || \
	(so)->so_qlen || (so)->so_error)

/* can we write something to so? */
#define	sowriteable(so) \
    (canput((so)->so_stp->sd_wrq) && \
	(((so)->so_state&SS_ISCONNECTED) || \
	  ((so)->so_proto.pr_flags&PR_CONNREQUIRED)==0) || \
     ((so)->so_state & SS_CANTSENDMORE) || \
     (so)->so_error)

#define	sorwakeup(so) sowakeup((so), RD((so)->so_stp->sd_wrq));
#define	sowwakeup(so) sowakeup((so), (so)->so_stp->sd_wrq);

extern int      sockdev;
#define MINORS_PER_MAJOR	256
#define devtosock(dev)	\
	((major(dev) - major(makedev(sockdev,0)))*MINORS_PER_MAJOR + minor(dev))
#define SOCK_RESERVE	((struct socket *)-1)

#define SOCKM_ID	207	/* Module ID for SOCKET stream head */

#ifdef INKERNEL
struct socket  *sonewconn();
mblk_t         *allocmsg();
extern struct socket *socktab[];
#endif
#endif				/* socketvar_h */
