/*      @(#)strioc.h	3.1 LAI System V.3 STREAMS TCP/IP  source        */
/*
 *	System V STREAMS TCP - Release 3.0
 *
 *	Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI)
 *	All Rights Reserved.
 *
 *	The copyright above and this notice must be preserved in all
 *	copies of this source code.  The copyright above does not
 *	evidence any actual or intended publication of this source
 *	code.
 *
 *	This is unpublished proprietary trade secret source code of
 *	Lachman Associates.  This source code may not be copied,
 *	disclosed, distributed, demonstrated or licensed except as
 *	expressly authorized by Lachman Associates.
 *
 *	System V STREAMS TCP was jointly developed by Lachman
 *	Associates and Convergent Technologies.
 */
struct iocqp {
	unsigned short iqp_type;
	unsigned short iqp_value;
};

/* Queue types */
#define IQP_RQ		0		/* standard read queue */
#define IQP_WQ		1		/* standard write queue */
#define IQP_HDRQ	2		/* stream head read queue */
#define IQP_MUXRQ	3		/* multiplexor read queue */
#define IQP_MUXWQ	4		/* multiplexor write queue */
#define IQP_NQTYPES	5

#define MODL_INFO_SZ          2
#define DRVR_INFO_SZ          3
#define MUXDRVR_INFO_SZ       5

/* Queue parameter (value) types */
#define IQP_LOWAT	0x10		/* Low water mark */
#define IQP_HIWAT	0x20		/* High water mark */
#define IQP_NVTYPES     2

/* Masks */
#define IQP_QTYPMASK	0x0f
#define IQP_VTYPMASK	0xf0

/* Ioctl */
#define INITQPARMS      ('Q'<<8|0x01)

#ifdef INKERNEL
extern int initqparms();
#endif
