/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* @(#)if_sl.h	3.1 LAI System V.3 STREAMS TCP/IP  source        */
/* Convergent Technologies - System V - Sep 1986	 */
#ifndef if_sl__h
#define if_sl__h
#ident	"@(#)if_sl.h	1.1 :/source/uts/common/netinet/s.if_sl.h 9/29/86 17:01:52"




/*
 * N.B.: SLMTU is now a hard limit on input packet size. SLMTU must be <=
 * CLBYTES - sizeof(struct ifnet *). 
 */
#define	SLMTU	1006
#define	SLIP_HIWAT	1000	/* don't start a new packet if HIWAT on queue */
#define	CLISTRESERVE	1000	/* Can't let clists get too low */

struct sl_softc {
	struct ifnet    sc_if;	/* network-visible interface */
	short           sc_flags;	/* see below */
	short           sc_ilen;/* length of input-packet-so-far */
	struct tty     *sc_ttyp;/* pointer to tty structure */
	int             sc_len;	/* length of buffer remaining */
	struct mbuf    *sc_m;	/* head of mbuf chain */
	struct mbuf    *sc_mt;	/* tail of mbuf chain */
	unsigned char  *sc_mp;	/* pointer to next available buf char */
	ushort          sc_cflag;	/* tty control flags */
	dev_t           sc_dev;	/* physical device */
};

#define t_scunit t_lflag	/* store unit number in tp lflag */
#endif				/* if_sl__h */
