/*      @(#)ip_str.h	3.3 LAI System V.3 STREAMS TCP/IP  source        */
/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
#ifndef ip_str_h
#define ip_str_h
#ident	"@(#)ip_str.h	6.8 :/source/uts/common/netinet/s.ip_str.h 7/10/87 21:15:29"


/*
 * Definitions for stream driver control of the Internet Protocol. This
 * module defines the structures related to controlling the streams interface
 * itself, the structures related to various other protocol elements are in
 * other files. 
 */

#define NIP		8	/* Number of minor devices supported */
#define IP_PROVIDERS	16	/* Max Number of link level service providers */
#define IP_SAP		0x800	/* SAP for IP protocol - currently enet type */
#define ARP_SAP		0x806	/* SAP for ARP */

struct ip_pcb {
	queue_t        *ip_rdq;	/* Upper read queue for this client */
	ushort          ip_proto;	/* Client protocol number set with
					 * N_BIND */
	ushort          ip_state;	/* State flags for this client, see
					 * below */
};

#define IPOPEN	1		/* Minor device open when set */

struct ip_provider {		/* The description of each link service */
	char            name[IFNAMSIZ];	/* provider name (e.g., en0) */
	queue_t        *qbot;	/* lower write queue */
	int             l_index;/* unique ID of lower stream */
	short           if_flags;	/* up/down, broadcast, etc. */
	int             if_metric;	/* routing metric (external only) */
	int             if_maxtu;	/* maximum transmission unit */
	int             if_mintu;	/* minimum transmission unit */

	/*
	 * The following stuff is used for interfaces that can't handle
	 * back-to-back packets combined with systems that don't send
	 * packets as big as the MSS.  These values are actually used
	 * by TCP, but are kept here since they are set by IFCONFIG.
	 */
	int		if_spsize;	/* short packet size to watch for */
	int		if_spthresh;	/* short packet threshold */

	struct in_ifaddr ia;	/* address chain structure maintained by if */

#define SOCK_INADDR(sock) (&(((struct sockaddr_in *)(sock))->sin_addr))
#define PROV_INADDR(prov) SOCK_INADDR(&((prov)->ia.ia_ifa.ifa_addr))

	/* The following defines are vestiges of */
	/* the socket based ip implementation */
#define if_addr		ia.ia_ifa.ifa_addr	/* interface address */
#define	if_broadaddr	ia.ia_broadaddr	/* broadcast address */
#define	if_dstaddr	ia.ia_dstaddr	/* other end of p-to-p link */

	mblk_t         *unswitch;	/* ioctl pointer for switched routes */
};

/*
 * A special version of the unitdata request to be sent down through ip -> it
 * contains various ip specific extensions to the base structure 
 */

struct ip_unitdata_req {
	long            PRIM_type;	/* always N_UNITDATA_REQ */
	long            RA_length;	/* dest NSAP addr length - 4 for ip */
	long            RA_offset;	/* dest NSAP addr offset */
	long            SERV_class;	/* service class */
	long            FILLER_field;	/* 802.2 LLC2 field */
	mblk_t         *options;/* options for ip */
	struct route    route;	/* route for packet to follow */
	int             flags;
	struct in_addr  ip_addr;/* the ip destination addr */
};


/*
 * ip_ctlmsg is the structure used to send control messages to the client
 * upper level protocols.  These messages are actually generated by icmp and
 * are passed down to ip to distribute among the clients. 
 */

struct ip_ctlmsg {
	int             command;
	struct in_addr  ctl_addr;
	int             proto;
};

#endif				/* ip_str_h */
