/* @(#)tcp_seq.h	3.3 LAI System V.3 STREAMS TCP/IP  source        */
/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Convergent Technologies - System V - Oct 1985	 */
#ifndef tcp_seq_h
#define tcp_seq_h
#ident	"@(#)tcp_seq.h	6.4 :/source/uts/common/netinet/s.tcp_seq.h 7/13/86 04:36:34"

/* tcp_seq.h	6.1	83/07/29	 */

/*
 * TCP sequence numbers are 32 bit integers operated on with modular
 * arithmetic.  These macros can be used to compare such integers. 
 */
#ifdef vax
#define	SEQ_LT(a,b)	((int)((a)-(b)) < 0)
#define	SEQ_LEQ(a,b)	((int)((a)-(b)) <= 0)
#define	SEQ_GT(a,b)	((int)((a)-(b)) > 0)
#define	SEQ_GEQ(a,b)	((int)((a)-(b)) >= 0)
#else
#define	SEQ_LT(a,b)	(((a)-(b))&0x80000000)
#define	SEQ_LEQ(a,b)	(!SEQ_GT(a,b))
#define	SEQ_GT(a,b)	SEQ_LT(b,a)
#define	SEQ_GEQ(a,b)	(!SEQ_LT(a,b))
#endif

/*
 * Macros to initialize tcp sequence numbers for send and receive from
 * initial send and receive sequence numbers. 
 */
#define	tcp_rcvseqinit(tp) \
	(tp)->rcv_adv = (tp)->rcv_nxt = (tp)->irs + 1

#define	tcp_sendseqinit(tp) \
	(tp)->snd_una = (tp)->snd_nxt = (tp)->snd_max = (tp)->snd_up = \
	    (tp)->iss

#define	TCP_ISSINCR	128	/* increment for tcp_iss each second */

#ifdef INKERNEL
extern tcp_seq         tcp_iss;	/* tcp initial send seq # */
#endif
#endif				/* tcp_seq_h */
