#ident	"@(#)omti.h	1.2	90/08/08"
#ifndef _SYS_OMTI_H
#define _SYS_OMTI_H
#ident	"@(#) omti.h 22.1 90/01/15 "
#ident "@(#)omti.h	1.2 89/09/29"
#ident	"@(#) omti.h 1.3 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1987, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

#if SCO_VAL_ADDED		/* @SCO_VAL_ADDED@ */
/*
 * The source conditionally included on SCO_VAL_ADDED is owned by
 * The Santa Cruz Operation Inc., and represents SCO value added
 * portions of source code requiring special arrangements with
 * SCO for inclusion in any product.
 */
#endif				/* @SCO_VAL_ADDED@ */


#ifdef SCO_VAL_ADDED		/* @SCO_VAL_ADDED@ */

#define TRUE               1
#define FALSE              0

#define DONE               0     
#define FINISH_REQ	   1

#define IN                 0
#define OUT                1

extern unsigned long dma_resid();
extern dma_alloc();
extern dma_relse();
extern dma_param();
extern dma_enable();

#define NHDTYPES        14     /* number of defined hard disk types */
#define HDNPRES          0     /* type to indicate drive not present */

#define DKSMASK          0x01FF     /* sector boundary mask */

#define OMTI_DRIVES     2     /* max of two drives */

/* convert bytes and sectors */

#define bytes_to_sectors(X)          ((X) >> (BSHIFT - 1))
#define sectors_to_bytes(X)          ((X) << (BSHIFT - 1))

typedef unsigned int	track_t;          /* track number */
typedef unsigned int	phy_sector_t;     /* physical sector address(cyl rel) */
typedef daddr_t		log_sector_t;     /* logical sector (drive rel) */

/*  862x controller command equates */

#define OMTI_TEST_DRIVE_READY		0x00
#define OMTI_RECALIBRATE		0x01
#define OMTI_SENSE			0x03
#define OMTI_FORMAT_DRIVE		0x04
#define OMTI_READ_VERIFY		0x05
#define OMTI_FORMAT_TRACK		0x06
#define OMTI_FORMAT_BAD_TRACK		0x07
#define OMTI_READ			0x08
#define OMTI_WRITE			0x0A
#define OMTI_SEEK			0x0b
#define INIT_DRV			0x0C
#define READ_FROM_BUFF			0x0E
#define WRITE_TO_BUFF			0x0F
#define OMTI_MOTOR_OP 			0x1A
#define READ_TO_BUFF			0x1E
#define WRITE_FROM_BUFF			0x1F
#define OMTI_READ_DEFECT_LIST		0x37
#define READ_CONFIG			0xEC
#define OMTI_DRIVE_DIAGNOSTIC		0xE3
#define OMTI_CONTROLLER_DIAGNOSTIC	0xE4

/* psuedo commands */
#define OMTI_START			0xF1
#define OMTI_STOP			0xF2
#define OMTI_RESET			0xF3
#define OMTI_QUERY			0xF4
#define OMTI_TEST			0xF5
#define OMTI_XDEBUG			0xF6

#define	OMTI_DRIVE_ERRORS		0
#define OMTI_DATA_ERRORS		1
#define OMTI_COMMAND_ERRORS		2
#define OMTI_DIAGNOSTIC_ERRORS		3

/* 862x status register equates */

#define OMTI_REQ          (1<<0)
#define OMTI_TO_HOST      (1<<1)
#define OMTI_C_D          (1<<2)
#define OMTI_BUSY         (1<<3)
#define OMTI_DMA_REQ      (1<<4)
#define OMTI_INTR_REQ     (1<<5)

#define OMTI_DMA_ENABLE   (1<<0)
#define OMTI_INTR_ENABLE  (1<<1)

#define CMD_ERROR         (1<<1)

/* 
 * omti controller registers(set to factory default values).
 */

#define OMTI_DATA_P      0x320     /* 8 or 16 bit data port		 */
#define OMTI_STATUS_P    0x321     /* bit significant status information */
#define OMTI_RESET_P     0x321     /* writing to causes a reset 	 */
#define OMTI_CFG_P    	 0x322     /* value of the configuration jumpers */
#define OMTI_SELECT_P    0x322     /* writing to starts a 'select' seq	 */
#define OMTI_MASK_P      0x323     /* enable/disable interrupts and dma  */

#define OMTI_DMACHAN	7	   /* omti dma channel */

#define UNDEFINED	0
#define OMTI_BIOS	1
#define NON_OMTI	2

/* 
 * per drive flags
 */

#define DK_OPEN          1     /* this drive has been opened */
#define DK_DISKNO        2     /* this drive has been allocated a dk diskno */


#define OMTI_DMA          1
#define OMTI_PIO_SLOW     2
#define OMTI_PIO_FAST     3


#define OMTI_CONTR_BUFF_SIZE 15         /* 8k controller buffer - 15 secs max */

/*  
 * omti configuration port bit defines 
 */

#define		OMTI_ST412	0     /* drive is type ST412 */
#define		OMTI_ESDI	1     /* drive is type ESDI */

/* 
 * bits 5&6 of LUN FLAG byte after read buffer are drive type bits - 
 *			bit 5 is on if ESDI 
 */

#define DRV_TYPE_BIT    0x20    

/* 
 * some of these bytes are overloaded, but for efficiency's sake we
 * ignore that, and let the low level routines handle the packing.
 */

typedef struct omti_cdb {
	int op;
	int lun;
	int head;
	int sec;
	int cyl;
	int count;
	int control;
} OMTI_CDB;


typedef struct omti_packed_cdb {
	unsigned char	op;
	unsigned char	c10_lun_hd;
	unsigned char	c9_c8_sec;
	unsigned char	cyl_low;
	unsigned char	cnt;
	unsigned char	ctrl;
} OMTI_PKD_CDB;


typedef struct {          /* bit fields are allocated right to left */
	unsigned code : 4;
	unsigned type : 2;
	unsigned extra1 : 1;
	unsigned address_valid : 1;

	unsigned head   : 5;
	unsigned lun    : 1;
	unsigned extra2 : 1;
	unsigned c10    : 1;

	unsigned sector : 6;
	unsigned c9_c8  : 2;

	unsigned cylinder : 8;
} SENSE_DATA;

typedef struct {
	unsigned char msb_cylinders;
	unsigned char lsb_cylinders;
	unsigned char max_heads;
	unsigned char msb_srwcc;
	unsigned char lsb_srwcc;
	unsigned char msb_swpc;
	unsigned char lsb_swpc;
	unsigned char filler;
} OMTI_DRIVE_PARAM;

#endif				/* @SCO_VAL_ADDED@ */

#endif	/* _SYS_OMTI_H */
