#ident	"@(#)paccess.h	1.2	90/08/08"
#ifndef _SYS_PACCESS_H
#define _SYS_PACCESS_H
#ident "@(#) paccess.h 22.1 90/01/15 "
#ident "@(#)paccess.h	1.2 89/09/29"
#ident "@(#) paccess.h 1.3 89/07/27 "
/* 
 *      Copyright (C) The Santa Cruz Operation, 1985, 1986, 1987, 1988, 1989.
 *      This Module contains Proprietary Information of the Santa
 *      Cruz Operation, and should be treated as confidential. 
 *
 */

/* paccess() command codes */

#define P_RDUSER 	128
#define P_WDUSER 	129
#define P_RIUSER	130
#define P_WIUSER	131
#define P_RUREGS	132
#define P_WUREGS	133
#define P_RUFREGS	134
#define P_WUFREGS	135
#define P_RULDT		136
#define P_RUOFFS	137
#define P_RUDREGS	138
#define P_WUDREGS	139
#define P_RDSIZE	140

#define P_MINCMD	128
#define P_MAXCMD	140

#define P_VERSION	1

typedef long uoff;

/* UNIX 3.2 uarea offsets  */

struct uoffsets {
	uoff u_info;	 	/* version */ 
	uoff u_uaddr;	 	/* kernel virtual address of uarea  */
	uoff u_ar0;	 	/* user register save area pointer */
	uoff u_fps;  		/* floating point save area  */
	uoff u_fpemul;   	/* separate emulator save area  */
	uoff u_fpvalid;  	/* if floating point save is valid */
	uoff u_weitek;   	/* per proc weitek flag */
	uoff u_weitek_reg;  	/* weitek save area  */
	uoff u_debugreg; 	/* debug register save area  */
	uoff u_ldt;	 	/* offset of ldt  */
	uoff u_ldtlimit; 	/* size of ldt  */
	uoff u_tss;	  	/* 3.2 adb  */
	uoff u_sztss;	  	/* 3.2 adb  */
	uoff u_sigreturn; 	/* user signal return */ 
	uoff u_signal;
	uoff u_sdata;		/* u_exdata.ux_datorg */
	uoff u_dsize;		/* data size */
	uoff u_ssize;	 	/* stack size */
	uoff u_tsize;	 	/* text size  */
	uoff u_sub;	 	/* stack upper  bound */ 
	uoff uvstack;		/* virtual address of stack top */
	uoff uvtext;		/* virtual address of text */
};


#define MAXIPCDATA 132


/* offset information structure at offset 0 in core file */
struct coreoffsets {
	uoff u_info;	 	/* interface version */ 
	uoff u_user;		/* offset of upage in core file */
	uoff u_ldt;	 	/* offset of ldt in core file  */
	uoff u_data;	 	/* offset of data in core file */
	uoff u_stack; 	 	/* offset of stack in core file */
	uoff u_usize;		/* size of uarea */
	uoff u_uaddr;	 	/* kernel virtual address of uarea  */
	uoff u_ar0;	 	/* user register save area pointer */
	uoff u_fps;      	/* floating point save area  */
	uoff u_fper;		/* 2.3 field */
	uoff u_fpemul;   	/* separate emulator save area  */   
	uoff u_fpvalid;	 	/* valid save fpstate */ 
	uoff u_weitek;		/* flag indicating weitek usage */
	uoff u_weitek_reg;	/* weitek save area */
	uoff u_ssize;	 	/* stack size */
	uoff u_dsize;    	/* data size  */
	uoff u_tsize;	 	/* text size  */
	uoff u_comm;	 	/* name of executable */ 
	uoff u_ldtlimit; 	/* size of ldt   */
	uoff u_sub;	 	/* stack upper  bound */ 
	uoff u_sdata;	 	/* 3.2 u_exdata.ux_datorg  */
	uoff u_mag;	 	/* u_exdata.ux_mag  */
	uoff u_sigreturn;	
	uoff u_signal;
	uoff uvstack;		/* virtual address of stack top */
	uoff uvtext;		/* virtual address of text */
	uoff size;		/* size of this structure; 
				   WARNING: this must remain as the last
				   field; all additions must go above */
};

/*
 *	Template for accessing i386 debug registers via P_RUGREGS and
 *	P_WUDREGS
 */

struct debugregs {
	char *d_dr0;	/* breakpoint 0, virtual address */
	char *d_dr1;	/* breakpoint 1, virtual address */
	char *d_dr2;	/* breakpoint 2, virtual address */
	char *d_dr3;	/* breakpoint 3, virtual address */
	int d_res1;		/* reserved; undefined */
	int d_res2;
	unsigned int d_status;  /* status after breakpoint trap */
	unsigned int d_l0:2;	/* local enable */
	unsigned int d_l1:2;
	unsigned int d_l2:2;
	unsigned int d_l3:2;
	unsigned int d_le:2;	/* local "slowdown" */
	unsigned int res3:6;
	unsigned int d_rw0:2;	/* breakpoint type */
	unsigned int d_len0:2;	/* data size; 0 for text */
	unsigned int d_rw1:2;
	unsigned int d_len1:2;
	unsigned int d_rw2:2;
	unsigned int d_len2:2;
	unsigned int d_rw3:2;
	unsigned int d_len3:2;
};


/* Kernel data structure template shared by ptrace() and paccess() */

struct ipcbuf {
	int	ip_lock;
	int	ip_req;
	int	*ip_addr;
	int	ip_data;
};

#endif	/* _SYS_PACCESS_H */
