/*      @(#)socket.h	3.6 LAI System V.3 STREAMS TCP/IP  source        */
/*
 * System V STREAMS TCP - Release 3.0
 * 
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved.
 * 
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code.
 * 
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates.
 * 
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies.
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef socket_h
#define socket_h
#ident	"@(#)socket.h	6.20 :/source/uts/common/sys/s.socket.h 6/16/87 16:19:27"

/* socket.h	6.1	83/07/29	 */

/*
 * Definitions related to sockets: types, address families, options.
 */

/*
 * Types
 */
#define	SOCK_STREAM	1	/* stream socket */
#define	SOCK_DGRAM	2	/* datagram socket */
#define	SOCK_RAW	3	/* raw-protocol interface */
#define	SOCK_RDM	4	/* reliably-delivered message */
#define	SOCK_SEQPACKET	5	/* sequenced packet stream */

/*
 * Option flags per-socket.
 */
#define	SO_DEBUG	0x0001	/* turn on debugging info recording */
#define	SO_ACCEPTCONN	0x0002	/* socket has had listen() */
#define	SO_REUSEADDR	0x0004	/* allow local address reuse */
#define	SO_KEEPALIVE	0x0008	/* keep connections alive */
#define	SO_DONTROUTE	0x0010	/* just use interface addresses */
#define	SO_BROADCAST	0x0020	/* permit sending of broadcast msgs */
#define	SO_USELOOPBACK	0x0040	/* bypass hardware when possible */
#define	SO_LINGER	0x0080	/* linger on close if data present */
#define	SO_OOBINLINE	0x0100	/* leave received OOB data in line */
#define SO_ORDREL	0x0200	/* give use orderly release */
#define SO_IMASOCKET	0x0400	/* use socket semantics (affects bind) */

/*
 * Additional options, not kept in so_options.
 */
#define SO_SNDBUF	0x1001	/* send buffer size */
#define SO_RCVBUF	0x1002	/* receive buffer size */
#define SO_SNDLOWAT	0x1003	/* send low-water mark */
#define SO_RCVLOWAT	0x1004	/* receive low-water mark */
#define SO_SNDTIMEO	0x1005	/* send timeout */
#define SO_RCVTIMEO	0x1006	/* receive timeout */
#define	SO_ERROR	0x1007	/* get error status and clear */
#define	SO_TYPE		0x1008	/* get socket type */
#define SO_PROTOTYPE	0x1009	/* get/set protocol type */

/*
 * Structure used for manipulating linger option.
 */
struct linger {
	int             l_onoff;/* option on/off */
	int             l_linger;	/* linger time */
};

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#define	SOL_SOCKET	0xffff	/* options for socket level */

/*
 * An option specification consists of an opthdr, followed by the value of
 * the option.  An options buffer contains one or more options.  The len
 * field of opthdr specifies the length of the option value in bytes.  This
 * length must be a multiple of sizeof(long) (use OPTLEN macro).
 */

struct opthdr {
	long            level;	/* protocol level affected */
	long            name;	/* option to modify */
	long            len;	/* length of option value */
};

#define OPTLEN(x) ((((x) + sizeof(long) - 1) / sizeof(long)) * sizeof(long))
#define OPTVAL(opt) ((char *)(opt + 1))

/*
 * the optdefault structure is used for internal tables of option default
 * values.
 */
struct optdefault {
	int             optname;/* the option */
	char           *val;	/* ptr to default value */
	int             len;	/* length of value */
};

/*
 * the opproc structure is used to build tables of options processing
 * functions for dooptions().
 */
struct opproc {
	int             level;	/* options level this function handles */
	int             (*func) ();	/* the function */
};

/*
 * Address families.
 */
#define	AF_UNSPEC	0	/* unspecified */
#define	AF_UNIX		1	/* local to host (pipes, portals) */
#define	AF_INET		2	/* internetwork: UDP, TCP, etc. */
#define	AF_IMPLINK	3	/* arpanet imp addresses */
#define	AF_PUP		4	/* pup protocols: e.g. BSP */
#define	AF_CHAOS	5	/* mit CHAOS protocols */
#define	AF_NS		6	/* XEROX NS protocols */
#define	AF_NBS		7	/* nbs protocols */
#define	AF_ECMA		8	/* european computer manufacturers */
#define	AF_DATAKIT	9	/* datakit protocols */
#define	AF_CCITT	10	/* CCITT protocols, X.25 etc */
#define	AF_SNA		11	/* IBM SNA */
#define AF_DECnet	12	/* DECnet */
#define AF_DLI		13	/* Direct data link interface */
#define AF_LAT		14	/* LAT */
#define	AF_HYLINK	15	/* NSC Hyperchannel */
#define	AF_APPLETALK	16	/* Apple Talk */

#define	AF_MAX		17

/*
 * Structure used by kernel to store most addresses.
 */
struct sockaddr {
	u_short         sa_family;	/* address family */
	char            sa_data[14];	/* up to 14 bytes of direct address */
};

/*
 * Structure used by kernel to pass protocol information in raw sockets.
 */
struct sockproto {
	unsigned short  sp_family;	/* address family */
	unsigned short  sp_protocol;	/* protocol */
};

/*
 * Protocol families, same as address families for now.
 */
#define	PF_UNSPEC	AF_UNSPEC
#define	PF_UNIX		AF_UNIX
#define	PF_INET		AF_INET
#define	PF_IMPLINK	AF_IMPLINK
#define	PF_PUP		AF_PUP
#define	PF_CHAOS	AF_CHAOS
#define	PF_NS		AF_NS
#define	PF_NBS		AF_NBS
#define	PF_ECMA		AF_ECMA
#define	PF_DATAKIT	AF_DATAKIT
#define	PF_CCITT	AF_CCITT
#define	PF_SNA		AF_SNA

#define	PF_MAX		12

/*
 * Maximum queue length specifiable by listen.
 */
#define	SOMAXCONN	5

/*
 * Message header for recvmsg and sendmsg calls.
 */
struct msghdr {
	caddr_t         msg_name;	/* optional address */
	int             msg_namelen;	/* size of address */
	int             msg_base;	/* base address of data */
	int             msg_len;/* size of data */
	caddr_t         msg_accrights;	/* access rights sent/received */
	int             msg_accrightslen;
};

#define	MSG_OOB		0x1	/* process out-of-band data */
#define	MSG_PEEK	0x2	/* peek at incoming message */
#define	MSG_DONTROUTE	0x4	/* send without using routing tables */

#define	MSG_MAXIOVLEN	16

/*
 * This ioctl code uses BSD style ioctl's to avoid copyin/out problems.
 * Ioctl's have the command encoded in the lower word, and the size of any in
 * or out parameters in the upper word.  The high 2 bits of the upper word
 * are used to encode the in/out status of the parameter; for now we restrict
 * parameters to at most 128 bytes.
 */
#define	IOCPARM_MASK	0x7f	/* parameters must be < 128 bytes */
#define	IOC_VOID	0x20000000	/* no parameters */
#define	IOC_OUT		0x40000000	/* copy out parameters */
#define	IOC_IN		0x80000000	/* copy in parameters */
#define	IOC_INOUT	(IOC_IN|IOC_OUT)
/* the 0x20000000 is so we can distinguish new ioctl's from old */
#define	_IO(x,y)	(IOC_VOID|(x<<8)|y)
#define	_IOR(x,y,t)	(IOC_OUT|((sizeof(t)&IOCPARM_MASK)<<16)|(x<<8)|y)
#define	_IOW(x,y,t)	(IOC_IN|((sizeof(t)&IOCPARM_MASK)<<16)|(x<<8)|y)
/* this should be _IORW, but stdio got there first */
#define	_IOWR(x,y,t)	(IOC_INOUT|((sizeof(t)&IOCPARM_MASK)<<16)|(x<<8)|y)

/*
 * Socket ioctl commands
 * 
 */

#define SIOCSHIWAT	_IOW('S', 1, int)	/* set high watermark */
#define SIOCGHIWAT	_IOR('S', 2, int)	/* get high watermark */
#define SIOCSLOWAT	_IOW('S', 3, int)	/* set low watermark */
#define SIOCGLOWAT	_IOR('S', 4, int)	/* get low watermark */
#define SIOCATMARK	_IOR('S', 5, int)	/* at oob mark? */
#define SIOCSPGRP	_IOW('S', 6, int)	/* set process group */
#define SIOCGPGRP	_IOR('S', 7, int)	/* get process group */
#define FIONREAD	_IOR('S', 8, int)	/* BSD compatibilty */
#define FIONBIO		_IOW('S', 9, int)	/* BSD compatibilty */
#define FIOASYNC	_IOW('S', 10, int)	/* BSD compatibilty */
#define SIOCPROTO	_IOW('S', 11, struct socknewproto)	/* link proto */
#define SIOCGETNAME	_IOR('S', 12, struct sockaddr)	/* getsockname */
#define SIOCGETPEER	_IOR('S', 13, struct sockaddr)	/* getpeername */
#define IF_UNITSEL	_IOW('S', 14, int)	/* set unit number */
#define SIOCXPROTO	_IO('S', 15)	/* empty proto table */

#define	SIOCADDRT	_IOW('R', 9, struct rtentry)	/* add route */
#define	SIOCDELRT	_IOW('R', 10, struct rtentry)	/* delete route */

#define	SIOCSIFADDR	_IOW('I', 11, struct ifreq)	/* set ifnet address */
#define	SIOCGIFADDR	_IOWR('I', 12, struct ifreq)	/* get ifnet address */
#define	SIOCSIFDSTADDR	_IOW('I', 13, struct ifreq)	/* set p-p address */
#define	SIOCGIFDSTADDR	_IOWR('I', 14, struct ifreq)	/* get p-p address */
#define	SIOCSIFFLAGS	_IOW('I', 15, struct ifreq)	/* set ifnet flags */
#define	SIOCGIFFLAGS	_IOWR('I', 16, struct ifreq)	/* get ifnet flags */
#define	SIOCGIFCONF	_IOWR('I', 17, struct ifconf)	/* get ifnet list */
#define SIOCIFDETACH	_IOW('I', 26, struct ifreq)	/* detach interface */
#define SIOCGENPSTATS	_IOWR('I', 27, struct ifreq)	/* get ENP stats */

#define SIOCX25XMT	_IOWR('I', 29, struct ifreq)	/* start a slp proc in
							 * x25if */
#define SIOCX25RCV	_IOWR('I', 30, struct ifreq)	/* start a slp proc in
							 * x25if */
#define SIOCX25TBL	_IOWR('I', 31, struct ifreq)	/* xfer lun table to
							 * kernel */

#define	SIOCGIFBRDADDR	_IOWR('I', 32, struct ifreq)	/* get broadcast addr */
#define	SIOCSIFBRDADDR	_IOW('I', 33, struct ifreq)	/* set broadcast addr */
#define	SIOCGIFNETMASK	_IOWR('I', 34, struct ifreq)	/* get net addr mask */
#define	SIOCSIFNETMASK	_IOW('I', 35, struct ifreq)	/* set net addr mask */
#define	SIOCGIFMETRIC	_IOWR('I', 36, struct ifreq)	/* get IF metric */
#define	SIOCSIFMETRIC	_IOW('I', 37, struct ifreq)	/* set IF metric */

#define	SIOCSARP	_IOW('I', 38, struct ifreq)	/* set arp entry */
#define	SIOCGARP	_IOWR('I', 39, struct ifreq)	/* get arp entry */
#define	SIOCDARP	_IOW('I', 40, struct ifreq)	/* delete arp entry */

#define SIOCSLGETREQ	_IOWR('I', 41, struct ifreq)	/* wait for switched
							 * SLIP request */
#define SIOCSLSTAT	_IOW('I', 42, struct ifreq)	/* pass SLIP info to
							 * kernel */

#define SIOCSIFNAME	_IOW('I', 43, struct ifreq)	/* set interface name */
#define	SIOCGIFONEP	_IOWR('I', 44, struct ifreq)	/* get one-packet params */
#define	SIOCSIFONEP	_IOW('I', 45, struct ifreq)	/* set one-packet params */

#define SIOCGENADDR	_IOWR('I', 65, struct ifreq)	/* Get ethernet addr */

#define SIOCSOCKSYS	_IOW('I', 66, struct socksysreq)	/* Pseudo socket syscall */

/*
 * This structure is used to encode pseudo system calls
 */
struct socksysreq {
	int             args[7];
};

/*
 * This structure is used for adding new protocols to the list supported by
 * sockets.
 */

struct socknewproto {
	int             family;	/* address family (AF_INET, etc.) */
	int             type;	/* protocol type (SOCK_STREAM, etc.) */
	int             proto;	/* per family proto number */
	dev_t           dev;	/* major/minor to use (must be a clone) */
	int             flags;	/* protosw flags */
};

/*
 * utility definitions.
 */

#define MIN(x,y) ((x) < (y) ? (x) : (y))
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#define MAXHOSTNAMELEN	64

#define	NBBY	8		/* number of bits in a byte */
/*
 * Select uses bit masks of file descriptors in longs. These macros
 * manipulate such bit fields (the filesystem macros use chars). FD_SETSIZE
 * may be defined by the user, but the default here should be >= NOFILE
 * (param.h).
 */
#ifndef FD_SETSIZE	/* kludge to get around the fact that idbuild uses */
			/* a different cpp (and M_XENIX is not defined) */

#ifndef	FD_SETSIZE
#define	FD_SETSIZE	256
#endif

typedef long    fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */
#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif

typedef struct fd_set {
	fd_mask         fds_bits[howmany(FD_SETSIZE, NFDBITS)];
}               fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	memset((char *)(p), '\0', sizeof(*(p)))

#endif

/* defines for user/kernel interface */

#define	MAX_MINOR	(makedev(1,0) - 1)	/* could be non-portable */

#if (INTEL == 32)
#define SOCKETSYS	128	/* MUST BE CHANGED DEPENDING ON OS/SYSENT.C!! */
#elif (ATT == 32)
#define SOCKETSYS	88	/* MUST BE CHANGED DEPENDING ON OS/SYSENT.C!! */
#elif (INTEL == 31) || (ATT == 31)
#define SOCKETSYS	88	/* MUST BE CHANGED DEPENDING ON OS/SYSENT.C!! */
#else
#define SOCKETSYS	83	/* MUST BE CHANGED DEPENDING ON OS/SYSENT.C!! */
#endif

#define  SO_ACCEPT	1
#define  SO_BIND	2
#define  SO_CONNECT	3
#define  SO_GETPEERNAME	4
#define  SO_GETSOCKNAME	5
#define  SO_GETSOCKOPT	6
#define  SO_LISTEN	7
#define  SO_RECV	8
#define  SO_RECVFROM	9
#define  SO_SEND	10
#define  SO_SENDTO	11
#define  SO_SETSOCKOPT	12
#define  SO_SHUTDOWN	13
#define  SO_SOCKET	14
#define  SO_SELECT	15
#define  SO_GETIPDOMAIN	16
#define  SO_SETIPDOMAIN	17
#define  SO_ADJTIME	18

#endif				/* socket_h */
