#ident	"@(#)sxt.h	1.2	90/08/08"
#ifndef _SYS_SXT_H
#define _SYS_SXT_H
#ident "@(#) sxt.h 22.1 90/01/15 "
#ident "@(#)sxt.h	1.2 89/09/29"
#ident "@(#) sxt.h 1.6 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head.sys:sxt.h	1.3" */

/*
 **	Multiplexed channels driver header
 */

#define	SXTRACE		1		/* 1 to include tracing */

#define	MAXLINKS	32
#define	CHAN(dev)	(dev&CHANMASK)
#define	LINK(dev)	((dev>>CHANBITS)&(0xff>>CHANBITS))
 

#if	(MAXPCHAN*MAXLINKS) > 256
	ERROR -- product cannot be greater than minor(dev)
#endif



struct Channel
{
	struct tty	tty;		/* Virtual tty for this channel */
};

typedef struct Channel *Ch_p;

struct Link
{
	struct tty *	line;		/* Real tty for this link */
	char		controllingtty;	/* the current top dog */
	char		old;		/* Old line discipline for line */
	char		nchans;		/* Number of channels allowed */
	unsigned char	chanmask;	/* Allowable channel bits */
	char		open;		/* Channel open bits */
	char		xopen;		/* Exclusive open bits */
	char		wpending;	/* pending writes/channel */
	char		iblocked;	/* channels blocked for input */
	char		oblocked;	/* channels blocked for output*/
	short		lwchan;		/* Last channel written bit */
	char		wrcnt;		/* Number of writes on last channel written */
	dev_t		dev;		/* major and minor device # */
	struct Channel	chans[1];	/* Array of channels for this link */
};

typedef	struct Link *	Link_p;

/*
**	Ioctl args
*/

#define	SXTIOCLINK	('b'<<8)
#define	SXTIOCTRACE	(SXTIOCLINK|1)
#define	SXTIOCNOTRACE	(SXTIOCLINK|2)
#define SXTIOCSWTCH	(SXTIOCLINK|3)
#define	SXTIOCWF	(SXTIOCLINK|4)
#define SXTIOCBLK	(SXTIOCLINK|5)
#define SXTIOCUBLK	(SXTIOCLINK|6)
#define SXTIOCSTAT	(SXTIOCLINK|7)



/* the following structure is used for the SXTIOCSTAT ioctl call */
struct sxtblock
{
	char	input;		/* channels blocked on input  */
	char	output;		/* channels blocked on output */
};



#define	t_link		t_dstat		/* Use dstat in real tty for linknumber */

#define	MAXPCHAN	8			/* Maximum channel number */
#define	CHANBITS	3			/* Bits for channel number */
#define	CHANMASK	07			/* 2**CHANBITS - 1 */
#define	SXTHOG		2			/* Channel consecutive write limit */

#endif	/* _SYS_SXT_H */
