#ident	"@(#)ti.h	1.2	90/08/08"
#ident "@(#)ti.h	1.14 90/07/09"
#ident	"@(#) ti.h 1.1 89/09/12 "

/*
 *	Copyright (C) Altos Computer Systems, 1989, 1990.
 *	This module contains Proprietary Information of
 *	Altos Computer Systems and should be treated as Confidential.
 */

#define	SCSI_MAXIDS	7	/* max ID numbers supported	*/
#define	SCSI_MAXLUNS	8	/* max LUNs on each ID		*/

/*
 *	The following parameters match those used by the SCSI BIOS
 *	code and are used to pacify the high-level drivers.
 */

#define SECTORS		32	/* sectors per track for disks  */
#define HEADS		64	/* heads for disks  */


#define	REW_TO		(60*6)	  /* allow up to 6 minutes for REWIND,
				     LOAD, or SEEK commands */
#define	FMT_TO		(60*30)   /* allow 30 minutes for format      */
#define	ER_TO		(60*60*4) /* some devices take up to 4 hours to erase */
#define	TO_SECS		70	  /* default time out is 70 seconds */

#define	ERASE_CMD	0x19	/* SCSI erase command		*/
#define	LOAD_CMD	0x1b	/* SCSI load/unload command	*/
#define	SPACE_CMD	0x11	/* SCSI space to next filemark	*/

#define	R_LIMIT		0x200000L /* bit spin loop limit		*/

#define	DISK	1
#define	TAPE	2

#define	ISDISK(id)	(ti_type[id] == DISK)
#define	ISRDWR(x)	((x)->scsi_cmd.raw[0] == READ_CMD || (x)->scsi_cmd.raw[0] == WRITE_CMD)


struct ccb {			/* command description block	*/
	struct ccb *req_forw;	/* forward link to next block A001 */
	struct ccb *req_back;	/* backward link to next block A001 */
	char	opcode;		/* value sent to CMD port	*/
	char	l_phase;	/* last phase			*/
	char	cmd_length;	/* CMDLENGTH			*/
	char	dir;		/* transfer direction		*/
	paddr_t	length;
	paddr_t	pointer;
/* not used
	char	link[3];
	char	link_id;
*/
	char	l_intr;		/* last interrupt value		*/
	char	l_errintr;	/* last error interrupt value	*/
	char	id;
	char	lun;
	char	scsi_cmd[CMDLENGTH];
	char	fill[2];	/* to 16 bytes				*/

	char	ptr[3];		/* saved data pointer			*/
	char	state;		/* saved chip state			*/
	char	use_flag;	/* zero if available			*/
	char	internal;	/* driver internal request if non-zero	*/
	char	jq;		/* job queue index			*/
	char	dma;		/* DMA in use flag			*/
	char	r_count;	/* retry count				*/
	u_char	dis_pending:1;	/* waiting for BUS free state		*/
	u_char	bus_pending:1;	/* waiting for BUS service interrupt	*/
	u_char	sg_req:1;	/* scatter/gather in progress flag	*/
	u_char	reqsens_pend:1;	/* request sense waiting 		*/
	u_char	spares:4;	/* whats left of a byte			*/
	short	sg_len;		/* number of entries in sg list		*/
struct	scsi_sg_list *sg;	/* scatter/gather list pointer		*/
	int	left;		/* number of bytes not transfered on dma*/
struct	buf 	*rbuf;		/* request per this buf if non zero	*/
	REQ_IO	*request;	/* scsi_io_req pointer			*/
};
typedef struct ccb CCB;

extern	struct ccb	*ccbbuf;
extern	struct ccb	ccbfreelist;


struct	titab {
	struct	ccb 	*req_forw;	/* Forward link to next que element */
	struct	ccb	*req_back;	/* Backward link to prev que element */
	struct	ccb	*b_actf;	/* Active pointer forward link */
	struct	ccb	*b_actl;	/* Active pointer backward link */
	int		b_cnt;		/* Number of elements on queue */
};
typedef struct titab TITAB;


/*
 *	tiqueue
 *
 *	This is the per-id device request queue.  Each SCSI ID has
 *	a separate queue and any outstanding requests for that ID
 *	are linked onto the queue.  The queues are maintained as
 *	doubly-linked circular queues.
 *
 *	The b_actl entry is the pointer to the currently active entry
 *	in a device queue.  For non-disk devices, this entry always
 *	points to the first queue entry (unless the queue is empty; then
 *	it points to the list head).  For disk devices, the queue is
 *	sorted and b_actl can point at any entry on the queue.
 */

struct	tiqueue {
	struct	scsi_io_req 	tab;		/* Per unit list header   */
	struct	scsi_io_req	*b_actl;	/* Active request pointer */
	int			b_cnt;		/* Elements on queue 	  */
};
typedef struct tiqueue TIQUEUE;


/*
 *	Alternate definitions of fields in scsi_io_req.
 */

#define	av_forw		tab.req_forw
#define	av_back		tab.req_back
#define	b_bcount	data_len
#define	b_blkno		data_blk
#define	b_error		host_err
#define	b_dev		id


/*
 *	SCSI Messages
 */

#define	CMP_MESS	0x00	/* Command Complete 		*/
#define	EXT_MESS	0x01	/* Extended Message		*/
#define	SDP_MESS	0x02	/* Save Data Pointer		*/
#define	RDP_MESS	0x03	/* Restore Data Pointer		*/
#define	DIS_MESS	0x04	/* Disconnect			*/
#define	IDE_MESS	0x05	/* Initiator Detected Error	*/
#define	ABT_MESS	0x06	/* Abort			*/
#define	REJ_MESS	0x07	/* Message Reject		*/
#define	NOP_MESS	0x08	/* No Operation			*/
#define	MPE_MESS	0x09	/* Message Parity Error		*/
#define	LCC_MESS	0x0a	/* Linked Command Complete	*/
#define	LCF_MESS	0x0b	/* Linked Command Complete (F)	*/
#define	BDR_MESS	0x0c	/* Bus Device Reset		*/
#define	IDN_MESS	0x80	/* Identify			*/




/*
**	The following defines are for the TI SN75C091 SCSI controller.
**	Since the chip contains 32 registers these will be listed in 
**	numeric order by port address with all the pertinent defines below.
*/

#define	DATA		0x00	/* TI data FIFO I/O port (R/W)	*/

#define	CMD		0x01	/* TI command port (R/W)	*/
#define	TI_RESET	0x00	/*  Reset TI chip		*/
#define	TI_DIS		0x01	/*  Disconnect after EI_TO	*/
#define	TI_NEGACK	0x04	/*  Negate ACK line		*/
#define	TI_CLR_RFIFO	0x05	/*  Clear Receive FIFO (after error) */
#define	TI_CLR_TFIFO	0x06	/*  Clear Transmit FIFO		*/
#define	SCSI_RESET	0x07	/*  SCSI Bus reset		*/
#define	SELECT_ATN	0x08	/*  SCSI select with ATN	*/
#define	SELECT		0x09	/*  SCSI select without ATN	*/
#define	XFER		0x14	/*  SCSI transfer Info		*/
#define	XFER_PAD	0x15	/*  SCSI transfer pad		*/
#define	SEL_XFER_ATN	0x18	/*  SCSI Select with ATN and Transfer */
#define	SEL_XFER	0x19	/*  SCSI Select without ATN and Transfer */
#define	C_DMA		0x80	/*  Add DMA to command		*/
#define	C_MA		0x40	/*  Add Manual mode to command	*/
#define	C_DIN		0x20	/*  Add Data in phase expected (otherwise
				    Data Out phase) to command  */

#define	XFER_STS	0x02	/* TI transfer status port (Read) */
#define	TS_INT		0x80	/*  Interrupt pending bit	*/
#define	TS_RFE		0x40	/*  Receive FIFO empty		*/
#define	TS_RFHF		0x20	/*  Receive FIFO half empty	*/
#define	TS_TFF		0x10	/*  Transmit FIFO full		*/
#define	TS_TFHF		0x08	/*  Transmit FIFO half full	*/
#define	TS_TC0		0x04	/*  Transfer counter zero	*/
#define	TS_OC0		0x02	/*  Offfset counter zero	*/
#define	TS_BSY		0x01	/*  Busy - command in progress	*/

#define	BUS_PH_STS	0x03	/* TI bus phase status (Read)	*/
#define	BUS_INIT	0x80	/* Connected as an initiator	*/
#define	BUS_SRST	0x01	/* SCSI reset asserted on bus	*/
#define	BUS_PHMSK	0x0e	/* Phase bits mask		*/
#define	BUS_FREE	0x00	/* Bus free (INIT bit must not be set) */
#define	BUS_DOUT	0x00	/* Data out (INIT bit must be set */
#define	BUS_DIN		0x02	/* Data in			*/
#define	BUS_CMD		0x04	/* Command out			*/
#define	BUS_STAT	0x06	/* Status in			*/
#define	BUS_MOUT	0x0c	/* Message out			*/
#define	BUS_MIN		0x0e	/* Message in			*/

#define	FUNC_INT_STS	0x04	/* TI functional interrupt status (Read)*/
#define	FI_SEL		0x80	/*  Selected			*/
#define	FI_BUS		0x40	/*  Bus Service			*/
#define	FI_ATN		0x20	/*  Attention			*/
#define	FI_FC		0x10	/*  Function Complete (normal)  */
#define	FI_DIS		0x08	/*  Disconnected		*/
#define	FI_RSL		0x02	/*  Reselected			*/
#define	FI_ABEND	0x01	/*  Abnormal ending		*/

#define	ERR_INT_STS	0x05	/* TI error interrupt status (Read) */
#define	EI_PE		0x80	/*  Parity Error		*/
#define	EI_UMS		0x40	/*  Unexpected Message Sequence */
#define	EI_SRST		0x20	/*  SCSI Reset			*/
#define	EI_TO		0x10	/*  Time Out			*/
#define	EI_NVC		0x08	/*  Invalid Command		*/
#define	EI_CNTL		0x04	/*  Control Error		*/
#define	EI_NEWLN	0x02	/*  New LUN			*/
#define	EI_HALT		0x01	/*  Halted			*/

#define	INT_EN		0x06	/* TI Interrupt enable register (R/W) */
#define	IE_FC		0x04	/*  Function Complete Interrupt enable */
#define	IE_AI		0x02	/*  ATN Interrupt enable	*/
#define	IE_MASTER	0x01	/*  Master Interrupt enable	*/

#define	CTL		0x08	/* TI Control register (R/W)	*/
#define	CTL_SE		0x80	/*  Selection Enable		*/
#define	CTL_RE		0x40	/*  Reselection Enable		*/
#define	CTL_HA		0x20	/*  Halt on ATN			*/
#define	CTL_HPE		0x10	/*  Halt on Parity Error	*/
#define	CTL_AAPE	0x08	/*  Assert ATN on Parity Error	*/
#define	CTL_HD		0x04	/*  Halt on Disconnect		*/
#define	CTL_HAAM	0x02	/*  Hold ATN after message	*/
#define	CTL_ATNDS	0x01	/*  ATN Disable			*/

#define	BS_CTL		0x09	/* TI Byte Stack control register (R/W) */
#define	BS_DMD		0x80	/*  Demand Transfer DMA		*/
#define	BS_WL1		0x00	/*  Byte stack word length = 1  */
#define	BS_WL2		0x04	/*    Word Length = 2 (Bits 3,2)*/
#define	BS_WL3		0x08	/*    Word Length = 3		*/
#define	BS_WL4		0x0c	/*    Word Length = 4		*/
#define	BS_BOF0		0x00	/*  Byte Offset = 0  (Bits 1,0) */
#define	BS_BOF1		0x01	/*              = 1		*/
#define	BS_BOF2		0x02	/*              = 2		*/
#define	BS_BOF3		0x03	/*              = 3		*/

#define	PAR_CTL		0x0a	/* TI Parity Control register (R/W) */
#define	PAR_STD		0x03	/*  standard parity enables	*/

#define	SYNC_XFER	0x0b	/* TI Synchronous transfer register (R/W) */

#define	SEL_TO		0x0c	/* TI Selection Timeout register (R/W) */
#define	TO_OFF		0x00	/*  timeouts off (default)	*/
#define	TO_ON		0x80	/*  allow time outs (3.27ms/count) */

#define	SELF_ID		0x0d	/* TI Self ID register (R/W)	*/

#define	DEST_ID		0x0e	/* TI Destination ID register (R/W) */

#define	SRC_ID		0x0f	/* TI Source ID register (R/W)	*/
#define	SRC_ID_VALID	0x08	/*  SRC Id valid bit		*/

#define	TARGET_LUN	0x10	/* TI Target LUN register (R/W) */

#define	CMD_PHASE	0x11	/* TI Command Phase register (R/W) */
#define	SDP_BIT		0x80	/*  Save data pointer bit	*/

#define	XFER_CNT_L	0x12	/* TI Transfer Counter bits 7-0 (R/W) */
#define	XFER_CNT_M	0x13	/* TI    "        "     "   15-8 */
#define	XFER_CNT_H	0x14	/* TI    "        "     "   23-16 */

#define	BU_CNT_L	0x15	/* TI Backup Counter Bits 7-0   (R/W) */
#define	BU_CNT_M	0x16	/* TI   "       "     "   15-8   */
#define	BU_CNT_H	0x17	/* TI   "       "     "   23-16  */

#define OFF_CNT		0x18	/* TI Offfset Counter (R/W)	*/

#define	PREFETCH_CNT	0x19	/* TI Prefetch Counter (Read)	*/

/*
**	Registers 0x1a to 0x1f are test registers and not used here
*/
#define	DMA_CTL		0x20	/* Base I/O SCSI DMA control port (write) */
#define	DMA_IN		0x01	/*  DMA write to memory from SCSI */
#define	DMA_OUT		0x00	/*  DMA read from memory to SCSI */

/*
**	Host status definitions
*/
#define	HOST_DONE	0x00	/* no adapter detected errors	*/
#define	HOST_LINKED_OK	0x0A	/* linked command completed ok	*/
#define	HOST_LINKED_BAD	0x0B	/* linked command completed bad	*/
#define	HOST_SEL_TO	0x11	/* selection timeout		*/
#define	HOST_DATA_OVER	0x12	/* data overrun			*/
#define	HOST_BUS_FREE	0x13	/* unexpected bus free		*/
#define	HOST_CMD	0x15	/* command error		*/
#define	HOST_CCB_ERROR	0x16	/* invalid CCB			*/
#define	HOST_LINK_ERR	0x17	/* linked CCB to another LUN	*/
#define	HOST_CMD_TO	0x18	/* no int on last command	*/
#define	HOST_SRST	0x19	/* SCSI reset received		*/
#define	HOST_ABEND	0x1a	/* command abnormal end		*/
#define	HOST_REQSENS_ERR 0x1b	/* request sense failed		*/
#define	HOST_DIS_TO	0x1c	/* no disconnect interrupt	*/
#define	HOST_PHASE_ERR	0x20	/* target bus phase seq error	*/
				/* (base error code)		*/

				/* Unit status definitions	*/
#define	UNIT_MASK	0x1e	/* status bits mask		*/
#define	UNIT_GOOD	0x00	/* success			*/
#define	UNIT_CHECK	0x02	/* check condition		*/
#define	UNIT_MET	0x04	/* condition met		*/
#define	UNIT_BUSY	0x08	/* busy				*/
#define	UNIT_INTERMED	0x10	/* intermediate cmd good	*/
#define	UNIT_INTMED_GD	0x14	/* intermediate cond met	*/
#define	UNIT_RESERV	0x18	/* reservation conflict		*/

