#ident	"@(#)ups.h	1.12 91/05/16"
#ifndef _SYS_UPS_H
#define _SYS_UPS_H

/* @(#)ups.h	1.12 91/05/16 */

#define	SHUTSAVE	1
#define SHUTKILL	2
#define RESTART		3

#define RSMAGIC	0x54574954	/* magic number */
#define RSPART	"/dev/restart"	/* restart device */
#define XRATE	(700 * 1024)	/* ad hoc disk transfer rate (700K/sec) */
#define TOTMEM	(ctob(physmem))	/* total system memory */
#define FUDGE	0		/* fudge factor */
#define WTIME	TOTMEM/XRATE	/* memory dump time */

struct pwrval {
	long  pwrtype;		/* power failure type */
	long  failtime;		/* secs to wait after 1st interrupt */
	long  upstime;		/* secs UPS unit can operate */
	long  pwrtime;		/* secs to wait after posting SIGPWR */
	long  termtime;		/* secs to wait after posting SIGTERM */
	long  pwrcnt;		/* max interrupts allowed within "failtime" */
	dev_t restartdev;	/* device number of restart division */
};

#define RSHDRSZ		1024	/* size of restart header */
#define	MAXREGIONS	16	/* max number of restart device "regions" */
#define MAXPGSZ		4096	/* max size for each restart device "page" */

/* The following defines are used to identify the type of memory region
 * saved; i.e., kernel memory, the rest of main memory, or dual ported
 * memory on expansion boards.
 */
#define RS_KERNEL	0x01		/* kernel text/data/bss */
#define RS_LOWMEM	0x02		/* 0-640K region */
#define RS_MEM		0x04		/* non-kernel extended memory */
#define RS_DPMEM	0x08		/* dual ported controller memory */
#define RS_PAGES	0x10		/* page tables created in startup */

#pragma pack(1)
union rstrthdr {
	struct {
		ulong	magic;		/* magic number */
		ushort	pad;		/* two pad bytes */
		u_char	nregions;	/* number of memory regions saved */
		struct {
			u_char	type;	/* type of memory region saved */
			ulong	pagesz;	/* size of memory page */
			ulong	count;	/* number of pages in memory region */
			ulong	p_addr;	/* physical addr of memory region */
			ulong	v_addr;	/* virtual addr of memory region */
			ulong	ep;	/* entry pt (virtual addr) */
			ulong	disk;	/* disk address offset */
		} region[MAXREGIONS];
	} param;
	u_char	dummy[RSHDRSZ];
};
#pragma pack()

#ifdef INKERNEL
#ifdef INKERNEL
extern int ups_pwrfail;
extern int ups_restart;
extern struct proc *phandproc;
extern struct pwrval pwrval;
#endif	/* INKERNEL */

#endif	/* _SYS_UPS_H */
#endif	/* INKERNEL */
