#ident	"@(#)vj_debug.h	1.2	90/08/08"
#ident "@(#)vj_debug.h	1.1 90/02/25"

/* Individual function debug defines */
#define DBG_VJ_CINIT        0x00000001
#define DBG_VJ_ENTRY        0x00000002
#define DBG_VJ_UINIT        0x00000004
#define DBG_VJ_SENSE        0x00000008
#define DBG_VJ_CMD          0x00000010
#define DBG_VJ_WAIT         0x00000020
#define DBG_VJ_ENQ          0x00000040
#define DBG_VJ_ENQ_RW       0x00000080
#define DBG_VJ_SGSETUP      0x00000100
#define DBG_VJ_QINT         0x00000200
#define DBG_VJ_EINT         0x00000400
#define DBG_VJ_NINT         0x00000800
#define DBG_VJ_SCSIDMP		0x00001000

#if VJ_DEBUG
#define DBG_VJDUMP 1
ULONG           vj_debug = 0x0;
#define	DIAG(x)					if (vj_debug & FUNC) printf(x)
#define	DIAG1(x,a1)				if (vj_debug & FUNC) printf(x,a1)
#define	DIAG2(x,a1,a2)			if (vj_debug & FUNC) printf(x,a1,a2)
#define	DIAG3(x,a1,a2,a3)		if (vj_debug & FUNC) printf(x,a1,a2,a3)
#define	DIAG4(x,a1,a2,a3,a4)	if (vj_debug & FUNC) printf(x,a1,a2,a3,a4)
#define	DIAG5(x,a1,a2,a3,a4,a5)	if (vj_debug & FUNC) printf(x,a1,a2,a3,a4,a5)
#define	VJDUMP(x,y,z)		if (vj_debug & FUNC) hdump(x,y,z)
#else
#define DBG_VJDUMP 0
#define	DIAG(x)
#define	DIAG1(x,a1)
#define	DIAG2(x,a1,a2)
#define	DIAG3(x,a1,a2,a3)
#define	DIAG4(x,a1,a2,a3,a4)
#define	DIAG5(x,a1,a2,a3,a4,a5)
#define	VJDUMP(x,y,z)
#endif				/* VJ_DEBUG */

/* FIXME: this actually allocates storage. Needs to only allocate at
 *	  user level, not at kernel level to save space! Don't include
 *	  this file twice until this problem is solved!
 */

/* Jaguar errors */
static VJ_ETABLE jaguar_errs[] = {
				  {0x00, "Good Status"},
				  {0x01, "Work Queue Full"},
				  {0x02, "Work Queue not Initialized."},
				  {0x03, "First command not Initialize."},
				  {0x04, "Invalid Command Type."},
				  {0x05, "Invalid Work Queue Number."},
				  {0x06, "Work Queue already initialized."},
			{0x07, "Re-initialization of a Work Queue Failed."},
		      {0x08, "Start Queue Mode before Initialize Command."},
				  {0x09, "Command Type not Implemented."},
				  {0x0A, "Invalid Priority specified."},
				  {0x10, "Reserved Field not Zero."},
				  {0x11, "Bus Reset issued by Jaguar."},
				  {0x12, "Bus 2 is not available."},
				  {0x13, "SCSI ID Requested is our own."},
				  {0x14, "SCSI Bus is held in Reset."},
				  {0x15, "Command Canceled - External."},
				  {0x16, "Invalid Page size in CIB."},
				  {0x17, "Command Tag Search == 0."},
				  {0x18, "Command is on the Bus."},
				  {0x20, "Bus-Error Occurred during DMA."},
				  {0x21, "EISA timeout."},
				  {0x23, "Invalid DMA Address."},
				  {0x24, "Illegal memory type."},
				  {0x25, "Invalid transfer count."},
				  {0x26, "IOPB fetch bus error."},
				  {0x27, "IOPB fetch timeout."},
				  {0x28, "IOPB post bus error."},
				  {0x29, "IOPB post timeout."},
				  {0x2A, "Illegal address on IOPB Fetch."},
				  {0x2B, "Illegal address on IOPB Post."},
			       {0x2C, "Bus error on Scatter/Gather Fetch."},
			   {0x2D, "Timeout error on Scatter/Gather Fetch."},
		       {0x2E, "Invalid number of Scatter/Gather Elements."},
		       {0x30, "Selection phase of the SCSI device failed."},
		  {0x31, "Device did not reselect the board and timedout."},
		    {0x32, "SCSI operation did not complete successfully."},
				  {0x33, "SCSI invalid disconnection."},
	       {0x34, "SCSI transfer count did not match the count given."},
				{0x40, "Odd Count in Scatter/Gather List."},
		      {0x41, "Illegal Memory Type in Scatter/Gather List."},
			  {0x42, "Illegal Address in Scatter/Gather List."},
				  {0x50, "Buffer Count too large."},
				  {0x51, "Can't execute because of ExCRB."},
				  {0x80, "Command flushed on error."},
				  {0x81, "Cancelled due to flush command."},
				  {0x82, "Unknown Device Re-Selection."},
				  {0x83, "Count Exhausted Error."},
				  {0x84, "Data Direction Error."},
				  {0xC0, "IOPB Type Error."},
				  {0xC1, "IOPB Timeout Error."},
				  {0xFF, "Unknown Error."}
};

/* SCSI errors */
static VJ_ETABLE scsi_errs[] = {
				{0x00, "Good Status"},
				{0x02, "Request Sense needed."},
				{0x08, "Busy Status."},
				{0x10, "Intermediate Status."},
				{0x18, "Reservation Conflict."},
				{0xFF, "Unknown Error."}
};

/* Sense errors */
static VJ_ETABLE sense_errs[] = {
				 {SCSI_NO_SENSE, "No Sense: "},
	{SCSI_RECOVERABLE_ERROR, "Command completed with recovery actions"},
				 {SCSI_NOT_READY, "Drive can't be accessed"},
			  {SCSI_MEDIUM_ERROR, "Non-recoverable data error"},
      {SCSI_HARDWARE_ERROR, "Non-recoverable hardware failure(parity,etc)"},
			 {SCSI_ILLEGAL_REQUEST, "Illegal parameter in cdb"},
		   {SCSI_UNIT_ATTENTION, "Media change or drive was reset"},
			{SCSI_DATA_PROTECT, "Cartridge is write-protected"},
		{SCSI_BLANK_CHECK, "No-data condition encountered on tape"},
			  {SCSI_ABORT_COMMAND, "Drive aborted the command"},
       {SCSI_VOLUME_OVERFLOW, "Physical EOM reached, data still in buffer"},
				 {0xFF, "Status code not in table"}
};





