#ident	"@(#)wait.h	1.3 91/04/01"
#ifndef _SYS_WAIT_H
#define _SYS_WAIT_H
/*
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/*
 * New for POSIX
 */

/*
 * Option bits for the third argument of waitpid().  WNOHANG causes the
 * wait to not hang if there are no stopped or terminated processes, rather
 * returning an error indication in this case (pid==0).  WUNTRACED
 * indicates that the caller should receive status about untraced children
 * which stop due to signals.  If children are stopped and a wait without
 * this option is done, it is as though they were still running... nothing
 * about them is returned.
 */
#define         WNOHANG         1       /* don't hang in wait */
#define         WUNTRACED       2       /* tell about stopped, untraced children */

/*
 * macros to interpret stat_loc from wait(stat_loc) and waitpid(,stat_loc,)
 */
#define         WIFEXITED(sv)           ((sv & 0xff) == 0)
#define         WEXITSTATUS(sv)         ((sv >> 8) & 0xff)
#define         WIFSIGNALED(sv)         ((sv) && (sv == (sv & 0x00ff)))
#define         WTERMSIG(sv)             (sv & 0x7f)
#define         WIFSTOPPED(sv)          ((sv & 0xff) == 0177)
#define         WSTOPSIG(sv)            ((sv >> 8) & 0xff)

#ifndef INKERNEL

#include <sys/types.h>

#if	defined(__STDC__) && !defined(NO_PROTOTYPE)
extern pid_t	wait(int *);
extern pid_t	waitpid(pid_t, int *, int);
#else
extern pid_t	wait();
extern pid_t	waitpid();
#endif

#endif	/* INKERNEL */

#endif	/* _SYS_WAIT_H */
