#ident	"@(#)xprint.h	1.2	91/02/18"

/*
 * Altos transparent printer ioctl support
 *
 * Note that all XPRIOCtls except XPRSETSTR must be performed
 * on transparent printer minor device 0 (/dev/xprsrv)
 *
 * XPRSETSTR is meant for use on dialup ports and is canceled on close.
 */

#define XPRIOC	('a'<<8)	/* type for Altos xprint ioctls */

#define XPRMAXDEV	(XPRIOC|0)	/* Get max config'd xpr minor dev num */
#define XPRGETMAP	(XPRIOC|1)	/* Get xprargs for xprargs.xprnum */
#define XPRSETMAP	(XPRIOC|2)	/* Set xprargs for xprargs.xprnum */
#define XPRSETSTR	(XPRIOC|3)	/* Set xstrs (xprnum/maj/min ignored */
#define	XSTRLEN		32

struct xprargs {	/* structure used for GET/SET XPRIOC ioctls */
	int xprnum;	/* transparent printer's minor device number */
	int xmaj;	/* associated terminals major device number */
	int xmin;	/* associated terminals minor device number */
	char xstr[2][XSTRLEN];	/* transparent print on/off strings */
};

#define XPROFF	0	/* xprargs.xstr index for printer off string */
#define	XPRON	1	/* xprargs.xstr index for printer on string */

#define NXPRDEVS	100	/* number xprs possible (largest minor + 1) */
