


     COPY(C)		    Altos UNIX System V		       COPY(C)



     Name
	  copy - copies	groups of files

     Syntax
	  copy [ option	] ...  source ...  dest

     Description
	  The copy command copies the contents of directories to
	  another directory.  It is possible to	copy whole file
	  systems since	directories are	made when needed.

	  If files, directories, or special files do not exist at the
	  destination, then they are created with the same modes and
	  flags	as the source.	In addition, the super-user may	set
	  the user and group ID.  The owner and	mode are not changed
	  if the destination file exists.

	  Note that there may be more than one source directory.  If
	  so, the effect is the	same as	if the copy command had	been
	  issued for each source directory with	the same destination
	  directory for	each copy.

	  Options do not have to be given as separate arguments, and
	  may appear in	any order, even	after the other	arguments.
	  The options are:

	  -a	  Asks the user	before attempting a copy.  If the
		  response does	not begin with a ``y'',	then a copy is
		  not done.  When used together	with the -v option, it
		  overrides the	verbose	option so that messages
		  regarding the	copy action are	not displayed.

	  -l	  Uses links instead whenever they can be used.
		  Otherwise a copy is done.  Note that links are never
		  done for special files or directories.

	  -n	  Requires the destination file	to be new.  If not,
		  then the copy	command	does not change	the
		  destination file.  The -n flag is meaningless	for
		  directories.	For special files a -n flag is assumed
		  (i.e., the destination of a special file must	not
		  exist).

	  -o	  If set then every file copied	has its	owner and
		  group	set to those of	the source.  If	not set, then
		  the file's owner is the user who invoked the
		  program.

	  -m	  If set, then every file copied has its modification
		  time and access time set to that of the source.  If
		  not set, then	the modification time is set to	the
		  time of the copy.



     Page 1					     (printed 3/20/91)






     COPY(C)		    Altos UNIX System V		       COPY(C)



	  -r	  If set, then every directory is recursively examined
		  as it	is encountered.	 If not	set then any
		  directories that are found are ignored.

	  -ad	  Asks the user	whether	a -r flag applies when a
		  directory is discovered.  If the answer does not
		  begin	with a ``y'', then the directory is ignored.

	  -v	  Messages are printed that reveal what	the program is
		  doing.  If used with the -a option, the -a option is
		  given	priority so that it overrides the verbose
		  option, and the copy action message is not
		  displayed.

	  Arguments to copy are:

	  source  This may be a	file, directory	or special file.  It
		  must exist.  If it is	not a directory, then the
		  results of the command are the same as for the cp
		  command.

	  dest	  The destination must be either a file	or directory
		  name that is different from the source.

	  If the source	and destination	are anything but directories,
	  then copy acts just like a cp	command.  If both are
	  directories, then copy copies	each file into the destination
	  directory according to the flags that	have been set.

     Examples
	  This command line verbosely copies all files in the current
	  directory to /tmp/food:

	       copy -v . /tmp/food

	  The next command line	copies all files, except for those
	  that begin with a period (.),	and copies the immediate
	  contents of any child	directories:

	       copy * /tmp/logic

	  This command is the same as the previous one,	except that it
	  recursively examines all subdirectories, and it sets group
	  and ownership	permissions on the destination files to	be the
	  same as the source files:

	       copy -ro	* /tmp/logic

     Notes
	  Special device files can be copied. When they	are copied,
	  any data associated with the specified device	is not copied.




     Page 2					     (printed 3/20/91)



