


     CSPLIT(C)		    Altos UNIX System V		     CSPLIT(C)



     Name
	  csplit - splits files	according to context

     Syntax
	  csplit [-s] [-k] [-f prefix] file arg1 [... argn]

     Description
	  csplit reads file and	separates it into n+1 sections,
	  defined by the arguments arg1...  argn.  By default the
	  sections are placed in files xx00 ...	 xxn (n	may not	be
	  greater than 99).  These sections get	the following pieces
	  of file:

	  00:	From the start of file up to (but not including) the
		line referenced	by arg1.

	  01:	From the line referenced by arg1 up to the line
		referenced by arg2.
	      .
	      .
	      .

	  n+1:	From the line referenced by argn to the	end of file.

	  The options to csplit	are:

	  -s	     csplit normally prints the	character counts for
		     each file created.	 If the	-s option is present,
		     csplit suppresses the printing of all character
		     counts.

	  -k	     csplit normally removes created files if an error
		     occurs.  If the -k	option is present, csplit
		     leaves previously created files intact.

	  -f prefix  If	the -f option is used, the created files are
		     named prefix00 ...	prefixn.  The default is xx00
		     ...  xxn.

	  The arguments	(arg1 ...  argn) to csplit can be a
	  combination of the following:

	  /rexp/  A file is to be created for the section from the
		  current line down to (but not	including) the line
		  containing the regular expression rexp.  The current
		  line becomes the line	containing rexp.  This
		  argument may be followed by an optional + or - some
		  number of lines (e.g., /Page/-5).

	  %rexp%  This argument	is the same as /rexp/, except that no
		  file is created for the section.




     Page 1					     (printed 3/20/91)






     CSPLIT(C)		    Altos UNIX System V		     CSPLIT(C)



	  lnno	  A file is to be created from the current line	down
		  to (but not including) lnno.	The current line
		  becomes lnno.

	  {num}	  Repeat argument.  This argument may follow any of
		  the above arguments.	If it follows a	rexp type
		  argument, that argument is applied num more times.
		  If it	follows	lnno, the file will be split every
		  lnno lines (num times) from that point.

	  Enclose all rexp type	arguments that contain blanks or other
	  characters meaningful	to the shell in	the appropriate
	  quotation marks.  Regular expressions	may not	contain
	  embedded newlines.  csplit does not affect the original
	  file;	it is the users	responsibility to remove it.

     Examples
	       csplit -f cobol file  '/procedure division/'  '/par5./'	'/par16./'

	  This example creates four files, cobol00 ... cobol03.	 After
	  editing the ``split''	files, they can	be recombined as
	  follows:

	       cat cobol0[0-3] > file

	  Note that this example overwrites the	original file.

	       csplit -k file  100  {99}

	  This example would split the file at every 100 lines,	up to
	  10,000 lines.	 The -k	option causes the created files	to be
	  retained if there are	less than 10,000 lines;	however, an
	  error	message	would still be printed.

	       csplit -k prog.c	 '%main(%'  '/^}/+1'  {20}

	  Assuming that	prog.c follows the normal C coding convention
	  of ending routines with a } at the beginning of the line,
	  this example will create a file containing each separate C
	  routine (up to 21) in	prog.c.















     Page 2					     (printed 3/20/91)






     CSPLIT(C)		    Altos UNIX System V		     CSPLIT(C)



     See Also
	  ed(C), sh(C),	regex(S)

     Diagnostics
	  Self-explanatory except for:
	  arg -	out of range

	  which	means that the given argument did not reference	a line
	  between the current position and the end of the file.

     Standards Conformance
	  csplit is conformant with:
	  AT&T SVID Issue 2, Select Code 307-127;
	  and The X/Open Portability Guide II of January 1987.









































     Page 3					     (printed 3/20/91)



