


     DIFF(C)		    Altos UNIX System V		       DIFF(C)



     Name
	  diff - compares two text files

     Syntax
	  diff [ -befh ] file1 file2

     Description
	  diff tells what lines	must be	changed	in two files to	bring
	  them into agreement.	If file1 or file2 is a dash (-), the
	  standard input is used.  If file1 or file2 is	a directory,
	  diff uses the	file in	that directory that has	the same name
	  as the file (file2 or	file1 respectively) it is compared to.
	  For example:

	       diff /tmp dog

	  compares the file named dog that is in the /tmp directory,
	  with the file	dog in the current directory.  The normal
	  output contains lines	of these forms:

	       n1 a n3,n4
	       n1,n2 d n3
	       n1,n2 c n3,n4

	  These	lines resemble ed commands to convert file1 into
	  file2.  The numbers after the	letters	pertain	to file2.  In
	  fact,	by exchanging a	for d and reading backward, one	may
	  ascertain equally how	to convert file2 into file1.  As in
	  ed, identical	pairs where n1 = n2 or n3 = n4 are abbreviated
	  as a single number.

	  Following each of these lines	come all the lines that	are
	  affected in the first	file flagged by	<, then	all the	lines
	  that are affected in the second file flagged by >.

	  The -b option	causes trailing	blanks (spaces and tabs) to be
	  ignored and other strings of blanks to compare equal.

	  The -e option	produces a script of a,	c and d	commands for
	  the editor ed, which will recreate file2 from	file1.	The -f
	  option produces a similar script, not	useful with ed,	in the
	  opposite order.  In connection with -e, the following	shell
	  procedure helps maintain multiple versions of	a file:

	       (shift; cat $*; echo '1,$p') | ed - $1

	  This works by	performing a set of editing operations on an
	  original ancestral file.  This is done by combining the
	  sequence of ed scripts given as all command line arguments
	  except the first.  These scripts are presumed	to have	been
	  created with diff in the order given on the command line.
	  The set of editing operations	is then	piped as an editing



     Page 1					     (printed 3/20/91)






     DIFF(C)		    Altos UNIX System V		       DIFF(C)



	  script to ed where all editing operations are	performed on
	  the ancestral	file given as the first	argument on the
	  command line.	The final version of the file is then printed
	  on the standard output.  Only	an ancestral file ($1) and a
	  chain	of version-to-version ed scripts ($2,$3,...) made by
	  diff need be on hand.

	  Except in rare circumstances,	diff finds the smallest
	  sufficient set of file differences.

	  The -h option	does a fast, less-rigorous job.	 It works only
	  when changed stretches are short and well separated, but the
	  files	can be of unlimited length.  The -e and	-f options
	  cannot be used with the -h option.

     Files
	  /tmp/d?????

	  /usr/lib/diffh (executable used when -h option is specified)

     See Also
	  cmp(C), comm(C), ed(C)

     Diagnostics
	  Exit status is 0 for no differences, 1 for some differences,
	  2 for	errors.

     Notes
	  Editing scripts produced under the -e	or -f option do	not
	  always work correctly	on lines consisting of a single	period
	  (.).

     Standards Conformance
	  diff is conformant with:
	  AT&T SVID Issue 2, Select Code 307-127;
	  and The X/Open Portability Guide II of January 1987.



















     Page 2					     (printed 3/20/91)



