


     GETOPT(C)		    Altos UNIX System V		     GETOPT(C)



     Name
	  getopt - parses command options

     Syntax
	  set -- `getopt optstring $*`

     Description
	  getopt is used to check and break up options in command
	  lines	for parsing by shell procedures.  optstring is a
	  string of recognized option letters (see getopt(S)).	If a
	  letter is followed by	a colon, the option is expected	to
	  have an argument which may or	may not	be separated from it
	  by whitespace.  The special option --	is used	to delimit the
	  end of the options.  getopt will place -- in the arguments
	  at the end of	the options, or	recognize it if	used
	  explicitly.  The shell arguments ($1 $2 . . .) are reset so
	  that each option is preceded by a dash (-) and in its	own
	  shell	argument. Each option argument is also in its own
	  shell	argument.

     Example
	  The following	code fragment shows how	one can	process	the
	  arguments for	a command that can take	the options a and b,
	  and the option o, which requires an argument:

	  set -	- `getopt abo: $*`
	  if [ $? != 0 ]
	  then
	       echo "usage: $0 [-a | -b] [-o <arg>]"
	       exit 2
	  fi
	  for i	in $*
	  do
	       case $i in
	       -a | -b)	 shift;	FLAG=$i;;
	       -o)	 OARG=$3; shift; shift;;
	       - -)	 shift;	   break;;
	       esac
	  done

	  This code will accept	any of the following as	equivalent:

	  cmd -aoarg
	  cmd -a -o arg
	  cmd -oarg -a
	  cmd -a -oarg --

     See Also
	  sh(C), getopt(S)

     Diagnostics
	  getopt prints	an error message on the	standard error when it



     Page 1					     (printed 3/20/91)






     GETOPT(C)		    Altos UNIX System V		     GETOPT(C)



	  encounters an	option letter not included in optstring.

     Notes
	  The ``Syntax'' given for this	utility	assumes	the user has a
	  sh(C)	shell.

     Standards Conformance
	  getopt is conformant with:
	  AT&T SVID Issue 2, Select Code 307-127.














































     Page 2					     (printed 3/20/91)



