


     LINENUM(F)		    Altos UNIX System V		    LINENUM(F)



     Name
	  linenum - line number	entries	in a common object file

     Syntax
	  #include  <linenum.h>

     Description
	  The cc command generates an entry in the object file for
	  each C source	line on	which a	breakpoint is possible [when
	  invoked with the -g option; see cc(CP)].  Users can then
	  reference line numbers when using the	appropriate software
	  test system [see sdb(CP)].  The structure of these line
	  number entries appears below.

	  struct  lineno
	  {
		  union
		  {
			 long	  l_symndx ;
			 long	  l_paddr ;
		  }		  l_addr ;
		  unsigned short  l_lnno ;
	  } ;

	  Numbering starts with	one for	each function.	The initial
	  line number entry for	a function has l_lnno equal to zero,
	  and the symbol table index of	the function's entry is	in
	  l_symndx.  Otherwise,	l_lnno is non-zero, and	l_paddr	is the
	  physical address of the code for the referenced line.	 Thus
	  the overall structure	is the following:

	  l_addr		   l_lnno

	  function symtab index	   0
	  physical address	   line
	  physical address	   line
	  ...

	  function symtab index	   0
	  physical address	   line
	  physical address	   line
	  ...


     See Also
	  cc(CP), sdb(CP), a.out(F)









     Page 1					     (printed 3/20/91)



