


     SCNHDR(F)		    Altos UNIX System V		     SCNHDR(F)



     Name
	  scnhdr - section header for a	common object file

     Syntax
	  #include  <scnhdr.h>

     Description
	  Every	common object file has a table of section headers to
	  specify the layout of	the data within	the file.  Each
	  section within an object file	has its	own header.  The C
	  structure appears below.

	  struct  scnhdr
	  {
		  char		  s_name[SYMNMLEN]; /* section name */
		  long		  s_paddr;     /* physical address */
		  long		  s_vaddr;     /* virtual address */
		  long		  s_size;      /* section size */
		  long		  s_scnptr;    /* file ptr to raw data */
		  long		  s_relptr;    /* file ptr to relocation */
		  long		  s_lnnoptr;   /* file ptr to line numbers */
		  unsigned short  s_nreloc;    /* # reloc entries */
		  unsigned short  s_nlnno;     /* # line number	entries	*/
		  long		  s_flags;     /* flags	*/
	  } ;

	  File pointers	are byte offsets into the file;	they can be
	  used as the offset in	a call to FSEEK	[see ldfcn(F)].	 If a
	  section is initialized, the file contains the	actual bytes.
	  An uninitialized section is somewhat different.  It has a
	  size,	symbols	defined	in it, and symbols that	refer to it.
	  But it can have no relocation	entries, line numbers, or
	  data.	 Consequently, an uninitialized	section	has no raw
	  data in the object file, and the values for s_scnptr,
	  s_relptr, s_lnnoptr, s_nreloc, and s_nlnno are zero.

     See Also
	  ld(CP), fseek(S), a.out(F)

















     Page 1					     (printed 3/20/91)



