


     PROF(M)		    Altos UNIX System V		       PROF(M)



     Name
	  prof - profile within	a function

     Syntax
	  #define MARK
	  #include <prof.h>

	  void MARK (name)

     Description
	  MARK will introduce a	mark called name that will be treated
	  the same as a	function entry point. Execution	of the mark
	  will add to a	counter	for that mark, and program-counter
	  time spent will be accounted to the immediately preceding
	  mark or to the function if there are no preceding marks
	  within the active function.

	  Name may be any valid	C identifier.  Each name in a single
	  compilation must be unique, but may be the same as any
	  ordinary program symbol.

	  For marks to be effective, the symbol	MARK must be defined
	  before the header file <prof.h> is included.	This may be
	  defined by a preprocessor directive as in the	synopsis or by
	  a command line argument, i.e:

	       cc -p -DMARK foo.c

	  If MARK is not defined, the MARK(name) statements may	be
	  left in the source files containing them and will be
	  ignored.
























     Page 1					     (printed 3/20/91)






     PROF(M)		    Altos UNIX System V		       PROF(M)



     Examples
	  In this example, marks can be	used to	determine how much
	  time is spent	in each	loop.  Unless this example is compiled
	  with MARK defined on the command line, the marks are
	  ignored.

	  #include <prof.h>
	  foo( )
	  {
	       int i, j;
	       .
	       .
	       .
	       MARK(loop1);
	       for (i =	0; i < 2000; i++) {
		    . .	.
	       }
	       MARK(loop2);
	       for (j =	0; j < 2000; j++) {
		    . .	.
	       }
	  }

     See Also
	  prof(C), profil(S), monitor(S)






























     Page 2					     (printed 3/20/91)



